#ifndef SCHEDULING_MANAGER_H
#define SCHEDULING_MANAGER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "Configurable.h"

class Event;
class SimulationObject;
class TimeWarpEventSet;
class SchedulingData;

/** The SchedulingManager abstract base class.

This is the abstract base class for all scheduler implementations in
the kernel. Different scheduler implementations must be derived from 
this abstract class.  

*/
class SchedulingManager : virtual public Configurable {
public:
  /**@name Public Class Methods of SchedulingManager. */
  //@{
   
  /// Virtual Destructor.
  virtual ~SchedulingManager(){};
  
  /**
     Ask the scheduler which event is next.
  */
  virtual const Event *peekNextEvent() = 0;

  /** Get the timestamp of the last event that was scheduled.

  This is a pure virtual function that has to be overriden.

  @return Timestamp of the last event that was scheduled for execution.
  */
  virtual const VTime &getLastEventScheduledTime() = 0;

  //@} // End of Public Class Methods of SchedulingManager.
protected:
  /**@name Protected Class Methods of SchedulingManager. */
  //@{

  /// Default Constructor.
  SchedulingManager() {};

  //@} // End of Protected Class Methods of SchedulingManager.
};

#endif
