#include "OutputEvents.h"
#include "EventFunctors.h"
#include <algorithm>

vector<const Event *> *
OutputEvents::getEventsSentAtOrAfter( const VTime &searchTime ){
  vector<const Event *> *retval = new vector<const Event *>;
  
  vector<const Event *>::iterator relevantEventsEnd = 
    std::partition( outputEvents.begin(),
		    outputEvents.end(),
		    sendTimeGreaterThanEqual( searchTime ) );
  
  retval->insert( retval->begin(),
		  outputEvents.begin(),
		  relevantEventsEnd );

  return retval;
}

void
OutputEvents::garbageCollect( const VTime &gCollectTime ){
  outputEvents.erase( remove_if( outputEvents.begin(),
				 outputEvents.end(),
				 sendTimeLessThanEqual( gCollectTime )),
		      outputEvents.end() );
}

