// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: VTime.cpp
// 
//---------------------------------------------------------------------------

#include "IntVTime.h"
#include "Serializable.h"
#include "SerializedInstance.h"
#include "DeserializerManager.h"
#include <clutils/StringUtilities.h>
#include <string>
#include <typeinfo>
#include <iostream>
using std::cerr;
using std::endl;


const VTime &
IntVTime::getIntVTimeZero(){
  static const IntVTime ZERO = IntVTime( 0 );
  return ZERO;
}

const VTime &
IntVTime::getIntVTimePositiveInfinity(){ 
  static const IntVTime PINFINITY = IntVTime( warped32Max );
  return PINFINITY; 
}

void 
IntVTime::serialize( SerializedInstance *serialized ) const {
  serialized->addInt( getTime() );
}

Serializable *
IntVTime::deserialize( SerializedInstance *serialized ){
  warped64_t time = serialized->getInt();
  IntVTime *retval = new IntVTime( time );
  return retval;
}

// We might be able to move this to VTime
void 
IntVTime::registerDeserializer(){
  assert (DeserializerManager::instance() != 0);
  DeserializerManager::instance()->registerDeserializer( getIntVTimeDataType(),
							 &deserialize );
}

const VTime&
IntVTime::operator= ( const VTime &rhs){
  const IntVTime &intVrhs = dynamic_cast<const IntVTime&> (rhs);
  myTime = intVrhs.getTime();

  return *this;
}

bool
IntVTime::operator< (const VTime &rhs) const {
  const IntVTime &intVrhs = dynamic_cast<const IntVTime&>(rhs);
  return myTime < intVrhs.getTime();
}

bool
IntVTime::operator> (const VTime &rhs) const {
  const IntVTime& intVrhs = dynamic_cast<const IntVTime&> (rhs);
  return myTime > intVrhs.getTime();
}

bool
IntVTime::operator==( const VTime &rhs )const {
  const IntVTime& intVrhs = dynamic_cast<const IntVTime&>(rhs);
  return myTime == intVrhs.getTime();
}

bool
IntVTime::operator!= (const VTime &rhs) const {
  const IntVTime& intVrhs = dynamic_cast<const IntVTime&>(rhs);
  return myTime != intVrhs.getTime();
}

bool
IntVTime::operator<= (const VTime &rhs) const{
  const IntVTime &intVrhs = dynamic_cast<const IntVTime&> (rhs);
  return myTime <= intVrhs.getTime();
}

bool
IntVTime::operator>= (const VTime &rhs) const {
  const IntVTime& intVrhs = dynamic_cast<const IntVTime&> (rhs);
  return myTime >= intVrhs.getTime();
}


const IntVTime&
IntVTime::operator=( const IntVTime &rhs ){
  myTime = rhs.getTime();
  return *this;
}

bool
IntVTime::operator< (const IntVTime &right) const {
  return myTime < right.getTime();
}


bool
IntVTime::operator> (const IntVTime &right) const {
  return myTime > right.getTime();
}

/// Overloaded operator
bool
IntVTime::operator== (const IntVTime &right) const {
  return myTime == right.getTime();
}

/// Overloaded operator
bool
IntVTime::operator!= (const IntVTime &right) const {
  return myTime != right.getTime();
}

/// Overloaded operator
bool
IntVTime::operator<= (const IntVTime &right) const {
  return myTime <= right.getTime();
}

/// Overloaded operator
bool
IntVTime::operator>= (const IntVTime &right) const {
  return myTime >= right.getTime();
}


const IntVTime
IntVTime::operator+ (const IntVTime &right) const {
  return IntVTime ( myTime + right.getTime() );
}

const IntVTime
IntVTime::operator- (const IntVTime &right) const {
  return IntVTime ( myTime + right.getTime() );
}

const IntVTime
IntVTime::operator+ (int right) const {
  return IntVTime( myTime + right );
}

const IntVTime
IntVTime::operator- (int right) const {
  return IntVTime( myTime - right );
}


const string
IntVTime::toString() const {
  return intToString( myTime );
}
