# -*- coding: UTF-8 -*-
'''
Wammu - Phone manager
Some static data like bitmaps, category mappings etc.
Many of them might be moved to python-gammu later
'''
__author__ = 'Michal Čihař'
__email__ = 'michal@cihar.com'
__license__ = '''
Copyright (c) 2003 - 2006 Michal Čihař

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License version 2 as published by
the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
'''

import sys
from Wammu.Utils import Str_ as _

# When support for sound will be implemented, here should be sounds
PredefinedSounds = [
        (_('Chimes high'),''),
        (_('Chimes low'),''),
        (_('Ding'),''),
        (_('TaDa'),''),
        (_('Notify'),''),
        (_('Drum'),''),
        (_('Claps'),''),
        (_('Fanfare'),''),
        (_('Chord high'),''),
        (_('Chord low'),''),
        ]

# Wanted somebody who will draw nicer icons :-)

Note = [
    '16 16 2 1',
    'x c Black',
    '  c None',
    '      xx        ',
    '      xxx  xxx  ',
    '      xxxxxxxxx ',
    '      xx  xx  xx',
    '      xx        ',
    '      xx        ',
    '      xx        ',
    '      xx        ',
    '  xxxxxx        ',
    ' xxxxxxx        ',
    'xxxxxxxx        ',
    'xxxxxxxx        ',
    'x  xxxxx        ',
    'x   xxxx        ',
    ' x  xxx         ',
    '  xxxx          ']

UnknownPredefined = [
    '16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '    x      x    ',
    '   x  xxxx  x   ',
    '   x x    x x   ',
    '    x     x x   ',
    '          x x   ',
    '         x x    ',
    '        x x     ',
    '       x x      ',
    '       x x      ',
    '       xx       ',
    '                ',
    '       xx       ',
    '      xxxx      ',
    '      x xx      ',
    '       xx       ']

PredefinedAnimations = [
    (_("I'm ironic, flirty"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   x      x   x',
    ' x   x    x   x ',
    ' x    x  x    x ',
    '  x    xx    x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am glad"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   x      x   x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am skeptic"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   xxxxx      x',
    ' x       x    x ',
    ' x        x   x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am sad"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x     xxxx     x',
    ' x   x    x   x ',
    ' x  x      x  x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("WOW"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x     xxxx     x',
    'x    x    x    x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am crying"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x     x    x   x',
    'x              x',
    'x              x',
    'x     xxxx     x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am winking"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x       xx   x ',
    'x  xxxx  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   x      x   x',
    ' x   xxxxxx   x ',
    ' x            x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am laughing"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   x      x   x',
    ' x   xxxxxx   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am indifferent"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x            x ',
    ' x   xxxxxx   x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am in love"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxx xx xx ',
    '   xx    x  x  x',
    '  x       x   x ',
    ' x         x x  ',
    ' x  xx   xx x x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am confused"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx xx  ',
    '   xx      x  x ',
    '  x           x ',
    ' x           x  ',
    ' x  xx   xx    x',
    'x   x x  x x x x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x   xxxxx    x ',
    ' x            x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("Tongue hanging out"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x         x  x ',
    ' x    xxxxx x x ',
    '  x     xx   x  ',
    '   xx     x   x ',
    '     xxxxxxxxx  ']),
    (_("I am angry"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x x        x x ',
    ' x  xx   xxx  x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x     xxxx     x',
    ' x   x    x   x ',
    ' x  x      x  x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("Wearing glases"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    'xxxxxxxxxxxxxxxx',
    'x   xxx  xxx   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x  x      x  x ',
    ' x   xxxxxx   x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("Devil"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    'x    xxxxxx    x',
    'xxxxx      xxxxx',
    ' xx          xx ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x   xxxxxxxx   x',
    'x   x x  x x   x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    ]

# FIXME: these definitions probably should be part of gammu module and not this...
# First is used as default
Models = [
    'auto',
    'at',
    'alcatel',
    'nauto',
    'obex',
    'seobex',
    ]
Connections = [
    'at19200',
    'at115200',
    'fbus',
    'fbusirda',
    'fbusdlr3',
    'fbusdku5',
    'mbus',
    'irdaphonet',
    'irdaat',
    'irdaobex',
    'dku2phonet',
    'dku5fbus2',
    'bluerffbus',
    'bluerfphonet',
    'bluephonet',
    'bluerfat',
    'blueat',
    'fbuspl2303',
    ]

Conn_Cable = [
    'at19200',
    'at115200',
    'fbusdlr3',
    'fbus',
    'mbus',
    'fbuspl2303',
    ]
Conn_IrDA_Win = [
    'irdaphonet',
    'irdaat',
    ]
Conn_IrDA_Other = [
    'irdaphonet',
    'at19200',
    ]
Conn_BlueRF = [
    'at19200',
    ]
Conn_Bluetooth = [
    'bluephonet',
    'bluefbus',
    'bluerfgnapbus',
    'blueat',
    'bluerfphonet',
    'bluerffbus',
    'bluerfat',
    ]
if sys.platform == 'win32':
    Devices = [
        '',
        'com1:',
        'com2:',
        'com3:',
        'com4:',
        'com5:',
        'com6:',
        ]
    AllDevices = [
        (Conn_IrDA_Win, '', None),
        (Conn_Cable, 'com%d:', (1,6)),
        ]
# FIXME: support more platforms?
else:
    Devices = [
        '/dev/ttyS0',
        '/dev/ttyS1',
        '/dev/ttyUSB0',
        '/dev/ttyUSB1',
        '/dev/ttyACM0',
        '/dev/ttyACM1',
        '/dev/ircomm0',
        '/dev/usb/tts/0',
        ]
    AllDevices = [
        (Conn_Cable, '/dev/ttyS%d', (0, 3)),
        (Conn_Cable, '/dev/ttyUSB%d', (0, 3)),
        (Conn_Cable, '/dev/ttyACM%d', (0, 3)),
        (Conn_BlueRF, '/dev/rfrcomm%d', (0, 1)),
        (Conn_IrDA_Other, '/dev/ircomm%d', (0, 1)),
        (Conn_Cable, '/dev/usb/tts/%d', (0, 3)),
        ]

ContactMemoryTypes = ['ME', 'SM']

SMSIDs = {
    'Text':                 [
        'Text',
        'ConcatenatedTextLong',
        'ConcatenatedAutoTextLong',
        'ConcatenatedTextLong16bit',
        'ConcatenatedAutoTextLong16bit',
        ],
    'Sound':                [
        'NokiaProfileLong',
        'NokiaRingtone',
        'NokiaRingtoneLong',
        'EMSSound10',
        'EMSSound12',
        'EMSSonyEricssonSound',
        'EMSSound10Long',
        'EMSSound12Long',
        'EMSSonyEricssonSoundLong',
        ],
    'Animation':            [
        'NokiaProfileLong',
        'EMSAnimation',
        'AlcatelMonoAnimationLong',
        'NokiaScreenSaverLong',
        ],
    'Bitmap':               [
        'NokiaProfileLong',
        'NokiaPictureImageLong',
        'NokiaOperatorLogo',
        'NokiaOperatorLogoLong',
        'NokiaCallerLogo',
        'EMSFixedBitmap',
        'EMSVariableBitmap',
        'EMSVariableBitmapLong',
        'AlcatelMonoBitmapLong',
        'AlcatelSMSTemplateName',
        ],
    'PredefinedAnimation':  [
        'EMSPredefinedAnimation',
        ],
    'PredefinedSound':      [
        'EMSPredefinedSound',
        ],
    }



MemoryValueTypes = [
    'Number_General',
    'Number_Mobile',
    'Number_Work',
    'Number_Fax',
    'Number_Home',
    'Number_Pager',
    'Number_Other',
    'Text_Note',
    'Text_Postal',
    'Text_Email',
    'Text_Email2',
    'Text_URL',
    'Date',
    'Caller_Group',
    'Text_Name',
    'Text_LastName',
    'Text_FirstName',
    'Text_Company',
    'Text_JobTitle',
    'Category',
    'Private',
    'Text_StreetAddress',
    'Text_City',
    'Text_State',
    'Text_Zip',
    'Text_Country',
    'Text_Custom1',
    'Text_Custom2',
    'Text_Custom3',
    'Text_Custom4',
    'Text_UserID',
    'RingtoneID',
    'RingtoneFileSystemID',
    'PictureID',
    'SMSListID',
    'CallLength',
    ]

CalendarTypes = [
    'REMINDER',
    'CALL',
    'MEETING',
    'BIRTHDAY',
    'MEMO',
    'TRAVEL',
    'VACATION',
    'T_ATHL',
    'T_BALL',
    'T_CYCL',
    'T_BUDO',
    'T_DANC',
    'T_EXTR',
    'T_FOOT',
    'T_GOLF',
    'T_GYM',
    'T_HORS',
    'T_HOCK',
    'T_RACE',
    'T_RUGB',
    'T_SAIL',
    'T_STRE',
    'T_SWIM',
    'T_TENN',
    'T_TRAV',
    'T_WINT',
    'ALARM',
    'DAILY_ALARM',
    ]

CalendarValueTypes = [
    'START_DATETIME',
    'END_DATETIME',
    'ALARM_DATETIME',
    'SILENT_ALARM_DATETIME',
    'RECURRANCE',
    'TEXT',
    'LOCATION',
    'PHONE',
    'PRIVATE',
    'CONTACTID',
    'REPEAT_DAYOFWEEK',
    'REPEAT_DAY',
    'REPEAT_WEEKOFMONTH',
    'REPEAT_MONTH',
    'REPEAT_FREQUENCY',
    'REPEAT_STARTDATE',
    'REPEAT_STOPDATE',
    ]

TodoPriorities = [
    'High',
    'Medium',
    'Low',
    'None',
    ]

TodoValueTypes = [
    'END_DATETIME',
    'COMPLETED',
    'ALARM_DATETIME',
    'SILENT_ALARM_DATETIME',
    'TEXT',
    'PRIVATE',
    'CATEGORY',
    'CONTACTID',
    'PHONE',
    ]

TextFormats = [
    [(_('Alignment'), _('None')),
        ('Left', _('Left'), '<div align="left">%s</div>'),
        ('Right', _('Right'), '<div align="right">%s</div>'),
        ('Center', _('Center'), '<div align="center">%s</div>'),
        ],
    [(_('Text Size'), _('Normal')),
        ('Large', _('Large'), '<font size="+2">%s</font>'),
        ('Small', _('Small'), '<font size="-2">%s</font>'),
        ],
    ['', ('Bold', _('Bold'), '<b>%s</b>')],
    ['', ('Italic', _('Italic'), '<i>%s</i>')],
    ['', ('Underlined', _('Underlined'), '<u>%s</u>')],
    ['', ('Strikethrough', _('Strikethrough'), '<strike>%s</strike>')],
]

InternationalPrefixes = [
    '+1',
    '+20',

    '+210',
    '+211',
    '+212',
    '+213',
    '+214',
    '+215',
    '+216',
    '+217',
    '+218',
    '+219',


    '+220',
    '+221',
    '+222',
    '+223',
    '+224',
    '+225',
    '+226',
    '+227',
    '+228',
    '+229',


    '+230',
    '+231',
    '+232',
    '+233',
    '+234',
    '+235',
    '+236',
    '+237',
    '+238',
    '+239',


    '+240',
    '+241',
    '+242',
    '+243',
    '+244',
    '+245',
    '+246',
    '+247',
    '+248',
    '+249',


    '+250',
    '+251',
    '+252',
    '+253',
    '+254',
    '+255',
    '+256',
    '+257',
    '+258',
    '+259',


    '+260',
    '+261',
    '+262',
    '+263',
    '+264',
    '+265',
    '+266',
    '+267',
    '+268',
    '+269',
    '+27',
    '+28',

    '+290',
    '+291',
    '+292',
    '+293',
    '+294',
    '+295',
    '+296',
    '+297',
    '+298',
    '+299',
    '+30',
    '+31',
    '+32',
    '+33',
    '+34',

    '+350',
    '+351',
    '+352',
    '+353',
    '+354',
    '+355',
    '+356',
    '+357',
    '+358',
    '+359',
    '+36',

    '+370',
    '+371',
    '+372',
    '+373',
    '+374',
    '+375',
    '+376',
    '+377',
    '+378',
    '+379',


    '+380',
    '+381',
    '+382',
    '+383',
    '+384',
    '+385',
    '+386',
    '+387',
    '+388',
    '+389',
    '+39',
    '+40',
    '+41',

    '+420',
    '+421',
    '+422',
    '+423',
    '+424',
    '+425',
    '+426',
    '+427',
    '+428',
    '+429',
    '+43',
    '+44',
    '+45',
    '+46',
    '+47',
    '+48',
    '+49',

    '+500',
    '+501',
    '+502',
    '+503',
    '+504',
    '+505',
    '+506',
    '+507',
    '+508',
    '+509',
    '+51',
    '+52',
    '+53',
    '+54',
    '+55',
    '+56',
    '+57',
    '+58',

    '+590',
    '+591',
    '+592',
    '+593',
    '+594',
    '+595',
    '+596',
    '+597',
    '+598',
    '+599',
    '+60',
    '+61',
    '+62',
    '+63',
    '+64',
    '+65',
    '+66',

    '+670',
    '+671',
    '+672',
    '+673',
    '+674',
    '+675',
    '+676',
    '+677',
    '+678',
    '+679',


    '+680',
    '+681',
    '+682',
    '+683',
    '+684',
    '+685',
    '+686',
    '+687',
    '+688',
    '+689',


    '+690',
    '+691',
    '+692',
    '+693',
    '+694',
    '+695',
    '+696',
    '+697',
    '+698',
    '+699',
    '+7',

    '+800',
    '+801',
    '+802',
    '+803',
    '+804',
    '+805',
    '+806',
    '+807',
    '+808',
    '+809',
    '+81',
    '+82',
    '+83',
    '+84',

    '+850',
    '+851',
    '+852',
    '+853',
    '+854',
    '+855',
    '+856',
    '+857',
    '+858',
    '+859',
    '+86',

    '+870',
    '+871',
    '+872',
    '+873',
    '+874',
    '+875',
    '+876',
    '+877',
    '+878',
    '+879',


    '+880',
    '+881',
    '+882',
    '+883',
    '+884',
    '+885',
    '+886',
    '+887',
    '+888',
    '+889',
    '+89',
    '+90',
    '+91',
    '+92',
    '+93',
    '+94',
    '+95',

    '+960',
    '+961',
    '+962',
    '+963',
    '+964',
    '+965',
    '+966',
    '+967',
    '+968',
    '+969',


    '+970',
    '+971',
    '+972',
    '+973',
    '+974',
    '+975',
    '+976',
    '+977',
    '+978',
    '+979',
    '+98',

    '+990',
    '+991',
    '+992',
    '+993',
    '+994',
    '+995',
    '+996',
    '+997',
    '+998',
    '+999',
    ]
