[![Codacy Badge](https://api.codacy.com/project/badge/Grade/6e930e3c0f5a4a9b83aa3362cfdd21e1)](https://www.codacy.com/manual/votca-package/xtp?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=votca/xtp&amp;utm_campaign=Badge_Grade)
[![codecov](https://codecov.io/gh/votca/xtp/branch/master/graph/badge.svg)](https://codecov.io/gh/votca/xtp)
[![Build Status](https://travis-ci.org/votca/xtp.svg?branch=master)](https://travis-ci.org/votca/xtp)
[![pipeline status](https://gitlab.com/votca/xtp/badges/master/pipeline.svg)](https://gitlab.com/votca/xtp/commits/master)
[![DOI](https://zenodo.org/badge/50048374.svg)](https://zenodo.org/badge/latestdoi/50048374)

VOTCA-XTP is a library which allows you to calculate the electronic properties of organic materials, e.g.
- excited state properties via GW-BSE
- spectra using QM/MM in conjunction with excited state treatment via GW-BSE
- energetic disorder for electrons/holes and excitions via QM/MM or fast MM/MM multipole methods
- electron and hole mobilities using electronic couplings and kinetic Monte-Carlo
- electron, hole, singlet and triplet diffusion constants using electronic couplings and kinetic Monte-Carlo

Installation instructions and developer information can be found
[here](https://github.com/votca/votca/blob/master/share/doc/INSTALL.md)

For other questions, we provide an email list:

[google group](https://groups.google.com/forum/#!forum/votca)

and a slack channel:

[Slack](https://votca.slack.com/messages/C7XVBE9EG/?)

We have no manual for the moment but we have a complete tutorial here:

[Tutorial](https://github.com/votca/xtp-tutorials)

The development of VOTCA is mainly funded by academic research grants. If you
use this package, please cite the VOTCA papers:

* Electronic Excitations in Complex Molecular Environments: Many-Body Green’s
  Functions Theory in VOTCA-XTP Jens Wehner, Lothar Brombacher, Joshua Brown,
  Christoph Junghans, Onur Caylak, Yuriy Khalak, Pranav Madhikar, Gianluca
  Tirimbo, Björn Baumeier J. Chem. Theory Comput. 14, 6353 (2018).

* Microscopic simulations of charge transport in disordered organic
  semiconductors V. Ruehle, A. Lukyanov, F. May, M. Schrader, T. Vehoff, J.
  Kirkpatrick, B. Baumeier and D. Andrienko J. Chem. Theo. Comp. 7, 3335-3345
  (2011)

* Versatile Object-oriented Toolkit for Coarse-graining Applications, V.Ruehle,
  C. Junghans, A. Lukyanov, K. Kremer, D. Andrienko, J. Chem. Theo. Comp. 5
  (12), 3211 (2009)

In case of questions, please post them in the google discussion group for votca
at <http://groups.google.com/group/votca-xtp>

You can contact the VOTCA Development Team at devs@votca.org.
