#!/bin/bash
# +-----------------------------------------------------------+
# |                                                           |
# | use this script to generate some mode lines automatically |
# | with videogen.                                            |
# |                                                           |
# | (c) Szabolcs Rumi, 1997-2001                              |
# |                                                           |
# +-----------------------------------------------------------+

# you may change this to the location of the videogen program
VIDEOGEN="videogen"

# set this to the maximum dot clock your video card can generate [MHz]
DOTCLOCK="225"

# set this to the maximum horizontal refresh rate of your monitor [kHz]
HORIZ="64"

# set this to the maximum vertical refresh rate of your monitor [Hz]
VERT="120"

# set this to the minimum horizontal sync pulse length of your monitor [us]
MINSYNC="1"

# these lines were inserted to warn you not to forget to change the above vars
# which are set to my hardware parameters by default
echo -n [1m
echo --------------------------------------------------------------------------
echo Don\'t forget to look into the script, change the parameters to match
echo your hardware configuration, and maybe comment out these lines there if
echo you need a clean output for redirection or such.
echo Now added the same modelines as timings for the framebuffer device.
echo Use fbset directly or enter them into /etc/fb.modes. Take a look at the
echo manpages fbset\(1\) and fb.modes\(5\) to see what this is about.
echo --------------------------------------------------------------------------
echo -n [0m

# these are the lines printing out the main thing
echo Modeline `$VIDEOGEN -s -width=640 -height=400 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo Modeline `$VIDEOGEN -s -width=640 -height=480 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo Modeline `$VIDEOGEN -s -width=800 -height=600 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo Modeline `$VIDEOGEN -s -width=1024 -height=768 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo Modeline `$VIDEOGEN -s -width=1152 -height=864 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo Modeline `$VIDEOGEN -s -width=1280 -height=1024 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo Modeline `$VIDEOGEN -s -width=1600 -height=1200 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo timings `$VIDEOGEN -s -fb -width=640 -height=400 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo timings `$VIDEOGEN -s -fb -width=640 -height=480 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo timings `$VIDEOGEN -s -fb -width=800 -height=600 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo timings `$VIDEOGEN -s -fb -width=1024 -height=768 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo timings `$VIDEOGEN -s -fb -width=1152 -height=864 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo timings `$VIDEOGEN -s -fb -width=1280 -height=1024 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`
echo timings `$VIDEOGEN -s -fb -width=1600 -height=1200 -clk=$DOTCLOCK -hf=$HORIZ -vf=$VERT -hsync=$MINSYNC`

# EOF
