/*
                            Process Console

	Executes and displays a process stdout and stderr messages.
 */

#ifndef PROCCON_H
#define PROCCON_H

#include <gtk/gtk.h>

/*
 *	Display flags:
 */
#define PROCCON_DISPLAY_STDOUT		(1 << 0)
#define PROCCON_DISPLAY_STDERR		(1 << 1)


extern GtkWidget *ProcConNew(guint display_flags);

extern gchar *ProcConGetText(GtkWidget *w);
extern void ProcConClear(GtkWidget *w);

extern gint ProcConExecuteNotify(
        GtkWidget *w, const gchar *cmd,
        gpointer client_data,
        void (*termination_cb)(GtkWidget *, gint, gpointer)
);
extern gint ProcConExecute(GtkWidget *w, const gchar *cmd);
extern gint ProcConGetPid(GtkWidget *w);
#define ProcConIsRunning(w)	\
	((ProcConGetPid(w) > 0) ? TRUE : FALSE)
extern void ProcConKill(GtkWidget *w);




#endif	/* PROCCON_H */
