/*
	Messages in the format of lists suitable for use with msglist.h

	Last two pointers (even aligned) of any msglist must be NULL and
	NULL (respectivly).
 */

#ifndef MESSAGES_H
#define MESSAGES_H


/* *********************************************************** */
/* Standard messages. */

#define VMA_MSGNAME_STD_HELP				"HELP"
#define VMA_MSGNAME_STD_COPYRIGHT			"COPYRIGHT"

/* Message list for standard messages. */
#define VMA_MSGLIST_STD_MESSAGE_LIST		{ \
	VMA_MSGNAME_STD_HELP, \
"Usage: vertex [file] [options] [GUI_options]\n\
\n\
    [file] is the V3D model file to load on startup.\n\
\n\
    [options] can be any of the following:
\n\
        --rcfile <file>         Load configuration from <file>.\n\
        --config_file <file>    Same as --rcfile.\n\
        -f <file>               Same as --rcfile.\n\
        --disable_plugins	Do not load plug-ins on startup.\n\
	--no_splash		Do not show splash/load status on startup.\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    Most customizations can be performed in the preferences window,\n\
    go to Edit->Preferences...\n\
\n\
    Command line options override any options in the configuration\n\
    file.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult\n\
    your GUI's manual for available options.\n\
\n", \
 \
	VMA_MSGNAME_STD_COPYRIGHT, \
"Copyright (C) 1999-2001 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law.", \
 \
	NULL, NULL \
}


/* *********************************************************** */
/* Tip of day messages. */
#define VMA_MSGNAME_TOD_WELCOME				"WELCOME"
#define VMA_MSGNAME_TOD_DND				"DND"
#define VMA_MSGNAME_TOD_COMMENTS			"COMMENTS"
#define VMA_MSGNAME_TOD_POINTER_TRANSLATE		"POINTER_TRANSLATE"
#define VMA_MSGNAME_TOD_VIEW_BACKGROUND			"VIEW_BACKGROUND"
#define VMA_MSGNAME_TOD_TEXURES_BASE_OVERRIDE		"TEXURES_BASE_OVERRIDE"
#define VMA_MSGNAME_TOD_SCRATCHPAD			"SCRATCHPAD"
#define VMA_MSGNAME_TOD_PLUGINS				"PLUGINS"
#define VMA_MSGNAME_TOD_LIGHTING			"LIGHTING"


/* Message list for tip of day messages. */
#define VMA_MSGLIST_TOD_MESSAGE_LIST		{ \
        VMA_MSGNAME_TOD_WELCOME, \
"Welcome to Vertex 3D Model Assembler!\n\
\n\
Please take a moment to review the preferences, they\n\
should be reviewed periodically and whenever upgrading\n\
to a new version.\n\
\n\
The latest releases, plug-ins, and documentation can be found\n\
at http://wolfpack.twu.net/Vertex/", \
 \
	VMA_MSGNAME_TOD_DND, \
"You can use drag and drop operations on the models or\n\
primitives lists to do some quick reordering.\n\
\n\
You can also copy one or more primitives by selecting\n\
the primitives while holding the CTRL key down then\n\
dragging them to their new location where they will be\n\
duplicated.", \
 \
	VMA_MSGNAME_TOD_COMMENTS, \
"Use caution when adding comments anywhere, they\n\
may be interprited by third party applications\n\
as proprietery commands.\n\
\n\
It is generally safest to start a comment line with\n\
a # character. Use proprietery commands only when\n\
you are sure about their behavour.", \
 \
	VMA_MSGNAME_TOD_POINTER_TRANSLATE, \
"You can translate an entire visual primitive by\n\
simply selecting it but not any of its vertices.\n\
\n\
Drag it by holding Button2 down and moving it to\n\
its desired location.", \
 \
	VMA_MSGNAME_TOD_VIEW_BACKGROUND, \
"You can set an image as the background to any of the\n\
views, by simply pressing Button3 on the view and selecting\n\
Set Background Image...\n\
\n\
This background image can then be used as a visual referance\n\
to whatever you are trying to model.", \
 \
	VMA_MSGNAME_TOD_TEXURES_BASE_OVERRIDE, \
"If you do not want to specify a texture base directory\n\
in your model's header, then you can enable Texture Base\n\
Directory Override on the Texture Browser.\n\
\n\
This will instruct the program to load textures from the\n\
specified directory in the Texture Browser and not from\n\
the model file (regardless if it is defined in the model\n\
file or not).", \
 \
	VMA_MSGNAME_TOD_SCRATCHPAD, \
"The ScratchPad can be used to record many vertices\n\
independently from your model. The recorded vertices can\n\
then be set to other primitives, allowing the precise\n\
and controled distribution of similar coordinates amoung\n\
vertices.\n\
\n\
To see the ScratchPad, go to Windows->ScratchPad...", \
 \
	VMA_MSGNAME_TOD_PLUGINS, \
"Plug-ins are available on certain platforms such as Linux and\n\
Solaris/Sun. If you need extended features or support\n\
(ie support for alternate file formats), then take a look at\n\
http://wolfpack.twu.net/Vertex/ for the latest plug-ins.", \
 \
	VMA_MSGNAME_TOD_LIGHTING, \
"To enable lighting on the 3d view, make sure that rendering\n\
and atleast one light is enabled. You can move a light quickly\n\
by setting a new cursor position and then clicking on the\n\
Light Button->Move To Cursor.\n\
\n\
Light position and attributes are also saved as extranous\n\
comments in the model file.", \
 \
	/* Last two items are NULL. */ \
	NULL, NULL \
}


/* *********************************************************** */
/* For Editor: */
/* Message names for editor tooltip messages. */
#define VMA_MSGNAME_EDITOR_MODELFILE_NEW		"MODELFILE_NEW"
#define VMA_MSGNAME_EDITOR_MODELFILE_OPEN		"MODELFILE_OPEN"
#define VMA_MSGNAME_EDITOR_MODELFILE_SAVE		"MODELFILE_SAVE"
#define VMA_MSGNAME_EDITOR_MODELFILE_SAVEAS		"MODELFILE_SAVEAS"
#define VMA_MSGNAME_EDITOR_BACKUP			"BACKUP"
#define VMA_MSGNAME_EDITOR_BACKUP_SETTINGS		"BACKUP_SETTINGS"
#define VMA_MSGNAME_EDITOR_REVERT			"REVERT"
#define VMA_MSGNAME_EDITOR_EXPORT			"EXPORT"
#define VMA_MSGNAME_EDITOR_IMPORT			"IMPORT"
#define VMA_MSGNAME_EDITOR_PRINT			"PRINT"
#define VMA_MSGNAME_EDITOR_CLOSE			"CLOSE"
#define VMA_MSGNAME_EDITOR_EXIT				"EXIT"
#define VMA_MSGNAME_EDITOR_UNDO				"UNDO"
#define VMA_MSGNAME_EDITOR_REDO				"REDO"
#define VMA_MSGNAME_EDITOR_CUT				"CUT"
#define VMA_MSGNAME_EDITOR_COPY				"COPY"
#define VMA_MSGNAME_EDITOR_PASTE			"PASTE"
#define VMA_MSGNAME_EDITOR_CLIPBOARD			"CLIPBOARD"
#define VMA_MSGNAME_EDITOR_WRITE_PROTECT_ENABLED	"WRITE_PROTECT_ENABLED"
#define VMA_MSGNAME_EDITOR_WRITE_PROTECT_DISABLED	"WRITE_PROTECT_DISABLED"
#define VMA_MSGNAME_EDITOR_MODEL_HEADER			"MODEL_HEADER"
#define VMA_MSGNAME_EDITOR_SYNC_MEMORY			"SYNC_MEMORY"
#define VMA_MSGNAME_EDITOR_PREFERENCES			"PREFERENCES"
#define VMA_MSGNAME_EDITOR_MODEL_CREATE			"MODEL_CREATE"
#define VMA_MSGNAME_EDITOR_MODEL_DELETE			"MODEL_DELETE"
#define VMA_MSGNAME_EDITOR_MODEL_SHOW			"MODEL_SHOW"
#define VMA_MSGNAME_EDITOR_MODEL_PROPERTIES		"MODEL_PROPERTIES"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_CREATE		"PRIMITIVE_CREATE"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_DELETE		"PRIMITIVE_DELETE"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_FLIP_WINDING	"PRIMITIVE_FLIP_WINDING"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_UNITLIZE_NORMAL	"PRIMITIVE_UNITIZE_NORMAL"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_TRANSLATE		"PRIMITIVE_TRANSLATE"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_ROTATE		"PRIMITIVE_ROTATE"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_SCALE		"PRIMITIVE_SCALE"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_MIRROR		"PRIMITIVE_MIRROR"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_SNAP		"PRIMITIVE_SNAP"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_ADD_VERTEX		"PRIMITIVE_ADD_VERTEX"
#define VMA_MSGNAME_EDITOR_PRIMITIVE_REMOVE_VERTEX	"PRIMITIVE_REMOVE_VERTEX"
#define VMA_MSGNAME_EDITOR_SCRATCH_PAD			"SCRATCH_PAD"
#define VMA_MSGNAME_EDITOR_CLRSEL			"CLRSEL"
#define VMA_MSGNAME_EDITOR_LIGHT_PROPERTIES		"LIGHT PROPERTIES"
#define VMA_MSGNAME_EDITOR_TEXTURE_BROWSER		"TEXTURE_BROWSER"
#define VMA_MSGNAME_EDITOR_HELP_CONTENTS		"HELP_CONTENTS"
#define VMA_MSGNAME_EDITOR_HELP_TUTORIAL		"HELP_TUTORIAL"
#define VMA_MSGNAME_EDITOR_HELP_VIEWING			"HELP_VIEWING"
#define VMA_MSGNAME_EDITOR_HELP_KEYBOARD		"HELP_KEYBOARD"
#define VMA_MSGNAME_EDITOR_HELP_V3D_FORMAT		"HELP_V3D_FORMAT"
#define VMA_MSGNAME_EDITOR_HELP_PLUGINS			"HELP_PLUGINS"
#define VMA_MSGNAME_EDITOR_HELP_TIP_OF_DAY		"HELP_TIP_OF_DAY"
#define VMA_MSGNAME_EDITOR_HELP_ABOUT			"HELP_ABOUT"
#define VMA_MSGNAME_EDITOR_VIEW_ENABLE			"VIEW_ENABLE"
#define VMA_MSGNAME_EDITOR_VIEW_MAXIMIZE		"VIEW_MAXIMIZE"
#define VMA_MSGNAME_EDITOR_VIEW_RESTORE			"VIEW_RESTORE"
#define VMA_MSGNAME_EDITOR_VIEW_GRID_SPACING		"VIEW_GRID_SPACING"
#define VMA_MSGNAME_EDITOR_VIEW_VIEWABLE_DIM		"VIEW_VIEWABLE_DIM"
#define VMA_MSGNAME_EDITOR_VIEW_RENDER_ACTUAL		"VIEW_RENDER_ACTUAL"
#define VMA_MSGNAME_EDITOR_VIEW_CULL_FACES		"VIEW_CULL_FACES"
#define VMA_MSGNAME_EDITOR_VIEW_TRANSLATIONS		"VIEW_TRANSLATIONS"
#define VMA_MSGNAME_EDITOR_VIEW_BGIMG_OFFSET		"VIEW_BGIMG_OFFSET"
#define VMA_MSGNAME_EDITOR_VIEW_BGIMG_SCALE		"VIEW_BGIMG_SCALE"
#define VMA_MSGNAME_EDITOR_VIEW_CAM_MOVE_RATE		"VIEW_CAM_MOVE_RATE"
#define VMA_MSGNAME_EDITOR_VIEW_CAM_CLIP_NEAR		"VIEW_CAM_CLIP_NEAR"
#define VMA_MSGNAME_EDITOR_VIEW_CAM_CLIP_FAR		"VIEW_CAM_CLIP_FAR"
#define VMA_MSGNAME_EDITOR_VIEW_CAM_FOV			"VIEW_CAM_FOV"
#define VMA_MSGNAME_EDITOR_VALUES_BROWSE_BUTTON		"VALUES_BROWSE_BUTTON"

#define VMA_MSGNAME_EDITOR_ROTATE_PRIMITIVE_ROTATE_ANGLE	"ROTATE_PRIMITIVE_ROTATE_ANGLE"
#define VMA_MSGNAME_EDITOR_ROTATE_PRIMITIVE_ORBITAL_AXIS	"ROTATE_PRIMITIVE_ORBITAL_AXIS"
#define VMA_MSGNAME_EDITOR_ROTATE_PRIMITIVE_ORBITAL_CENTER	"ROTATE_PRIMITIVE_ORBITAL_CENTER"
#define VMA_MSGNAME_EDITOR_TRANSLATE_PRIMITIVE_X		"TRANSLATE_PRIMITIVE_X"
#define VMA_MSGNAME_EDITOR_TRANSLATE_PRIMITIVE_Y		"TRANSLATE_PRIMITIVE_Y"
#define VMA_MSGNAME_EDITOR_TRANSLATE_PRIMITIVE_Z		"TRANSLATE_PRIMITIVE_Z"
#define VMA_MSGNAME_EDITOR_SCALE_PRIMITIVE_UNIFORM		"SCALE_PRIMITIVE_UNIFORM"
#define VMA_MSGNAME_EDITOR_SCALE_PRIMITIVE_COMPOENT		"SCALE_PRIMITIVE_COMPOENT"
#define VMA_MSGNAME_EDITOR_SCALE_PRIMITIVE_COEFF		"SCALE_PRIMITIVE_COEFF"
#define VMA_MSGNAME_EDITOR_SCALE_PRIMITIVE_ORIGIN		"SCALE_PRIMITIVE_ORIGIN"
#define VMA_MSGNAME_EDITOR_MIRROR_PRIMITIVE_AXIS		"MIRROR_PRIMITIVE_AXIS"
#define VMA_MSGNAME_EDITOR_MIRROR_PRIMITIVE_OFFSET		"MIRROR_PRIMITIVE_OFFSET"

#define VMA_MSGNAME_EDITOR_LIGHT_POPUP_MENU		"LIGHT_POPUP_MENU"
#define VMA_MSGNAME_EDITOR_LIGHT_NUMBER_SPIN		"LIGHT_NUMBER_SPIN"
#define VMA_MSGNAME_EDITOR_LIGHT_ENABLE_CHECK		"LIGHT_ENABLE_CHECK"
#define VMA_MSGNAME_EDITOR_LIGHT_MOVE_TO_CURSOR		"LIGHT_MOVE_TO_CURSOR"
/* #define VMA_MSGNAME_EDITOR_LIGHT_PROPERTIES             "LIGHT PROPERTIES" */

#define VMA_MSGNAME_EDITOR_SCRATCHPAD_INSERT		"SCRATCHPAD_INSERT"
#define VMA_MSGNAME_EDITOR_SCRATCHPAD_APPEND		"SCRATCHPAD_APPEND"
#define VMA_MSGNAME_EDITOR_SCRATCHPAD_EDIT		"SCRATCHPAD_EDIT"



/* Message list for editor tooltips. */
#define VMA_MSGLIST_EDITOR_TOOLTIPS	{ \
	VMA_MSGNAME_EDITOR_MODELFILE_NEW, \
	"Create new set of models", \
 \
	VMA_MSGNAME_EDITOR_MODELFILE_OPEN, \
	"Open model file", \
 \
	VMA_MSGNAME_EDITOR_MODELFILE_SAVE, \
	"Save models to file", \
 \
	VMA_MSGNAME_EDITOR_MODELFILE_SAVEAS, \
	"Save models to new file name", \
 \
	VMA_MSGNAME_EDITOR_BACKUP, \
	"Make a backup of the current file's original data", \
 \
	VMA_MSGNAME_EDITOR_BACKUP_SETTINGS, \
	"Specify the way backups are performed", \
 \
	VMA_MSGNAME_EDITOR_REVERT, \
	"Revert to previously saved data", \
 \
	VMA_MSGNAME_EDITOR_EXPORT, \
	"Export model data to alternate file format", \
 \
        VMA_MSGNAME_EDITOR_IMPORT, \
        "Import model data from alternate file format", \
 \
	VMA_MSGNAME_EDITOR_PRINT, \
	"Print current displayed view contents", \
 \
	VMA_MSGNAME_EDITOR_CLOSE, \
	"Close this window", \
 \
	VMA_MSGNAME_EDITOR_EXIT, \
	"Close all windows belonging to this application", \
 \
	VMA_MSGNAME_EDITOR_UNDO, \
	"Undo the last operation", \
 \
	VMA_MSGNAME_EDITOR_REDO, \
	"Redo the last undo", \
 \
	VMA_MSGNAME_EDITOR_CUT, \
	"Cut selected primitive(s) and put them on the clipboard", \
 \
	VMA_MSGNAME_EDITOR_COPY, \
	"Copy selected primitive(s) and put them on the clipboard", \
 \
        VMA_MSGNAME_EDITOR_PASTE, \
        "Paste primitives from clipboard to selected model", \
 \
	VMA_MSGNAME_EDITOR_CLIPBOARD, \
	"Map clipboard window", \
 \
	VMA_MSGNAME_EDITOR_WRITE_PROTECT_ENABLED, \
	"Write protect enabled", \
 \
	VMA_MSGNAME_EDITOR_WRITE_PROTECT_DISABLED, \
	"Write protect disabled", \
 \
	VMA_MSGNAME_EDITOR_MODEL_HEADER, \
	"Edit model header items", \
 \
	VMA_MSGNAME_EDITOR_SYNC_MEMORY, \
	"Syncronize all data references in memory", \
 \
	VMA_MSGNAME_EDITOR_PREFERENCES, \
	"Edit preferences for this application", \
 \
	VMA_MSGNAME_EDITOR_MODEL_CREATE, \
	"Create a new model", \
 \
	VMA_MSGNAME_EDITOR_MODEL_DELETE, \
	"Delete selected model", \
 \
	VMA_MSGNAME_EDITOR_MODEL_SHOW, \
	"Toggle show/hide of the selected model from the 3D view", \
 \
	VMA_MSGNAME_EDITOR_MODEL_PROPERTIES, \
	"Edit selected model's properties", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_CREATE, \
	"Create new primitive on selected model", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_DELETE, \
	"Delete selected primitive(s)", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_FLIP_WINDING, \
	"Flip winding of the selected primitive(s)", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_UNITLIZE_NORMAL, \
	"Unitlize the normal of the selected vertex", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_TRANSLATE, \
	"Translate the selected primitive(s)", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_ROTATE, \
	"Rotate the selected primitive(s)", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_SCALE, \
	"Scale the selected primitive(s)", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_MIRROR, \
	"Mirror the selected primitive(s)", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_SNAP, \
	"Snap points on the selected primitve(s)", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_ADD_VERTEX, \
	"Add a new vertex to the selected primitive", \
 \
	VMA_MSGNAME_EDITOR_PRIMITIVE_REMOVE_VERTEX, \
	"Remove the selected vertex from the primitive", \
 \
	VMA_MSGNAME_EDITOR_SCRATCH_PAD, \
	"ScratchPad", \
 \
	VMA_MSGNAME_EDITOR_CLRSEL, \
	"Map color selector", \
 \
	VMA_MSGNAME_EDITOR_LIGHT_PROPERTIES, \
	"Edit light properties", \
 \
	VMA_MSGNAME_EDITOR_TEXTURE_BROWSER, \
	"Map texture browser", \
 \
	VMA_MSGNAME_EDITOR_HELP_CONTENTS, \
	"Index list of help documents", \
 \
	VMA_MSGNAME_EDITOR_HELP_TUTORIAL, \
	"Help on how to use this application to make models", \
 \
	VMA_MSGNAME_EDITOR_HELP_VIEWING, \
	"Help on how to use the 2D and 3D views", \
 \
	VMA_MSGNAME_EDITOR_HELP_KEYBOARD, \
	"Help on keyboard modifiers and short-cuts", \
 \
	VMA_MSGNAME_EDITOR_HELP_V3D_FORMAT, \
	"Help on specifications of the V3D file format", \
 \
	VMA_MSGNAME_EDITOR_HELP_PLUGINS, \
	"Help on installing, using, and making plug-ins", \
 \
	VMA_MSGNAME_EDITOR_HELP_TIP_OF_DAY, \
	"Show the tip of the day", \
 \
	VMA_MSGNAME_EDITOR_HELP_ABOUT, \
	"Show information about this application, its version, and copyright", \
 \
	VMA_MSGNAME_EDITOR_VIEW_ENABLE, \
	"Enable/disable view", \
 \
	VMA_MSGNAME_EDITOR_VIEW_MAXIMIZE, \
	"Maximize view", \
 \
	VMA_MSGNAME_EDITOR_VIEW_RESTORE, \
	"Restore view", \
 \
	VMA_MSGNAME_EDITOR_VIEW_GRID_SPACING, \
	"Grid spacing in meters", \
 \
	VMA_MSGNAME_EDITOR_VIEW_VIEWABLE_DIM, \
	"Viewable dimension zoom (ALT + POINTER)", \
 \
	VMA_MSGNAME_EDITOR_VIEW_RENDER_ACTUAL, \
	"Toggle rendering solid or wire-frame", \
 \
	VMA_MSGNAME_EDITOR_VIEW_CULL_FACES, \
	"Toggle rendering of only visable-winded surface or both sides", \
 \
	VMA_MSGNAME_EDITOR_VIEW_TRANSLATIONS, \
	"Toggle evaluating of translate/rotate primitives", \
 \
	VMA_MSGNAME_EDITOR_VIEW_BGIMG_OFFSET, \
	"Offset from origin, in meters", \
 \
	VMA_MSGNAME_EDITOR_VIEW_BGIMG_SCALE, \
	"Pixel to meters coefficient, one pixel is equal to this many meters", \
 \
	VMA_MSGNAME_EDITOR_VIEW_CAM_MOVE_RATE, \
	"Camera move rate in meters per pixel", \
 \
	VMA_MSGNAME_EDITOR_VIEW_CAM_CLIP_NEAR, \
	"Clips any drawing detail closer than this value", \
 \
	VMA_MSGNAME_EDITOR_VIEW_CAM_CLIP_FAR, \
	"Clips any drawing detail farther than this value", \
 \
	VMA_MSGNAME_EDITOR_VIEW_CAM_FOV, \
	"Field of view angle in degrees", \
 \
	VMA_MSGNAME_EDITOR_VALUES_BROWSE_BUTTON, \
	"Browse...", \
 \
	VMA_MSGNAME_EDITOR_ROTATE_PRIMITIVE_ROTATE_ANGLE, \
	"Delta rotation angle in degrees (-360, 360)", \
 \
	VMA_MSGNAME_EDITOR_ROTATE_PRIMITIVE_ORBITAL_AXIS, \
	"Axis to rotate about", \
 \
	VMA_MSGNAME_EDITOR_ROTATE_PRIMITIVE_ORBITAL_CENTER, \
	"Rotate primitive relative to this point", \
 \
	VMA_MSGNAME_EDITOR_TRANSLATE_PRIMITIVE_X, \
	"Delta translation along X axis", \
 \
	VMA_MSGNAME_EDITOR_TRANSLATE_PRIMITIVE_Y, \
	"Delta translation along Y axis", \
 \
	VMA_MSGNAME_EDITOR_TRANSLATE_PRIMITIVE_Z, \
	"Delta translation along Z axis", \
 \
	VMA_MSGNAME_EDITOR_SCALE_PRIMITIVE_UNIFORM, \
	"Scale primitive along all axises using a single coefficient", \
 \
	VMA_MSGNAME_EDITOR_SCALE_PRIMITIVE_COMPOENT, \
        "Scale primitive on each axis with independent coefficients", \
 \
        VMA_MSGNAME_EDITOR_SCALE_PRIMITIVE_COEFF, \
        "Values greater than 1.0 increases and values less than 1.0 decreses", \
 \
	VMA_MSGNAME_EDITOR_SCALE_PRIMITIVE_ORIGIN, \
        "Scale primitive relative to this point", \
 \
	VMA_MSGNAME_EDITOR_MIRROR_PRIMITIVE_AXIS, \
	"Mirror primitive along this axis", \
 \
	VMA_MSGNAME_EDITOR_MIRROR_PRIMITIVE_OFFSET, \
        "Delta distance of mirror origin from mirroring axis", \
 \
        VMA_MSGNAME_EDITOR_LIGHT_POPUP_MENU, \
        "Light attributes", \
 \
        VMA_MSGNAME_EDITOR_LIGHT_NUMBER_SPIN, \
        "The number of the light to be modified", \
 \
	VMA_MSGNAME_EDITOR_LIGHT_ENABLE_CHECK, \
	"Enable/disable light", \
 \
	VMA_MSGNAME_EDITOR_LIGHT_MOVE_TO_CURSOR, \
	"Move light to the current cursor position", \
 \
	/* VMA_MSGNAME_EDITOR_LIGHT_PROPERTIES */ \
 \
	VMA_MSGNAME_EDITOR_SCRATCHPAD_INSERT, \
	"Insert selected vertex data to the scratchpad", \
 \
	VMA_MSGNAME_EDITOR_SCRATCHPAD_APPEND, \
	"Append selected vertex data to the scratchpad", \
 \
	VMA_MSGNAME_EDITOR_SCRATCHPAD_EDIT, \
	"Modify scratchpad entries", \
 \
	NULL, NULL \
}


/* *********************************************************** */
/* For editor's status bar. */
/* Message names for editor's status bar tooltip messages. */
#define VMA_MSGNAME_EDITOR_SB_WRITE_PROTECT_ENABLED	"WRITE_PROTECT_ENABLED"
#define VMA_MSGNAME_EDITOR_SB_WRITE_PROTECT_DISABLED	"WRITE_PROTECT_DISABLED"
#define VMA_MSGNAME_EDITOR_SB_AUTO_BACKUP_ENABLED	"AUTO_BACKUP_ENABLED"
#define VMA_MSGNAME_EDITOR_SB_AUTO_BACKUP_DISABLED	"AUTO_BACKUP_DISABLED"
#define VMA_MSGNAME_EDITOR_SB_NEW_EDITOR		"NEW_EDITOR"
#define VMA_MSGNAME_EDITOR_SB_COLOR_SELECTOR		"COLOR_SELECTOR"
#define VMA_MSGNAME_EDITOR_SB_LIGHT_PROPERTIES		"LIGHT_PROPERTIES"
#define VMA_MSGNAME_EDITOR_SB_TEXTURE_BROWSER		"TEXTURE_BROWSER"
#define VMA_MSGNAME_EDITOR_SB_SCRATCHPAD		"SCRATCHPAD"

/* Message list for editor's status bar tooltips. */
#define VMA_MSGLIST_EDITOR_SB_TOOLTIPS     { \
	VMA_MSGNAME_EDITOR_SB_WRITE_PROTECT_ENABLED, \
	"Write protect enabled", \
 \
	VMA_MSGNAME_EDITOR_SB_WRITE_PROTECT_DISABLED, \
	"Write protect disabled", \
 \
        VMA_MSGNAME_EDITOR_SB_AUTO_BACKUP_ENABLED, \
        "Automatic backup enabled", \
 \
        VMA_MSGNAME_EDITOR_SB_AUTO_BACKUP_DISABLED, \
        "Automatic backup disabled", \
 \
        VMA_MSGNAME_EDITOR_SB_NEW_EDITOR, \
        "New Editor", \
 \
        VMA_MSGNAME_EDITOR_SB_COLOR_SELECTOR, \
        "Color selector", \
 \
	VMA_MSGNAME_EDITOR_SB_LIGHT_PROPERTIES, \
	"Light properties", \
 \
        VMA_MSGNAME_EDITOR_SB_TEXTURE_BROWSER, \
        "Texture browser", \
 \
	VMA_MSGNAME_EDITOR_SB_SCRATCHPAD, \
	"ScratchPad", \
 \
        NULL, NULL \
}


/* *********************************************************** */
/* For Color Selector: */
/*  Message names for color selector tooltip messages. */
#define VMA_MSGNAME_CLRSEL_PREVIEW		"PREVIEW"
#define VMA_MSGNAME_CLRSEL_LIGHT_BRIGHTNESS	"LIGHT_BRIGHTNESS"
#define VMA_MSGNAME_CLRSEL_COLOR_BUTTON		"COLOR_BUTTON"
#define VMA_MSGNAME_CLRSEL_RED			"RED"
#define VMA_MSGNAME_CLRSEL_GREEN		"GREEN"
#define VMA_MSGNAME_CLRSEL_BLUE			"BLUE"
#define VMA_MSGNAME_CLRSEL_ALPHA		"ALPHA"
#define VMA_MSGNAME_CLRSEL_AMBIENT		"AMBIENT"
#define VMA_MSGNAME_CLRSEL_DIFFUSE		"DIFFUSE"
#define VMA_MSGNAME_CLRSEL_SPECULAR		"SPECULAR"
#define VMA_MSGNAME_CLRSEL_SHININESS		"SHININESS"
#define VMA_MSGNAME_CLRSEL_EMISSION		"EMISSION"

/* Message list for color selector tooltips. */
#define VMA_MSGLIST_CLRSEL_TOOLTIPS		{ \
	VMA_MSGNAME_CLRSEL_PREVIEW, \
	"Preview of current values (click and drag to \
orbit light source position)", \
 \
	VMA_MSGNAME_CLRSEL_LIGHT_BRIGHTNESS, \
	"Diffuse value of light source", \
 \
	VMA_MSGNAME_CLRSEL_COLOR_BUTTON, \
	"Click to browse colors...", \
 \
	VMA_MSGNAME_CLRSEL_RED, \
	"Red pigment color compoent of material", \
 \
	VMA_MSGNAME_CLRSEL_GREEN, \
	"Green pigment color compoent of material", \
 \
	VMA_MSGNAME_CLRSEL_BLUE, \
	"Blue pigment color compoent of material", \
 \
	VMA_MSGNAME_CLRSEL_ALPHA, \
	"`Transparency' of material", \
 \
	VMA_MSGNAME_CLRSEL_AMBIENT, \
	"Light that has been scattered so much by environment on to \
the material (higher values produce less shaded areas)", \
 \
	VMA_MSGNAME_CLRSEL_DIFFUSE, \
	"Light casted directly on to material (higher values produce \
greater highlights)", \
 \
	VMA_MSGNAME_CLRSEL_SPECULAR, \
	"Light reflectiveness of material (higher values produce \
brighter shininess and greater reflection)", \
 \
	VMA_MSGNAME_CLRSEL_SHININESS, \
	"Coherancy of specular (higher values increase localization \
of shininess)", \
 \
	VMA_MSGNAME_CLRSEL_EMISSION, \
	"Colored light that is `given off' to neighboring \
surfaces", \
 \
	NULL, NULL \
}


/* *********************************************************** */
/* For Light Properties: */
/*  Message names for light properties tooltip messages. */
#define VMA_MSGNAME_LTPROP_POSITION		"POSITION"
#define VMA_MSGNAME_LTPROP_POSITION_FROM_CURSOR	"POSITION_FROM_CURSOR"
#define VMA_MSGNAME_LTPROP_DIRECTION		"DIRECTION"
#define VMA_MSGNAME_LTPROP_OMNIDIRECTIONAL	"OMNIDIRECTIONAL"
#define VMA_MSGNAME_LTPROP_SPOT_CUTOFF		"SPOT_CUTOFF"
#define VMA_MSGNAME_LTPROP_SPOT_EXPONENT	"SPOT_EXPONENT"
#define VMA_MSGNAME_LTPROP_AMBIENT		"AMBIENT"
#define VMA_MSGNAME_LTPROP_DIFFUSE		"DIFFUSE"
#define VMA_MSGNAME_LTPROP_SPECULAR		"SPECULAR"
#define VMA_MSGNAME_LTPROP_ATTENUATION_CONSTANT	"ATTENUATION_CONSTANT"
#define VMA_MSGNAME_LTPROP_ATTENUATION_LINEAR   "ATTENUATION_LINEAR"
#define VMA_MSGNAME_LTPROP_ATTENUATION_QUADRATIC	"ATTENUATION_QUADRATIC"

/* Message list for light properties tooltips. */
#define VMA_MSGLIST_LTPROP_TOOLTIPS	{ \
	VMA_MSGNAME_LTPROP_POSITION, \
	"Light source position", \
 \
        VMA_MSGNAME_LTPROP_POSITION_FROM_CURSOR, \
        "Use current cursor position as the light source position", \
 \
	VMA_MSGNAME_LTPROP_DIRECTION, \
	"Direction of light in degrees (non-omnidirectional only)", \
 \
	VMA_MSGNAME_LTPROP_OMNIDIRECTIONAL, \
	"Light rays emit in all directions", \
 \
	VMA_MSGNAME_LTPROP_SPOT_CUTOFF, \
	"Angle away from directional normal, from 0 to 90 degrees\
 (non-omnidirectional only)", \
 \
        VMA_MSGNAME_LTPROP_SPOT_EXPONENT, \
        "Light concentration at core, higher values increase concentration", \
 \
	VMA_MSGNAME_LTPROP_AMBIENT, \
	"Light that has been scattered so much by environment on to \
the material (higher values produce less shaded areas)", \
 \
        VMA_MSGNAME_LTPROP_DIFFUSE, \
        "Light casted directly on to material (higher values produce \
greater highlights)", \
 \
        VMA_MSGNAME_LTPROP_SPECULAR, \
        "Light reflectiveness of material (higher values produce \
brighter shininess and greater reflection)", \
 \
	VMA_MSGNAME_LTPROP_ATTENUATION_CONSTANT, \
	"C in equation attenuation_factor = 1 / (C + Ld + Qd^2)", \
 \
        VMA_MSGNAME_LTPROP_ATTENUATION_LINEAR, \
        "L in equation attenuation_factor = 1 / (C + Ld + Qd^2)", \
 \
        VMA_MSGNAME_LTPROP_ATTENUATION_QUADRATIC, \
        "Q in equation attenuation_factor = 1 / (C + Ld + Qd^2)", \
 \
        NULL, NULL \
}


/* *********************************************************** */
/* For Texture Browser: */
/* Message names for texture browser tooltip messages. */
#define VMA_MSGNAME_TEXBROWSER_BASE_DIR_OVERRIDE	"BASE_DIR_OVERRIDE"
#define VMA_MSGNAME_TEXBROWSER_TEXTURE_ADD		"TEXTURE_ADD"
#define VMA_MSGNAME_TEXBROWSER_TEXTURE_REMOVE		"TEXTURE_REMOVE"
#define VMA_MSGNAME_TEXBROWSER_TEXTURE_PROPERTIES	"TEXTURE_PROPERTIES"
#define VMA_MSGNAME_TEXBROWSER_TEXTURES_RELOAD		"TEXTURES_RELOAD"
#define VMA_MSGNAME_TEXBROWSER_BASE_DIR_BROWSE		"BASE_DIR_BROWSE"
/* Texture browser's preview window... */
#define VMA_MSGNAME_TEXBROWSER_PV_ZOOM_IN		"PV_ZOOM_IN"
#define VMA_MSGNAME_TEXBROWSER_PV_ZOOM_OUT		"PV_ZOOM_OUT"
#define VMA_MSGNAME_TEXBROWSER_PV_ZOOM_ONE_TO_ONE	"PV_ZOOM_ONE_TO_ONE"
#define VMA_MSGNAME_TEXBROWSER_PV_ZOOM_TO_FIT		"PV_ZOOM_TO_FIT"

/* Message list for texture browser tooltips. */
#define VMA_MSGLIST_TEXBROWSER_TOOLTIPS		{ \
	VMA_MSGNAME_TEXBROWSER_BASE_DIR_OVERRIDE, \
	"Override texture base directory set by model data", \
 \
	VMA_MSGNAME_TEXBROWSER_TEXTURE_ADD, \
	"Create a new texture referance", \
 \
	VMA_MSGNAME_TEXBROWSER_TEXTURE_REMOVE, \
	"Remove selected texture referance(s)", \
 \
	VMA_MSGNAME_TEXBROWSER_TEXTURE_PROPERTIES, \
	"Edit texture referance properties", \
 \
	VMA_MSGNAME_TEXBROWSER_TEXTURES_RELOAD, \
	"Reload referanced textures' data", \
 \
	VMA_MSGNAME_TEXBROWSER_BASE_DIR_BROWSE, \
	"Browse...", \
 \
/* On preview window */ \
	VMA_MSGNAME_TEXBROWSER_PV_ZOOM_IN, \
	"Zoom in (SHIFT+POINTER)", \
 \
	VMA_MSGNAME_TEXBROWSER_PV_ZOOM_OUT, \
	"Zoom out (ALT+POINTER)", \
 \
	VMA_MSGNAME_TEXBROWSER_PV_ZOOM_ONE_TO_ONE, \
	"Zoom one to one", \
 \
	VMA_MSGNAME_TEXBROWSER_PV_ZOOM_TO_FIT, \
	"Zoom to fit", \
 \
	NULL, NULL \
}


/* *********************************************************** */
/* For V3D save prompt window. */
/* Message names for V3D save prompt window tooltip messages. */
#define VMA_MSGNAME_V3DPROMPT_OPTIMIZATION		"OPTIMIZATION"
#define VMA_MSGNAME_V3DPROMPT_STRIP_EXTRAS		"STRIP_EXTRAS"

#define VMA_MSGLIST_V3DPROMPT_TOOLTIPS		{ \
        VMA_MSGNAME_V3DPROMPT_OPTIMIZATION, \
        "Value of 0 means save as is, value of 1 or greater enables optimization. \
Optimization is dependant on the current V3D format optimization support \
on this application.", \
 \
        VMA_MSGNAME_V3DPROMPT_STRIP_EXTRAS, \
        "Skips the saving of any comments and other extranous data. Do not \
check this if you plan on using this model file with applications that require \
having their own proprietery data in a V3D file.", \
 \
	NULL, NULL \
}


/* *********************************************************** */
/* For preferences window. */
/* Message names for preferences window tooltip messages. */
#define VMA_MSGNAME_PREFWIN_DATA_DECIMALS_ANGLE		"DATA_DECIMALS_ANGLE"
#define VMA_MSGNAME_PREFWIN_DATA_DECIMALS_POSITION	"DATA_DECIMALS_POSITION"
#define VMA_MSGNAME_PREFWIN_VIEW_DECIMALS_ANGLE		"VIEW_DECIMALS_ANGLE"
#define VMA_MSGNAME_PREFWIN_VIEW_DECIMALS_POSITION	"VIEW_DECIMALS_POSITION"

#define VMA_MSGNAME_PREFWIN_RENDERING_INTRO		"RENDERING_INTRO"
#define VMA_MSGNAME_PREFWIN_VIEW_RENDER_ACTUAL		"VIEW_RENDER_ACTUAL"
#define VMA_MSGNAME_PREFWIN_VIEW_CULL_FACES		"VIEW_CULL_FACES"
#define VMA_MSGNAME_PREFWIN_VIEW_CULL_DIRECTION_CW	"VIEW_CULL_DIRECTION_CW"
#define VMA_MSGNAME_PREFWIN_VIEW_CULL_DIRECTION_CCW	"VIEW_CULL_DIRECTION_CCW"
#define VMA_MSGNAME_PREFWIN_VIEW_TRANSLATIONS		"VIEW_TRANSLATIONS"
#define VMA_MSGNAME_PREFWIN_VIEW_ENABLE_ALPHA_CHANNEL	"VIEW_ENABLE_ALPHA_CHANNEL"
#define VMA_MSGNAME_PREFWIN_VIEW_CAM_CLIP_NEAR		"VIEW_CAM_CLIP_NEAR"
#define VMA_MSGNAME_PREFWIN_VIEW_CAM_CLIP_FAR		"VIEW_CAM_CLIP_FAR"
#define VMA_MSGNAME_PREFWIN_VIEW_CAM_FOV		"VIEW_CAM_FOV"

#define VMA_MSGNAME_PREFWIN_DEVICES_POINTER_EMULATE_2BUTTON	"DEVICES_POINTER_EMULATE_2BUTTON"

#define VMA_MSGNAME_PREFWIN_EDITOR_UNDO_MAX		"EDITOR_UNDO_MAX"

#define VMA_MSGNAME_PREFWIN_LOCATION_DATA_LOCAL		"LOCATION_DATA_LOCAL"
#define VMA_MSGNAME_PREFWIN_LOCATION_DATA_GLOBAL	"LOCATION_DATA_GLOBAL"
#define VMA_MSGNAME_PREFWIN_LOCATION_PRESET_MODELS_LOCAL	"LOCATION_PRESET_MODELS_LOCAL"
#define VMA_MSGNAME_PREFWIN_LOCATION_PRESET_MODELS_GLOBAL	"LOCATION_PRESET_GLOBAL"
#define VMA_MSGNAME_PREFWIN_LOCATION_PRESET_PRIMITIVES_LOCAL	"LOCATION_PRESET_PRIMITIVES_LOCAL"
#define VMA_MSGNAME_PREFWIN_LOCATION_PRESET_PRIMITIVES_GLOBAL	"LOCATION_PRESET_PRIMITIVES_GLOBAL"
#define VMA_MSGNAME_PREFWIN_LOCATION_TMP_DIR		"LOCATION_TMP_DIR"
#define VMA_MSGNAME_PREFWIN_LOCATION_SCRATCHPAD_FILE	"LOCATION_SCRATCHPAD_FILE"
#define VMA_MSGNAME_PREFWIN_LOCATION_PLUGINS_FILE	"LOCATION_PLUGINS_FILE"

#define VMA_MSGNAME_PREFWIN_V3D_INTRO			"V3D_INTRO"
#define VMA_MSGNAME_PREFWIN_V3D_PROMPT_ON_SAVE		"V3D_PROMPT_ON_SAVE"
#define VMA_MSGNAME_PREFWIN_V3D_OPTIMIZATION		"V3D_OPTIMIZATION"
#define VMA_MSGNAME_PREFWIN_V3D_STRIP_EXTRAS		"V3D_STRIP_EXTRAS"

#define VMA_MSGNAME_PREFWIN_BACKUP_INTRO		"BACKUP_INTRO"
#define VMA_MSGNAME_PREFWIN_BACKUP_ON_OPEN		"BACKUP_ON_OPEN"
#define VMA_MSGNAME_PREFWIN_BACKUP_ON_SAVE		"BACKUP_ON_SAVE"
#define VMA_MSGNAME_PREFWIN_BACKUP_PERIODIC		"BACKUP_PERIODIC"
#define VMA_MSGNAME_PREFWIN_BACKUP_NEW_HIGHEST_INDEX	"BACKUP_HIGHEST_INDEX"
#define VMA_MSGNAME_PREFWIN_BACKUP_NEW_LOWEST_INDEX	"BACKUP_LOWEST_INDEX"
#define VMA_MSGNAME_PREFWIN_BACKUP_MAX			"BACKUP_MAX"

#define VMA_MSGNAME_PREFWIN_PLUGINS_INTRO		"PLUGINS_INTRO"
#define VMA_MSGNAME_PREFWIN_PLUGINS_ENABLE_BUTTON	"PLUGINS_ENABLE_BUTTON"
#define VMA_MSGNAME_PREFWIN_PLUGINS_DISABLE_BUTTON	"PLUGINS_DISABLE_BUTTON"
#define VMA_MSGNAME_PREFWIN_PLUGINS_RELOAD_BUTTON	"PLUGINS_RELOAD_BUTTON"
#define VMA_MSGNAME_PREFWIN_PLUGINS_CONFIGURE_BUTTON	"PLUGINS_CONFIGURE_BUTTON"


/* Message list for preferences window tooltips. */
#define VMA_MSGLIST_PREFWIN_TOOLTIPS         { \
        VMA_MSGNAME_PREFWIN_DATA_DECIMALS_ANGLE, \
        "Number of decimals in stored angle precision", \
 \
	VMA_MSGNAME_PREFWIN_DATA_DECIMALS_POSITION, \
	"Number of decimals in stored position precision", \
 \
	VMA_MSGNAME_PREFWIN_VIEW_DECIMALS_ANGLE, \
	"Number of decimals in view camera attitude precision", \
 \
	VMA_MSGNAME_PREFWIN_VIEW_DECIMALS_POSITION, \
	"Number of decimals in view camera position precision", \
 \
        VMA_MSGNAME_PREFWIN_RENDERING_INTRO, \
        "Built-in rendering uses the OpenGL implementation, here you can\n\
customize OpenGL's rendering parameters. Each rendering parameter\n\
behaves identically to the OpenGL standard unless stated otherwise.", \
 \
	VMA_MSGNAME_PREFWIN_VIEW_RENDER_ACTUAL, \
	"Toggle render actual or wire frame", \
 \
	VMA_MSGNAME_PREFWIN_VIEW_CULL_FACES, \
        "Toggle the rendering of only the visable-winded side or both sides of a surface", \
 \
	VMA_MSGNAME_PREFWIN_VIEW_CULL_DIRECTION_CW, \
	"Defines visible face as being on the clockwise winded side", \
 \
        VMA_MSGNAME_PREFWIN_VIEW_CULL_DIRECTION_CCW, \
        "Defines visible face as being on the counter-clockwise winded side", \
 \
        VMA_MSGNAME_PREFWIN_VIEW_TRANSLATIONS, \
        "Toggles the performing of translate and rotate type primitives", \
 \
	VMA_MSGNAME_PREFWIN_VIEW_ENABLE_ALPHA_CHANNEL, \
	"For transparency and blending effects", \
 \
        VMA_MSGNAME_PREFWIN_VIEW_CAM_CLIP_NEAR, \
        "Clips any drawing detail closer than this value", \
 \
        VMA_MSGNAME_PREFWIN_VIEW_CAM_CLIP_FAR, \
        "Clips any drawing detail farther than this value", \
 \
        VMA_MSGNAME_PREFWIN_VIEW_CAM_FOV, \
        "Field of view angle in degrees", \
 \
	VMA_MSGNAME_PREFWIN_DEVICES_POINTER_EMULATE_2BUTTON, \
	"Emulate pointer device as a physical 2 button pointer, overriding\
 X server Button3 emulation.", \
 \
	VMA_MSGNAME_PREFWIN_EDITOR_UNDO_MAX, \
	"Maximum number of undo items allowed in the undo buffer,\
 some operations may require more than one item per undo. Changing\
 this value will delete any existing items in the undo buffer.", \
 \
	VMA_MSGNAME_PREFWIN_LOCATION_DATA_LOCAL, \
	"Base directory containing this application's data files that belong\
 to the current user", \
	VMA_MSGNAME_PREFWIN_LOCATION_DATA_GLOBAL, \
	"Base directory containing this application's data files that are\
 available to all users", \
 \
	VMA_MSGNAME_PREFWIN_LOCATION_PRESET_MODELS_LOCAL, \
	"Directory containing user defined preset model files", \
	VMA_MSGNAME_PREFWIN_LOCATION_PRESET_MODELS_GLOBAL, \
	"Directory containing globally defined preset model files", \
 \
	VMA_MSGNAME_PREFWIN_LOCATION_PRESET_PRIMITIVES_LOCAL, \
	"Directory containing user defined preset primitive files", \
	VMA_MSGNAME_PREFWIN_LOCATION_PRESET_PRIMITIVES_GLOBAL, \
	"Directory containing globally defined preset primitive files", \
 \
        VMA_MSGNAME_PREFWIN_LOCATION_TMP_DIR, \
        "Directory for placing tempory files created by this application,\
 this directory must permit both reading and writing. If the\
 specified directory does not exist then it will be created", \
 \
	VMA_MSGNAME_PREFWIN_LOCATION_SCRATCHPAD_FILE, \
	"File containing the vertices that were in the\
 scratchpad during a prior session", \
 \
	VMA_MSGNAME_PREFWIN_LOCATION_PLUGINS_FILE, \
	"File containing the configuration of each installed plug-in", \
 \
	VMA_MSGNAME_PREFWIN_V3D_INTRO, \
	"Customize the way V3D model files are saved. Read the tooltips of\n\
each option carefully before changing its value. Some options may\n\
discard critical data when enabled, so do not enable an option\n\
unless you are sure you need it.", \
 \
	VMA_MSGNAME_PREFWIN_V3D_PROMPT_ON_SAVE, \
	"Always prompt for these options each time you save to V3D format.", \
 \
	VMA_MSGNAME_PREFWIN_V3D_OPTIMIZATION, \
	"Value of 0 means save as is, value of 1 or greater enables optimization. \
Optimization is dependant on the current V3D format optimization support \
on this application. Caution, higher optimization levels may remove texture \
coordinates on some primitives if they are not under a selected texture", \
 \
	VMA_MSGNAME_PREFWIN_V3D_STRIP_EXTRAS, \
	"Skips the saving of any comments and other extranous data. Do not \
check this if you plan on using this model file with applications that require \
having their own proprietery data in a V3D file.", \
 \
 \
	VMA_MSGNAME_PREFWIN_BACKUP_INTRO, \
	"Vertex can make backups of the original model file when you open it,\n\
just before saving it, and periodically when it's loaded. Backups are\n\
saved in the same directory as the original model file. When the\n\
number of backups exceed the specified maximum, then the backup files\n\
will be `cycled' (oldest removed and their names `shifted' to\n\
accomidate the latest backup).\n\
If you have any backups that need recovering, then do not modify\n\
any values here. Rename or move those backup files to a safe\n\
directory immediatly.", \
 \
	VMA_MSGNAME_PREFWIN_BACKUP_ON_OPEN, \
	"Backup file just before opening it", \
 \
	VMA_MSGNAME_PREFWIN_BACKUP_ON_SAVE, \
	"Backup file just before saving it", \
 \
	VMA_MSGNAME_PREFWIN_BACKUP_PERIODIC, \
	"Automatically save backups of the current data at a specified\
 interval", \
 \
	VMA_MSGNAME_PREFWIN_BACKUP_NEW_HIGHEST_INDEX, \
	"New backup files get named with the highest index number (\
which is the maximum number of backups per file - 1)", \
 \
	VMA_MSGNAME_PREFWIN_BACKUP_NEW_LOWEST_INDEX, \
	"New backup files get named with the lowest index number (\
which is 0)", \
 \
	VMA_MSGNAME_PREFWIN_BACKUP_MAX, \
	"Specifies the total number of backups per file, when this\
 is exceeded the backup file names will be cycled", \
 \
	VMA_MSGNAME_PREFWIN_PLUGINS_INTRO, \
        "Plug-ins provide support for importing/exporting, rendering, and\n\
extended model data manipulation. You can individually enable or disable\n\
each plug-in.\n\
Plug-ins are installed in the global and/or local plug-ins directories\n\
(see `Locations' for these settings).", \
 \
	VMA_MSGNAME_PREFWIN_PLUGINS_ENABLE_BUTTON, \
	"Disable selected plug-in", \
 \
        VMA_MSGNAME_PREFWIN_PLUGINS_DISABLE_BUTTON, \
        "Enable selected plug-in", \
 \
	VMA_MSGNAME_PREFWIN_PLUGINS_RELOAD_BUTTON, \
	"Reload all plug-ins", \
 \
	VMA_MSGNAME_PREFWIN_PLUGINS_CONFIGURE_BUTTON, \
	"Configure plug-in", \
 \
	NULL, NULL \
}



#endif	/* MESSAGES_H */
