#ifndef WAIT_EVENT_HH
#define WAIT_EVENT_HH

//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#include <warped/DeserializerManager.h>
#include "tyvis/VHDLEvent.hh"
#include "tyvis/VHDLKernel.hh"
#include "tyvis/VHDLVTime.hh"

/** class for a VHDLProcess to send wait expirations to itself */
class WaitEvent: public VHDLEvent {
public:
  WaitEvent( const VHDLVTime &sendTime, 
	     const VHDLVTime &receiveTime, 
	     const string &sender,
	     const string &receiver, 
	     int initWaitId ) : 
    VHDLEvent( sendTime, receiveTime, sender, receiver ),
    waitId( initWaitId ){}

  explicit WaitEvent(const WaitEvent *we) : VHDLEvent( we ) {
    waitId = we->waitId;
  }

  ~WaitEvent() {}

  void serialize( SerializedInstance *serializeInto ) const {
    VHDLEvent::serialize( serializeInto );
    serializeInto->addInt( waitId );
  }

  static Serializable *deserialize( SerializedInstance *si ){
    VHDLVTime *sendTime = dynamic_cast<VHDLVTime *>(si->getSerializable());
    VHDLVTime *recvTime = dynamic_cast<VHDLVTime *>(si->getSerializable());
    const string sender = si->getString();
    const string receiver = si->getString();
    unsigned int eventId = si->getUnsigned();
    int waitId = si->getInt();
    
    return new WaitEvent( *sendTime,
			  *recvTime,
			  sender,
			  receiver,
			  eventId,
			  waitId );
  }

//   WaitEvent& operator=(const WaitEvent& src) {
//     VHDLEvent::operator=((const VHDLEvent &) src);
//     waitId = src.waitId;

//     return *this;
//   }

  virtual void execute( VHDLKernel *onProcess ){
    onProcess->updateWait( this );
  }

  int getWaitId() const { return waitId; }

  static const string &getWaitEventType(){
    static string waitEventId = "WaitEvent";
    return waitEventId;
  }
  
  const string &getDataType() const { return getWaitEventType(); }

  static void registerDeserializer(){
    DeserializerManager::instance()->registerDeserializer( getWaitEventType(),
							   &WaitEvent::deserialize );
  }

protected:
 
private:
  /**
     Constructor used by deserializer.
  */
  WaitEvent( const VHDLVTime &sendTime, 
	     const VHDLVTime &receiveTime, 
	     const string &sender,
	     const string &receiver, 
	     unsigned int eventId,
	     int initWaitId ) : 
    VHDLEvent( sendTime, receiveTime, sender, receiver, eventId ),
    waitId( initWaitId ){}


  int waitId;
};

#endif
