#include "UniversalCharacter.hh"
#include "AccessVariable.hh"
#include "AccessType.hh"
#include "ArrayType.hh"
#include <sstream>
#include "std_standardPkg.hh"

using std::ostringstream;
using std::stringstream;

UniversalCharacter::UniversalCharacter(const VHDLData &v) {
  operator=(v);
}


int
UniversalCharacter::savantwrite(AccessVariable &line) const {
  ostringstream tempStr;

  tempStr << line.getVal() << *this << FILE_DELIMITER;
  line.setVal( tempStr.str() );

  return NORMAL_RETURN;
}

int
UniversalCharacter::savantwrite( AccessType &line ) const {
  ostringstream tempStr;
  if (line.val != NULL) {
    tempStr << line << *this << FILE_DELIMITER << '\0';
  }
  else {
    tempStr << *this << FILE_DELIMITER << '\0';
  }
  
  if (line.val != NULL) {
    delete line.val;
  }
  
  line.val = new ArrayType( ObjectBase::VARIABLE,
			    SavantstringType_info,
			    -1,
			    tempStr.str().c_str() );

  return NORMAL_RETURN;
}

int
UniversalCharacter::savantread(AccessVariable &) {
  return NORMAL_RETURN;
}

int
UniversalCharacter::savantread(AccessType &line) {
  char *workString = line.val->getString();
  char *input      = new char[strlen(workString) + 1];
  stringstream input_stream;
  
  extractToDelimiter(workString, FILE_DELIMITER, input);

  input_stream << input;
  input_stream >> val;

  delete line.val;

  if (strlen(workString) > 0) {
    line.val = new ArrayType(ObjectBase::VARIABLE, SavantstringType_info, -1, workString);
  }
  else {
    line.val = NULL;
  }

  delete workString;
  delete input;
    
  return NORMAL_RETURN;
}
