#include "TypeKind.hh"
#include "Variable.hh"
#include "AccessVariable.hh"
#include "VHDLType.hh"
#include "AccessType.hh"
#include "SignalBase.hh"
#include "ObjectBase.hh"
#include "RecordType.hh"
#include "SignalNetinfo.hh"
#include "SourceBase.hh"
#include "VHDLKernel.hh"

char* VHDLType::getString() const {
  cerr << " ERROR !!!! VHDLType::getString() called "<< endl;
  abort();
  return NULL;
}

VHDLType&
VHDLType::assignVal(const VHDLType &val) {
  return (*this = val);
}

VHDLType &
VHDLType::operator[](const int) const { 
  cerr << "VHDLType::operator[] called" << endl;
  abort();
  return const_cast<VHDLType &>(*this);		// Just to keep CC quiet.
}

VHDLType&
VHDLType::operator[](const ScalarType&) const { 
  cerr << "VHDLType::operator[](const ScalarType&) called" << endl;
  abort();
  return const_cast<VHDLType &>(*this);		// Just to keep CC quiet.
}

VHDLType&
VHDLType::operator[](const VHDLType&) const { 
  cerr << "VHDLType::operator[](const VHDLType&) called" << endl;
  abort();
  return const_cast<VHDLType &>(*this);		
}

Type
VHDLType::get_kind() const {
  return NO_TYPE;
}

int
VHDLType::get_number_of_elements(int) const {
  cerr << " ERROR !!!! VHDLType::get_number_of_elements() called "<< endl;
  abort();
  return -1;
}

VHDLType &
VHDLType::get_element(const int ) const {
  cerr << " ERROR !!!! VHDLType::get_element() called "<< endl;
  abort();
  return const_cast<VHDLType &>(*this);
}

const ArrayInfo&
VHDLType::get_bounds(int) const {
  return nullInfo;
}

int 
VHDLType::left(int) const {
  cerr << "ERROR: VHDLType::left(int) called." << endl;
  abort();
  return -1;
}

VHDLType&
VHDLType::left(const ScalarType &) const {
  cerr << "ERROR: VHDLType::left(const ScalarType &) called." << endl;
  abort();
  return IntegerType::INVALID_TYPE_OBJECT;
}

int 
VHDLType::right(int) const {
  cerr << "ERROR: VHDLType::right(int) called." << endl;
  abort();
  return -1;
}

VHDLType&
VHDLType::right(const ScalarType &) const {
  cerr << "ERROR: VHDLType::right(const ScalarType &) called." << endl;
  abort();
  return IntegerType::INVALID_TYPE_OBJECT;
}

ArrayInfo::ArrayDirn_t 
VHDLType::dirn(int) const {
  cerr << "ERROR: VHDLType::dirn(int) called." << endl;
  abort();
  return ArrayInfo::downto;
}

int 
VHDLType::length(int) const {
  cerr << "ERROR: VHDLType::length(int) called." << endl;
  abort();
  return -1;;
}

void
VHDLType::setResolutionFunctionId(int) {
  cerr << "ERROR: VHDLType::setResolutionFunctionId(int) called." << endl;
  abort();
}

void
VHDLType::setTypeConversionFunctionId(int) {
  cerr << "ERROR: VHDLType::setTypeConversionFunctionId(int) called." << endl;
  abort();
}

void
VHDLType::setElaborationInfo(const VHDLType &) {
  cerr << "ERROR VHDLType::setElaborationTnfo(VHDLType&) called" << endl;
  abort();
}

void
VHDLType::setAttrib(AttribType, VHDLType&) {
  cerr << "ERROR VHDLType::setAttrib(AttribType, VHDLType&) called" << endl;
  abort();
}

void
VHDLType::updateEffVal(const VHDLType*) {
  cerr << "updateEffVal for VHDLType not implemented" << endl;
  abort();
}

VHDLType*
VHDLType::resolve(VHDLKernel*) {
  cerr << "resolve(VHDLKernel*) for VHDLType not implemented" << endl;
  abort();
  return NULL;
}

bool 
eatwhite( AccessVariable &line ) {
  if( line.getCurrentPos() >= line.length() ){
    cout << "VHDLType::eatwhite: line variable " << line.getName()
	 << " is empty!\n\n";
    line.print(cout);
    cout << endl;
    abort();
    return false;
  }

  // skip any whitespace
  while ((line.getVal()[line.getCurrentPos()] == ' ') || 
	 (line.getVal()[line.getCurrentPos()] == '\t')) {
    line.setCurrentPos( line.getCurrentPos() + 1 );
    if( line.getCurrentPos() == line.length() ){
      // line exhausted, no bit found
      cerr << " VHDLType::eatwhite Warning: EOL reached" << endl;
      return false;
    }
  }
  return true;
}

void
assignVariable( LValue &destObject,
		const RValue &newValue ){ 
  destObject.updateVal( newValue.readVal() );
}

extern void assignVariable( VHDLType &destObject, const RValue &srcObject, 
			    const ArrayInfo &dinfo, const ArrayInfo &sinfo ){
  ASSERT( dinfo.operator==(nullInfo) && sinfo.operator==(nullInfo) );
  assignVariable( destObject, srcObject );
}


void 
assignVariable( VHDLType &destObject, const VHDLType &srcObject, 
		const ArrayInfo &dinfo, const ArrayInfo &sinfo){
  
  int i = 0;
  // These manage the bounds even if "sinfo" or "dinfo" are NULL.
  // Required for concatenation operator, where it is difficult to find
  // the size of the bounds at compile time.
  const ArrayInfo *src_ainfo  = &sinfo;
  const ArrayInfo *dest_ainfo = &dinfo;
  
  switch (destObject.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    assignVariable( destObject, srcObject );
    break;
  case ARRAY_TYPE: {
    if ( sinfo.operator==(defaultInfo) || sinfo.operator==(nullInfo) ){
      src_ainfo = &srcObject.get_bounds(0);
    }
    if ( dinfo.operator==(defaultInfo) || dinfo.operator==(nullInfo) ) {
      dest_ainfo = &destObject.get_bounds(0);
    }
    
    int dest_counter   = dest_ainfo->left();
    int dest_increment = dest_ainfo->dirn();
    int src_counter    = src_ainfo->left();
    int src_increment  = src_ainfo->dirn();

    int length         = dest_ainfo->length();
    if (src_ainfo->length() < length) {
      length = src_ainfo->length();
    }
    
    for(i = 0; (i < length); i++) {
      assignVariable(destObject[dest_counter], srcObject[src_counter], nullInfo, nullInfo);
      dest_counter += dest_increment;
      src_counter  += src_increment;
    }
    break;
  }
  
  case RECORD_TYPE:
    assignVariable(dynamic_cast<RecordType &>(destObject),
		   dynamic_cast<const RecordType &>(srcObject),
		   nullInfo,
		   nullInfo );
    break;
  
  case ACCESS_TYPE:
    dynamic_cast<AccessType&>(destObject).setPointer( const_cast<VHDLType *>(&srcObject) );
    break;
    
  default:
    cerr << "Unknown type found in assignVariable" << endl;
    abort();
    break;
  }
}

int
VHDLType::savantwrite(AccessVariable &line) const{
  switch (this->get_kind()) {
  case ARRAY_TYPE:
    return ((ArrayType *) this)->savantwrite(line);
  case RECORD_TYPE:
    return ((RecordType *) this)->savantwrite(line);
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    return ((ScalarType *) this)->savantwrite(line);
  default:
    cerr << "ERROR: VHDLType's savantwrite called with unkown kind" << endl;
    abort();
    return NORMAL_RETURN;
  }
}

int
VHDLType::savantread( AccessVariable & ){
  cerr << "ERROR: VHDLType::savantwrite called" << endl;
  abort();
  return 0;
}

int
VHDLType::savantwrite( AccessType & ) const {
  cerr << "ERROR: VHDLType's savantwrite called with unkown kind" << endl;
  abort();
  return 0;
}

int
VHDLType::savantread( AccessType & ) {
  cerr << "ERROR: VHDLType's savantwrite called with unkown kind" << endl;
  abort();
  return 0;
}

void
VHDLType::setParentCompositeType(VHDLType*) {
  cerr << "ERROR: VHDLType's setParentCompositeType(VHDLType* ptr)"
       << " called with unkown kind" << endl;
  abort();
}

void
VHDLType::setCompositeResolvedSignal(bool) {
  cerr << "ERROR: VHDLType's setCompositeResolvedSignal(VHDLType* ptr)"
       << " called with unkown kind" << endl;
  abort();
}

bool
VHDLType::is_driver_already_set() const {
  SignalNetinfo *netInfo = dynamic_cast<SignalNetinfo *>(getObject());
  ASSERT( netInfo != 0 );
  return netInfo->get_driver_added_flag();
}

bool
VHDLType::is_resolved_signal() const {
  SignalNetinfo *netInfo = dynamic_cast<SignalNetinfo *>( getObject() );
  ASSERT( netInfo != 0 );
  if ( netInfo->getSource() != NULL && 
       netInfo->getSource()->getResolutionFnId() != SourceBase::DEFAULT_RF_ID ) {
    return true;
  }
  else{
    return false;
  }
}


void
VHDLType::assignSignal( VHDLKernel *destProcess, 
			VHDLKernel *srcProcess, 
			const VHDLType &srcType,
			const PhysicalType &delay, 
			const PhysicalType &rejTime, 
			const ArrayInfo &dinfo,
			const ArrayInfo &sinfo ){

  ASSERT( destProcess != 0 );
  ASSERT( srcProcess != 0 );

  SignalBase *destSignal = dynamic_cast<SignalBase *>( getObject() );

  destProcess->assignSignal( *destSignal, 
			     srcProcess,
			     srcType.getObject()->readVal(), 
			     delay.getVTime(), 
			     rejTime.getVTime(),
			     dinfo,
			     sinfo );
  ASSERT( destSignal != 0 );
}

void
VHDLType::initializeImplicitSignal(AttribType) {
  cerr << " ERROR !!!! VHDLType::initializeImplicitSignal(AttribType) called "<< endl;
  abort();
}

SignalBase*
VHDLType::locateSig(int ) {
  cerr << "ERROR!!!! VHDLType::locateSig(int sigId) called " << endl;
  abort();
  return NULL;
}

const VHDLData&
VHDLType::leftValue() {
  cerr << "ERROR!!! VHDLType::leftValue() called " << endl;
  abort();
  return *(new UniversalInteger(-1));
}

SignalBase *
VHDLType::findSigInBlock(int, VHDLKernel *) {
  cerr << "ERROR!!!! VHDLType::findSigInBlock(int sigId) called" << endl;
  abort();
  return 0;
}

SignalBase *
VHDLType::findSigInBlock( int, int ){
  cerr << "ERROR!!!! VHDLType::findSigInBlock(int sigId) called" << endl;
  abort();
  return 0;
}

bool
VHDLType::_is_composite_resolved_type() const{
  return false;
}

void
VHDLType::set_sourcebase_delete_flag( bool flag )const{
  getObject()->set_sourcebase_delete_flag(flag);
}

VHDLType *
VHDLType::getParentCompositeType(){
  if ( getObject() != NULL ){
    return getObject()->getParentCompositeType();
  } else {
    return NULL;
  }
}

void
VHDLType::resolveAndUpdate( VHDLKernel* processPointer ){
  SignalBase *asSignal = dynamic_cast<SignalBase *>(getObject());
  ASSERT( asSignal != 0 );
  if( asSignal->getSource() != NULL ){
    processPointer->updateSignal( asSignal , true );
  }
}

void
VHDLType::setBusKind() {
  cerr << "Error!! : setBusKind() called on unknown Kernel Type" << endl;
  abort();
}

TypeInfo&
VHDLType::getTypeInfo() const {
  cerr << "Error!! : VHDLTYpe::getTypeInfo() called.\n";
  abort();
  return TypeInfo::getNullTypeInfo();
}

ObjectBase*
VHDLType::getObject() const {
  cerr << "Error!! : VHDLType::getObject() const called.\n";
  abort();

  return NULL;
}

void
VHDLType::setObject(ObjectBase *) {
  cerr << "Error!! : VHDLType::setObject(ObjectBase *) called.\n";
  abort();
}

void 
VHDLType::Add( const VHDLType &){
  cerr << "Internal error - VHDLType::Add( const VHDLType &addThis ) called." << endl;
  abort();
}

void 
VHDLType::Add( const SignalNetinfo * ){
  cerr << "Internal error - VHDLType::Add( const SignalNetinfo * ) called." << endl;
  abort();
}

void
VHDLType::Add( VHDLKernel *, int ){
  cerr << "Internal error - VHDLType::Add( VHDLKernel *processPtr, int sigid ) called." << endl;
  abort();
}

void 
VHDLType::Add( SignalNetinfo &sig ){
  Add( &sig );
}

void 
VHDLType::Add( VHDLKernel *processPtr ){
  SignalNetinfo *netInfo = dynamic_cast<SignalNetinfo *>(getObject());
  ASSERT( netInfo != 0 );
  ASSERT( processPtr != 0 );
  netInfo->Add(processPtr); 
}

const EnumerationType &
VHDLType::vhdlEqual( const RValue &compareTo ) const {
  return EnumerationType::toBoolean( *this == compareTo );
}

const EnumerationType &
VHDLType::vhdlNotEqual( const RValue &compareTo ) const {
  return EnumerationType::toBoolean( *this != compareTo );
}

const EnumerationType &
VHDLType::vhdlGreaterThan( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this > rhs );
}

const EnumerationType &
VHDLType::vhdlGreaterThanEqual( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this >= rhs );
}

const EnumerationType &
VHDLType::vhdlLessThan( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this < rhs );
}

const EnumerationType &
VHDLType::vhdlLessThanEqual( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this <= rhs );
}

void 
VHDLType::copyId( const VHDLType & ){
  cerr << "Internal error - VHDLType::copyId( const VHDLType &src ) called." << endl;
  abort();
}

ostream&
operator<<(ostream &os, const VHDLType &vt) {
  switch(vt.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
    os << ((const ScalarType &) vt);
    break;
    
  case ENUMERATION_TYPE:
    os << ((const EnumerationType &) vt);
    break;
    
  case PHYSICAL_TYPE:
    os << ((const PhysicalType &) vt);
    break;

  case ARRAY_TYPE:
    os << ((const ArrayType &) vt);
    break;

  case RECORD_TYPE:
    os << ((const RecordType &) vt);
    break;

  default:
    cerr << "Unknown type encountered.\n";
    abort();
  }

  return os;
}
