
#ifndef OBJECTBASE_HH
#define OBJECTBASE_HH

// Copyright (c) 1995-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Dale E. Martin              dmartin@cliftonlabs.com

#include "tyvis/VHDLData.hh"
#include "tyvis/LValue.hh"
#include "tyvis/Types.hh"
#include <iostream>
#include <fstream>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

using std::ostream;
using std::ofstream;
using std::cerr;
using std::endl;

class VHDLType;
class VHDLKernel;

/** This class is the base class for the Signal and Variables.  Any Type is
    going to have a pointer to this, so that a Type can have any object. */
class ObjectBase : public LValue {
public:
  /** Enum types to specify the type of object being instantiated. */
  enum ObjectType {SIGNAL, IMPLICIT_SIGNAL, VARIABLE, SIGNAL_NETINFO, TERMINAL, QUANTITY};

  ObjectBase() {
    parentCompositeType = NULL;
  }

  virtual ~ObjectBase(){}
  /** Any object of the ObjectType has to override the following
      functions. */
  virtual ObjectBase& operator=(const ObjectBase&) {
    cerr << " ERROR  ObjectBase::operator=(const ObjectBase&) called" << endl;
    abort();
    return *this;
  }
  
  virtual void print(ostream&) const = 0;
  virtual ObjectType getKind() const = 0;
  virtual ObjectBase &operator=( VHDLData & ){
    return *this;
  }

  bool operator==( const RValue &compareTo ) const {
    return readVal().operator==( compareTo );
  }
  bool operator!=( const RValue &compareTo ) const {
    return readVal().operator!=( compareTo );
  }
  bool operator>( const RValue &compareTo ) const {
    return readVal().operator>( compareTo );
  }
  bool operator>=( const RValue &compareTo ) const {
    return readVal().operator>=( compareTo );
  }
  bool operator<( const RValue &compareTo ) const {
    return readVal().operator<( compareTo );
  }
  bool operator<=( const RValue &compareTo ) const {
    return readVal().operator<=( compareTo );
  }

  /** This method creates another object of the same type as itself. */
  virtual ObjectBase* clone() const = 0;

  virtual void set_sourcebase_delete_flag( bool flag ) const {
    (void)flag; // quiet the compiler.
    cerr << " ERROR  ObjectBase:: set_sourcebase_delete_flag( bool flag ) called" << endl;
    abort();
  }

  virtual void setResolutionFunctionId(int) {
    cerr << " ERROR  ObjectBase::setResolutionFunctionId(int) called" << endl;
    abort();
  }

  virtual void setTypeConversionFunctionId(int) {
    cerr << " ERROR  ObjectBase::setTypeConversionFunctionId(int) called" << endl;
    abort();
  }

  virtual void setElaborationInfo(ObjectBase&) {
    cerr << "ERROR ObjectBase::setElaborationInfo(ObjectBase&) called" << endl;
    abort();
  }

  virtual void setNumAttributes(int ) {
    cerr << "ERROR ObjectBase::setNumAttributes(int) called" << endl;
    abort();
  }

  virtual void setAttrib(AttribType ,VHDLType& ) {
    cerr << "ERROR ObjectBase::setAttrib(AttribType, VHDLType&) called" << endl;
    abort();
  }

  virtual bool _is_signal() const { return false; }
  virtual void setBusKind() { 
    cerr << "ERROR ObjectBase::setBusKind() called" << endl;
  }

  VHDLType* parentCompositeType;

  virtual VHDLType *resolve( VHDLKernel * ) { return NULL; }

  virtual VHDLType* getParentCompositeType() {
    return parentCompositeType;
  }

  virtual void setParentCompositeType(VHDLType* ptr) {
    parentCompositeType = ptr;
  }

  virtual void setCompositeResolvedSignal(bool) {
    cerr << "ERROR: ObjectBase:: setCompositeResolvedSignal(bool) called " << endl;
    abort();
  }

  virtual void dump_connectivity_info(ofstream&) {
    cerr << "ERROR: ObjectBase:: dump_connectivity_info(ifstream&) called" << endl;
  }

  int getIntValue() const { return readVal().getIntValue(); }
  LONG getInt64Value() const { return readVal().getInt64Value(); }
  double getDoubleValue() const { return readVal().getDoubleValue(); }

protected:

private:

};
#endif
