#include "standard.hh"
#include "Signal.hh"
#include "ImplicitSignal.hh"
#include "Variable.hh"
#include "SignalNetinfo.hh"
#include "STDTypes.hh"
#include "SavantstringType.hh"

const EnumerationType ENUMERATION_ZERO(ObjectBase::VARIABLE, 0);
const EnumerationType ENUMERATION_ONE(ObjectBase::VARIABLE, 1);

EnumerationType::EnumerationType(ObjectBase::ObjectType objType): ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalInteger>; break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>; break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>; break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}

EnumerationType::EnumerationType(ObjectBase::ObjectType objType, 
				 const UniversalInteger& val): 
  ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}

EnumerationType::EnumerationType(ObjectBase::ObjectType objType,
                                 const IntegerType& value):
  ScalarType(objType) {
  UniversalInteger val = (UniversalInteger&) value.getVHDLData();
  switch(objType) {
  case ObjectBase::SIGNAL :
    object = new Signal<UniversalInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}


EnumerationType::EnumerationType(ObjectBase::ObjectType objType, 
				 const EnumerationType& value): 
  ScalarType(objType) {
  UniversalInteger val = (UniversalInteger&) value.getVHDLData();
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  range = value.range;
}

EnumerationType::EnumerationType(bool alias, const EnumerationType& actual) 
  : ScalarType(actual.getObject()->getKind(), alias) {
  object = actual.getObject();
}

EnumerationType::EnumerationType(const EnumerationType& value): ScalarType(value) {
  range = value.range;
}


// The new constructors
EnumerationType::EnumerationType(ObjectBase::ObjectType objType,
				 const enumInfo& eInfo): ScalarType(objType) {
  
  UniversalInteger initialValue((int) eInfo.get_left());
  
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalInteger>(initialValue);
    break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>(initialValue);
    break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>(initialValue);
    break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }

  // Copying the enumInfo information
  //range = new enumInfo(eInfo.get_no_of_elements(), eInfo.get_imageMap(),
  // eInfo.get_left(), eInfo.get_direction());

  range = eInfo;
}

// The new constructors
EnumerationType::EnumerationType(ObjectBase::ObjectType objType,
				 const TypeInfo& typeInfo): ScalarType(objType) {
  UniversalInteger initialValue((int) ((const enumInfo &) typeInfo).get_left());
  
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalInteger>(initialValue);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalInteger>(initialValue);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalInteger>(initialValue);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  
  range = (const enumInfo &) typeInfo;
}

EnumerationType::EnumerationType(ObjectBase::ObjectType objType, 
				 const UniversalInteger& val, 
				 const enumInfo& eInfo): 
  ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalInteger>(val);
    break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>(val);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalInteger>(val);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }

  // Copying the enumInfo information
  // range = new enumInfo(eInfo.get_no_of_elements(), eInfo.get_imageMap(),
  // 			 eInfo.get_left(), eInfo.get_direction());
  range = eInfo;
}


EnumerationType::EnumerationType(ObjectBase::ObjectType objType, 
				 const EnumerationType& value,
				 const enumInfo& eInfo): 
  ScalarType(objType) {
  UniversalInteger val = (UniversalInteger&) value.getVHDLData();
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalInteger>(val);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalInteger>(val);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalInteger>(val);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  // Copying the enumInfo information
  //range = new enumInfo(eInfo.get_no_of_elements(), eInfo.get_imageMap(),
  // eInfo.get_left(), eInfo.get_direction());
  range = eInfo;
}


EnumerationType::EnumerationType(const EnumerationType& value,
				 const enumInfo& eInfo): 
  ScalarType(value) { 
  //range = new enumInfo(eInfo.get_no_of_elements(), eInfo.get_imageMap(), 
  //eInfo.get_left(), eInfo.get_direction());
  range = eInfo;
}


EnumerationType::EnumerationType(bool alias, 
				 const EnumerationType& actual,
				 const enumInfo& eInfo)
  : ScalarType(actual.getObject()->getKind(), alias) {
  object = actual.getObject();
  // range = new enumInfo(eInfo.get_no_of_elements(), eInfo.get_imageMap(), 
  // 			 eInfo.get_left(), eInfo.get_direction());
  range = eInfo;
}

EnumerationType::~EnumerationType() {
}

EnumerationType&
EnumerationType::operator = (const EnumerationType& value) {
  ((ScalarType&) *this) = (const ScalarType &) value;
  range = (const enumInfo &) value.range;
  return *this;
}

Type 
EnumerationType::get_kind() const {
  return ENUMERATION_TYPE;
}

bool
operator == (const EnumerationType& lhs, const EnumerationType& rhs) {
  UniversalInteger lhs_val = (UniversalInteger &) lhs.getVHDLData();
  UniversalInteger rhs_val = (UniversalInteger &) rhs.getVHDLData();

  return INT_TO_BOOL(lhs_val.val == rhs_val.val);
}

EnumerationType
savantAnd(const EnumerationType& lhs, const EnumerationType& rhs) {
  UniversalInteger lhs_val, rhs_val, retval;
  lhs_val = (UniversalInteger&) lhs.getVHDLData();
  rhs_val = (UniversalInteger&) rhs.getVHDLData();

  retval = savantAnd(lhs_val, rhs_val);
  return EnumerationType(ObjectBase::VARIABLE, retval, SavantbooleanType_info);
}

EnumerationType
savantOr(const EnumerationType& lhs, const EnumerationType& rhs) {
  UniversalInteger lhs_val, rhs_val, retval;
  lhs_val = (UniversalInteger&) lhs.getVHDLData();
  rhs_val = (UniversalInteger&) rhs.getVHDLData();

  retval = savantOr(lhs_val, rhs_val);
  return EnumerationType(ObjectBase::VARIABLE, retval, SavantbooleanType_info);
}

EnumerationType
savantNot(const EnumerationType& op) {
  UniversalInteger op_val, retval;
  op_val = (UniversalInteger&) op.getVHDLData();

  retval = savantNot(op_val);
  return EnumerationType(ObjectBase::VARIABLE, retval, SavantbooleanType_info);
}

EnumerationType
savantNand(const EnumerationType& lhs, const EnumerationType& rhs) {
  UniversalInteger lhs_val, rhs_val, retval;
  lhs_val = (UniversalInteger&) lhs.getVHDLData();
  rhs_val = (UniversalInteger&) rhs.getVHDLData();

  retval = savantNand(lhs_val, rhs_val);
  return EnumerationType(ObjectBase::VARIABLE, retval, SavantbooleanType_info);
}

EnumerationType
savantNor(const EnumerationType& lhs, const EnumerationType& rhs) {
  UniversalInteger lhs_val, rhs_val, retval;
  lhs_val = (UniversalInteger&) lhs.getVHDLData();
  rhs_val = (UniversalInteger&) rhs.getVHDLData();

  retval = savantNor(lhs_val, rhs_val);
  return EnumerationType(ObjectBase::VARIABLE, retval, SavantbooleanType_info);
}

EnumerationType
savantXor(const EnumerationType& lhs, const EnumerationType& rhs) {
  UniversalInteger lhs_val, rhs_val, retval;
  lhs_val = (UniversalInteger&) lhs.getVHDLData();
  rhs_val = (UniversalInteger&) rhs.getVHDLData();

  retval = savantXor(lhs_val, rhs_val);
  return EnumerationType(ObjectBase::VARIABLE, retval, SavantbooleanType_info);
}

EnumerationType
savantXnor(const EnumerationType& lhs, const EnumerationType& rhs) {
  UniversalInteger lhs_val, rhs_val, retval;
  lhs_val = (UniversalInteger&) lhs.getVHDLData();
  rhs_val = (UniversalInteger&) rhs.getVHDLData();

  retval = savantXnor(lhs_val, rhs_val);
  return EnumerationType(ObjectBase::VARIABLE, retval, SavantbooleanType_info);
}

// The attributes of EnumerationType

EnumerationType 
EnumerationType::LEFT(const enumInfo& rInfo){
  return EnumerationType(ObjectBase::VARIABLE, (int)rInfo.get_left());
}

EnumerationType
EnumerationType::RIGHT(const enumInfo& rInfo){
  return EnumerationType(ObjectBase::VARIABLE, (int)rInfo.get_right());
}

EnumerationType
EnumerationType::HIGH(const enumInfo& rInfo){
  if (rInfo.get_left() > rInfo.get_right())
    return EnumerationType(ObjectBase::VARIABLE, (int)rInfo.get_left(), rInfo);
  else
    return EnumerationType(ObjectBase::VARIABLE, (int)rInfo.get_right(), rInfo);
}

EnumerationType
EnumerationType::LOW(const enumInfo& rInfo){
  if (rInfo.get_left() > rInfo.get_right())
    return EnumerationType(ObjectBase::VARIABLE, (int)rInfo.get_right(),rInfo);
  else
    return EnumerationType(ObjectBase::VARIABLE, (int)rInfo.get_left(), rInfo);
}

EnumerationType
EnumerationType::ASCENDING(const enumInfo& rInfo){
  if (rInfo.get_direction() == to){
    return SAVANT_BOOLEAN_TRUE;
  }
  else {
    return SAVANT_BOOLEAN_FALSE;
  }
}

EnumerationType
EnumerationType::SUCC(const EnumerationType& x){
  UniversalInteger val = x.getObject()->readVal();
  if(val >= x.range.get_left() && val < x.range.get_right()){
    val = val + 1;
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
  else {
    cerr << "The parameter to `SUCC is equal to 'HIGH\n";
    abort();
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
}

EnumerationType
EnumerationType::PRED(const EnumerationType& x){
  UniversalInteger val = x.getObject()->readVal();
  if(val > x.range.get_left() && val <= x.range.get_right()){
    val = val - 1;
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
  else {
    cerr << "The parameter to `PRED is equal to 'LOW\n";
    abort();
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
}

EnumerationType
EnumerationType::LEFTOF(const EnumerationType& x){
  UniversalInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val > x.range.get_left() &&
     val <= x.range.get_right()){
    val = val - 1;
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
  else if(x.range.get_direction() == downto && val <= x.range.get_left() &&
	  val > x.range.get_right()){
    val = val + 1;
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
  else {
    cerr << "The parameter of `LEFTOF attribute not within range\n";
    abort();
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
}

EnumerationType
EnumerationType::RIGHTOF(const EnumerationType& x){
  UniversalInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val >= x.range.get_left() &&
     val < x.range.get_right()){
    val = val + 1;
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
  else if(x.range.get_direction() == downto && val < x.range.get_left() &&
	  val >= x.range.get_right()){
    val = val - 1;
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
  else {
    cerr << "The parameter of `RIGHTOF attribute not within range\n";
    abort();
    return EnumerationType(ObjectBase::VARIABLE, val, x.range);
  }
}

SavantstringType 
EnumerationType::IMAGE(const EnumerationType& x) {
  UniversalInteger value;
  value = x.getObject()->readVal();
  if(value < x.range.get_right() && value >= x.range.get_left()){
    char *ptr =  x.range.get_imageMap()[value];
    SavantstringType image(ObjectBase::VARIABLE,0,to,strlen(ptr) - 1, ptr);
    return image;
  }
  else {
    cerr << "The parameter of `IMAGE attribute not withing range";
    abort();
    return SavantstringType(ObjectBase::VARIABLE, 0, to, 0);
  }
}

EnumerationType
EnumerationType::VALUE(const SavantstringType& x, const enumInfo& eInfo){
  int length = x.get_number_of_elements();
  strstream value;
  char* ptr;
  for(int i = 0; (i < length); i++) {
    x.get_element(i).print(value);
  }
  value << ends;
  ptr = value.str();
  UniversalInteger val = getIndex((const char*)ptr, eInfo.get_imageMap(),
				  eInfo.get_no_of_elements());
  if (val >= eInfo.get_left() && val <= eInfo.get_right()){
    return EnumerationType(ObjectBase::VARIABLE, val, eInfo);
  }

  return EnumerationType(ObjectBase::VARIABLE, eInfo);
}

IntegerType
EnumerationType::POS(const EnumerationType& x, const enumInfo& eInfo) {
  UniversalInteger val;
  val = x.getObject()->readVal();
  val = val -  eInfo.get_left();
  return IntegerType(ObjectBase::VARIABLE, val);
}

IntegerType
EnumerationType::POS(const EnumerationType& x) {
  UniversalInteger val;
  val = x.getObject()->readVal();
  return IntegerType(ObjectBase::VARIABLE, val);
}


EnumerationType
EnumerationType::VAL(const IntegerType& x, const enumInfo& eInfo){
  UniversalInteger value =  x.getObject()->readVal();
  if (value >= eInfo.get_left() &&  value <= eInfo.get_right()){
    value = value + eInfo.get_left();
    return EnumerationType(ObjectBase::VARIABLE, value);
  }
  else {
    cerr << "The parameter of `VAL attribute not withing range";
    abort();
    return EnumerationType(ObjectBase::VARIABLE, value);
  }
}

const VHDLData&
EnumerationType::leftValue() {
  static UniversalInteger retValue(0);
  
  retValue = UniversalInteger(range.get_left());
  
  return retValue;
}

ostream&
operator<<(ostream &os, const EnumerationType &var) {
  if (var.range.get_imageMap() == SavantcharacterType_info.get_imageMap()) {
    // Okay. This is a character type so use the default stuff, please!!
    os << (char) int((const UniversalInteger &) var.getVHDLData());
  }
  else {
    os << var.range.get_imageMap()[int((UniversalInteger &) var.getVHDLData())];
  }

  return os;
}

TypeInfo&
EnumerationType::getTypeInfo() const {
  return (TypeInfo &) range;
}
