#include "HTree.hh"

tree::~tree() {
  delete the_type;
  delete child_list;
}

bool tree::find_and_insert(TaggedRecord *elem) {
  iterator<tree *> p;
  tree *the_val;

  if ((child_list == 0) && (the_type == 0)) {
      // There has been no types inserted in this hierarchy so we insert the 
      // type into the hierarchy here
      the_type = elem;
      child_list = new list<tree *>;
      return true;
  }

  if (elem->tag->parent_table == the_type->tag) {
    the_val = new tree;
    the_val->the_type = elem;
    the_val->child_list = new list<tree *>;
    child_list->insert(the_val); // the_val is of type tree *
    return true;
  }

  p = child_list->begin();

  while (p.has_more_elements()) {
    if ((*p)->find_and_insert(elem) == true) {
      return true;
    }    
    ++p;
  }

  return false;
}

void tree::dfs() {
  iterator<tree *> p;
  if (child_list->is_empty() == true) {
    /* 
       This is where the actual element of the tree is accessed.
       Call virtual method in TaggedRecord class here (i.e. a get_size method
       of TaggedRecord class would be called like the_type->get_size();
    */
    return;
  }

  p = child_list->begin();
  while (p.has_more_elements()) { 
      (*p)->dfs();
      ++p;
  }
}

