#include "standard.hh"
#include "Signal.hh"
#include "ImplicitSignal.hh"
#include "Variable.hh"
#include "SignalNetinfo.hh"
#include "STDTypes.hh"
#include <math.h>
#include "SavantstringType.hh"

RealType::RealType() : ScalarType() {}

RealType::RealType(ObjectBase::ObjectType objType): ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalReal>;
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalReal>;
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalReal>;
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}
 
RealType::RealType(ObjectBase::ObjectType objType, const UniversalReal& val)
  : ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalReal>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalReal>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalReal>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}

RealType::RealType(ObjectBase::ObjectType objType, const RealType& value)
  : ScalarType(objType) {
  UniversalReal val = (UniversalReal&) value.getVHDLData();
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalReal>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalReal>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalReal>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }

  range = value.range;
}

RealType::RealType(bool alias, const RealType& actual) 
  : ScalarType(actual.getObject()->getKind(), alias) {
  object = actual.getObject();
}

RealType::RealType(const RealType& value): ScalarType(value) {
  range = value.range;
}

RealType&
RealType::operator = (const RealType& value) {
  ((ScalarType &) *this) = (const ScalarType &) value;
  range = (const realInfo &) value.range;
  return *this;
}

//new constructors for folding

RealType::RealType(ObjectBase::ObjectType objType,
		   const realInfo& rInfo): ScalarType(objType) {
  UniversalReal initialValue(rInfo.get_left());
  
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalReal>(initialValue);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalReal>(initialValue);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalReal>(initialValue);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  //Copying the range Info
  range = rInfo;
} 

RealType::RealType(ObjectBase::ObjectType objType, const TypeInfo &typeInfo) {
  UniversalReal initialValue(((const realInfo &) typeInfo).get_left());
  
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalReal>(initialValue);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalReal>(initialValue);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalReal>(initialValue);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  //Copying the range Info
  range = (const realInfo &) typeInfo;
}
									     
RealType::RealType(ObjectBase::ObjectType objType, 
		   const UniversalReal& val,
		   const realInfo& rInfo): 
  ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalReal>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalReal>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalReal>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  //Copying the range Information
  range = rInfo;
} 

RealType::RealType(ObjectBase::ObjectType objType, 
		   const RealType& value,
		   const realInfo& rInfo): 
  ScalarType(objType) {
  UniversalReal val = (UniversalReal&) value.getVHDLData();
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalReal>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalReal>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalReal>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  //Copying the range Information
  range = rInfo;
} 


RealType::RealType(const RealType& value, 
		   const realInfo& rInfo): ScalarType(value) { 
  range = rInfo;
}


RealType::RealType(bool alias, const RealType& actual,
		   const realInfo& rInfo) 
  : ScalarType(actual.getObject()->getKind(), alias) {
  object = actual.getObject();
  range = rInfo;
}


Type 
RealType::get_kind() const {
  return REAL_TYPE;
}

RealType
savantPlus(const RealType& lhs, const RealType& rhs) {
  UniversalReal retval;

  retval = savantPlus((const UniversalReal&) lhs.getVHDLData(),
		      (const UniversalReal&) rhs.getVHDLData());
  return RealType(ObjectBase::VARIABLE, retval);
}

RealType 
savantMinus(const RealType& lhs, const RealType& rhs) {
  UniversalReal retval;

  retval = savantMinus((const UniversalReal&) lhs.getVHDLData(),
		       (const UniversalReal&) rhs.getVHDLData());
  return RealType(ObjectBase::VARIABLE, retval);
}

RealType
savantUnaryPlus(const RealType& operand) {
  return operand;
}

RealType 
savantUnaryMinus(const RealType& operand) {
  UniversalReal retval = (UniversalReal &) operand.object->readVal();

  retval = UniversalReal( -1.0 * retval.val);
  return RealType(ObjectBase::VARIABLE, retval);
}

RealType
savantMultiply(const RealType& lhs, const RealType& rhs) {
  UniversalReal lhs_val, rhs_val, retval;

  lhs_val = (UniversalReal &) lhs.getVHDLData();
  rhs_val = (UniversalReal &) rhs.getVHDLData();

  retval = savantMultiply(lhs_val, rhs_val);

  return RealType(ObjectBase::VARIABLE, retval);
}

RealType
savantDivide(const RealType& lhs, const RealType& rhs) {
  UniversalReal lhs_val, rhs_val, retval;

  lhs_val = (UniversalReal &) lhs.getVHDLData();
  rhs_val = (UniversalReal &) rhs.getVHDLData();

  retval = savantDivide(lhs_val, rhs_val);

  return RealType(ObjectBase::VARIABLE, retval);
}

RealType
savantPow(const RealType& lhs, const IntegerType& rhs) {
  UniversalReal retval;

  retval = savantPow((const UniversalReal&) lhs.getVHDLData(),
		     (const UniversalInteger&) rhs.getVHDLData());
  return RealType(ObjectBase::VARIABLE, retval);
}

RealType
savantAbs(const RealType& value) {
  UniversalReal val = (UniversalReal &) value.getVHDLData();

  return RealType(ObjectBase::VARIABLE, fabs(val.val));
}

//The attributes of RealType

RealType 
RealType::LEFT(const realInfo& rInfo){
  return RealType(ObjectBase::VARIABLE, rInfo.get_left());
}

RealType
RealType::RIGHT(const realInfo& rInfo){
  return RealType(ObjectBase::VARIABLE, rInfo.get_right());
}

RealType
RealType::HIGH(const realInfo& rInfo){
  if (rInfo.get_left() > rInfo.get_right())
    return RealType(ObjectBase::VARIABLE, rInfo.get_left());
  else
    return RealType(ObjectBase::VARIABLE, rInfo.get_right());
}

RealType
RealType::LOW(const realInfo& rInfo){
  if (rInfo.get_left() > rInfo.get_right())
    return RealType(ObjectBase::VARIABLE, rInfo.get_right());
  else
    return RealType(ObjectBase::VARIABLE, rInfo.get_left());
}

EnumerationType
RealType::ASCENDING(const realInfo& rInfo){
  if (rInfo.get_direction() == to){
    return SAVANT_BOOLEAN_TRUE;
  }
  else {
    return SAVANT_BOOLEAN_FALSE;
  }
}

SavantstringType
RealType::IMAGE(const RealType& x){
  UniversalInteger val;
  val = x.getObject()->readVal();
  strstream string;
  string << val << ends;
  char* ptr = string.str();
  return SavantstringType(ObjectBase::VARIABLE,0,to,strlen(ptr)-1, ptr);
}

RealType
RealType::VALUE(const SavantstringType& x, const realInfo& rInfo) {
  int length = x.get_number_of_elements();
  strstream value;
  char* ptr;
  for(int i=0; i < length; i++) {
    x.get_element(i).print(value);
  }
  value << ends;
  ptr = value.str();
  double val = atof(ptr);
  
  return RealType(ObjectBase::VARIABLE, UniversalReal(val), rInfo);
}

RealType
RealType::VAL(const RealType& x, const realInfo& rInfo){
  UniversalReal val = x.getObject()->readVal();
  if((x.range.get_direction() == to && val >= x.range.get_left() &&
      val <= x.range.get_right()) || 
     (x.range.get_direction() == downto && val <= x.range.get_left() &&
      val >= x.range.get_right())){
    return RealType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The Result of `VAL attribute not withing range";abort();
    return RealType(ObjectBase::VARIABLE, val);
  }
}

RealType
RealType::POS(const RealType& x, const realInfo& rInfo){
  UniversalReal val = x.getObject()->readVal();
  return RealType(ObjectBase::VARIABLE, val);
}


const VHDLData&
RealType::leftValue() {
  static UniversalReal retValue(0.0);

  retValue = UniversalReal(range.get_left());

  return retValue;
}

TypeInfo&
RealType::getTypeInfo() const {
  return (TypeInfo &) range;
}
