#ifndef MARKEDQUEUE_HH
#define MARKEDQUEUE_HH
// Copyright (c) 1995 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: MarkedQueue.hh,v 1.8 1999/03/09 22:52:06 dmartin Exp $
//
//---------------------------------------------------------------------------
#include "Events.hh"
#include "SortedList.hh"
#include "VTime.hh"
#ifdef SEQUENTIAL 
#include "BaseSequential.hh"
#else
#include "BasicTimeWarp.hh"
#endif
extern int MarkedEventCompareRecv(const MarkedEvent*, const MarkedEvent*);

class MarkedQueue : public SortedList<MarkedEvent> {
public:
#ifdef SEQUENTIAL
  MarkedQueue(BaseSequential* btw) { 
    setFunc(MarkedEventCompareRecv);
    twHandle = btw;
  }
#else
   MarkedQueue(BasicTimeWarp* btw) { 
    setFunc(MarkedEventCompareRecv);
    twHandle = btw;
  }
#endif
  virtual ~MarkedQueue() {}

  void insert(SigEvent*);
  SigEvent* find(VTime, findMode_t);
  void gcollect(VTime);
  void rollbackTo(VTime&);

private:
  void mark(MarkedEvent*);
#ifdef SEQUENTIAL 
  BaseSequential *twHandle;
#else
  BasicTimeWarp *twHandle;
#endif
};
#endif

