#ifndef SELECTIONWIDGET_H
#define SELECTIONWIDGET_H

class SuperGraph;
class PProxy;
class SelectionProxy;

#include <tulip/tulipconf.h>
#include <tulip/Node.h>
#include <tulip/Edge.h>

#if (QT_REL == 4)
#include "tulip/Qt3ForTulip.h"
#endif

#include "tulip/FindSelectionData.h"

struct TLP_QT_SCOPE GItem {
  GItem( const node & inN ): n(inN), isnode(true) {}
  GItem( const edge & inE ): e(inE), isnode(false) {}
  node n;
  edge e;
  bool isnode;
};

class TLP_QT_SCOPE SelectionWidget : FindSelection {
  Q_OBJECT
    public:
  SelectionWidget(SuperGraph *superGraph, QWidget *parent = 0, const char *name = 0,
		  Qt::WFlags fl = 0);
  int exec();

 private:
  SuperGraph *superGraph;
  void insertProperties();
  int getOperation();
  int getSource();
  int getMode();
  void evalNodes(PProxy *, int, std::string, int, SelectionProxy *);
  void evalEdges(PProxy *, int, std::string, int, SelectionProxy *);
  static bool IsEvaluableProxy( PProxy *p);
  bool EvalProxy( PProxy *p, const GItem &gi, std::string value, int mode);
  virtual void propertyChanged( int no );
  PProxy *getProperty();
  void find(SelectionProxy *);
  
  protected slots:
    virtual void accept();
};
#endif //SELECTIONWIDGET_H
