#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tulip/LayoutProxy.h>
#include "tulip/GlGraph.h"

//This function should rewriten completly
DataSet GlGraph::getParameters() const {
  TRACE_EXEC();
  DataSet data;
  //  data.set("glyphTable", getGlyphTable());
  //Color
  data.set("backgroundColor", backgroundColor);
  //bool
  data.set("_viewArrow", _viewArrow);
  data.set("_viewLabel", _viewLabel);
  data.set("_viewMetaLabel", _viewMetaLabel);
  data.set("_viewStrahler", _viewStrahler);
  data.set("_viewAutoScale", _viewAutoScale);
  data.set("_incrementalRendering", _incrementalRendering);
  data.set("_edgeColorInterpolate", _edgeColorInterpolate);
  data.set("_edgeSizeInterpolate", _edgeSizeInterpolate);
  data.set("_edge3D", _edge3D);
  //unsigned int
  data.set("_viewOrtho", _viewOrtho);
  data.set("_FontsType", _FontsType);
  //int
  data.set("SupergraphId", _superGraph->getId());
  //Coord
  data.set("sceneTranslation", getSceneTranslation());
  data.set("sceneRotation", getSceneRotation());
  data.set("cameraEyes", cameraEyes);
  data.set("cameraCenter", cameraCenter);
  data.set("cameraUp", cameraUp);
  data.set("cameraZoomFactor", cameraZoomFactor);
  data.set("distCam", distCam);
  return data;
}

static SuperGraph *findSuperGraphById(SuperGraph *sg, const int id) {
  if (sg->getId()==id) return sg;
  Iterator<SuperGraph *> *itS=sg->getSubGraphs();
  while (itS->hasNext()) {
    SuperGraph *tmp=findSuperGraphById(itS->next(),id);
    if (tmp!=0) {delete itS; return tmp;}
  } delete itS;
  return 0;
}

//This function should rewriten completly
void GlGraph::setParameters(const DataSet data) {
  TRACE_EXEC();
  int id;
  /*  if (data.get<int>("SupergraphId", id)) {
    //    Cluster *cluster=_superGraph->getClusterTree();
    //    SubGraph *subgraph=cluster->getRootSubGraph();
    SuperGraph *sg = findSuperGraphById(_superGraph->getRoot(), id);
    if (sg != NULL) {
      setSuperGraph(sg);
      LayoutProxy *tmp = getProperty<LayoutProxy>(sg, "viewLayout");
      if (tmp != elementLayout) this->init();
    }
  }
  */
  //  GlyphTableString glyphtab;
  //  if (data.get<GlyphTableString>("glyphTable", glyphtab)) setGlyphTable(glyphtab);
  Color color;
  if (data.get<Color>("backgroundColor", color)) backgroundColor=color;
  bool b;
  if (data.get<bool>("_viewArrow", b))
    setViewArrow(b);
  if (data.get<bool>("_viewLabel", b))
    setViewLabel(b);
  if (data.get<bool>("_viewMetaLabel", b)) 
    setViewMetaLabel(b);
  if (data.get<bool>("_viewStrahler", b)) 
    setViewStrahler(b);
  if (data.get<bool>("_viewAutoScale", b)) _viewAutoScale=b;
  if (data.get<bool>("_incrementalRendering", b)) 
    setIncrementalRendering(b);
  if (data.get<bool>("_edgeColorInterpolate", b)) 
    setEdgeColorInterpolate(b);
  if (data.get<bool>("_edgeSizeInterpolate", b)) 
    setEdgeColorInterpolate(b);
  if (data.get<bool>("_edge3D", b)) 
    setEdge3D(b);
  unsigned int ui;
  if (data.get<unsigned int>("_viewOrtho", ui)) _viewOrtho=ui;
  if (data.get<unsigned int>("_FontsType", ui)) _FontsType=ui;
  this->goodScale();
  //restore all view parameters or none
  Coord st,sr,ce,cc,cu;
  double czf;
  GLfloat dc;
  if (data.get<Coord>("sceneTranslation", st)
      && data.get<Coord>("sceneRotation", sr)
      && data.get<Coord>("cameraEyes", ce)
      && data.get<Coord>("cameraCenter", cc)
      && data.get<Coord>("cameraUp", cu)
      && data.get<double>("cameraZoomFactor", czf)
      && data.get<GLfloat>("distCam", dc))
    {
      setSceneTranslation(st);
      setSceneRotation(sr);
      cameraEyes = ce; cameraCenter = cc; cameraUp = cu;
      cameraZoomFactor = czf;
      distCam = dc;
    }
}
//====================================================
Camera GlGraph::getCamera() const {
  return Camera(cameraCenter,cameraEyes,cameraUp,cameraZoomFactor, distCam);
}
void GlGraph::setCamera(const Camera &cam) {
  makeCurrent();
  cameraCenter = cam.center;
  cameraEyes = cam.eyes;
  cameraUp = cam.up;
  cameraZoomFactor = cam.zoomFactor;
  distCam = cam.sceneRadius;
  initLights();
  initProjection();
  initModelView();
}
//====================================================
unsigned int GlGraph::getLabelsBorder() const {return labelsBorder;}
void GlGraph::setLabelsBorder(const unsigned int border){labelsBorder = border;}
//====================================================
bool GlGraph::isViewMetaLabel()const {return (_viewMetaLabel);}
void GlGraph::setViewMetaLabel(bool b){_viewMetaLabel=b;}
//====================================================
unsigned int GlGraph::fontsType()const {return (_FontsType);}
void GlGraph::setFontsType(unsigned int i){_FontsType=i;}
void GlGraph::setFontsPath(std::string path){fontsPath=path;}
//====================================================
bool GlGraph::isIncrementalRendering() const {return (_incrementalRendering);}
void GlGraph::setIncrementalRendering(const bool b) {
  _incrementalRendering=b;
}
//====================================================
bool GlGraph::isDisplayEdges() const {return (_displayEdges);}
void GlGraph::setDisplayEdges(const bool b){_displayEdges=b;}
//====================================================
bool GlGraph::isViewArrow() const {return (_viewArrow);}
void GlGraph::setViewArrow(const bool b){_viewArrow=b;}
//====================================================
bool GlGraph::isViewOrtho() const {return (_viewOrtho);}
void GlGraph::setViewOrtho(const bool b){_viewOrtho=b;}
//====================================================
bool GlGraph::isViewStrahler() const {return (_viewStrahler);}
void GlGraph::setViewStrahler(const bool b) {
  if (_viewStrahler==b) return;
  if (_superGraph==0) return;
  _viewStrahler=b;
  if (b) {
    buildOrderedList();
  }
}
//====================================================
bool GlGraph::isEdged3D() const {return _edge3D;}
void GlGraph::setEdge3D(const bool b) {_edge3D=b;}
//====================================================
bool GlGraph::isViewLabel()const {return (_viewLabel);}
void GlGraph::setViewLabel(const bool b){_viewLabel=b;}
//====================================================
bool GlGraph::isEdgeColorInterpolate()const {return (_edgeColorInterpolate);}
void GlGraph::setEdgeColorInterpolate(const bool b){_edgeColorInterpolate=b;}
//====================================================
bool GlGraph::isEdgeSizeInterpolate()const {return (_edgeSizeInterpolate);}
void GlGraph::setEdgeSizeInterpolate(const bool b){_edgeSizeInterpolate=b;}
//====================================================
Color GlGraph::getBackgroundColor() const {return backgroundColor;}
void GlGraph::setBackgroundColor(int r,int v,int b){
  backgroundColor.set(r,v,b);
}
void GlGraph::setBackgroundColor(const Color &color){
  backgroundColor=color;
}
//====================================================
void GlGraph::getWinParameters(int *winX, int *winY, int *winW, int *winH, GLint *vp[4]) {
  *winX = this->winX;
  *winY = this->winY;
  *winW = this->winW;
  *winH = this->winH;
  for (int i=0; i<4; ++i)
    (*vp)[i]=this->viewportArray[i];
}
void GlGraph::setInputLayout(const std::string &layoutName) {
  this->layoutName=layoutName;
  initProxies();
}
