//*********************************************************************************
//** GlADPoint.cpp : Source for an augmented display point
//** 
//** author : Delorme Maxime
//** date   : 29/07/05
//*********************************************************************************

#include "tulip/GlADPoint.h"

namespace tlp
{
  GlADPoint::GlADPoint()
  {
    position = new Coord(0, 0, 0);
    color    = new Color(0, 0, 0);
  }

  GlADPoint::GlADPoint(const Coord &pos, const Color &col)
  {
    this->position = new Coord(pos);
    this->color    = new Color(col);
  }

  GlADPoint::~GlADPoint()
  {
  }

  void GlADPoint::draw(GlGraph* graph)
  {
    GLfloat *col = color->getGL();

    setup();

    glPointSize(5);
    glBegin(GL_POINTS);
    glColor4fv(col);
    glVertex3f(position->getX(), position->getY(), position->getZ());
    glEnd(); 

    unsetup();
  }

  Coord GlADPoint::getPosition() const
  {
    return *position;
  }

  Color GlADPoint::getColor() const
  {
    return *color;
  }

  void GlADPoint::setPosition(const Coord &position)
  {
    delete this->position;

    this->position = new Coord(position);
  }

  void GlADPoint::setColor(const Color &color)
  {
    delete this->color;

    this->color = new Color(color);
  }
}
