# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

e2e-intro-description = Para enviar mensajes cifrados o firmados digitalmente, debe configurar una tecnología de cifrado, ya sea OpenPGP o S/MIME.
e2e-intro-description-more = Seleccione su clave personal para habilitar el uso de OpenPGP o su certificado personal para habilitar el uso de S/MIME. Para una clave personal o certificado usted posee la clave secreta correspondiente.
openpgp-key-user-id-label = Cuenta / ID de usuario
openpgp-keygen-title-label =
    .title = Generar clave OpenPGP
openpgp-cancel-key =
    .label = Cancelar
    .tooltiptext = Cancelar generación de clave
openpgp-key-gen-expiry-title =
    .label = Expiración de clave
openpgp-key-gen-expire-label = La clave expira en
openpgp-key-gen-days-label =
    .label = días
openpgp-key-gen-months-label =
    .label = meses
openpgp-key-gen-years-label =
    .label = años
openpgp-key-gen-no-expiry-label =
    .label = La clave no expira
openpgp-key-gen-key-size-label = Tamaño de clave
openpgp-key-gen-console-label = Generación de clave
openpgp-key-gen-key-type-label = Tipo de clave
openpgp-key-gen-key-type-rsa =
    .label = RSA
openpgp-key-gen-key-type-ecc =
    .label = ECC (curva elíptica)
openpgp-generate-key =
    .label = Generar clave
    .tooltiptext = Generar una nueva clave OpenPGP compatible para cifrar y/o firmar.
openpgp-advanced-prefs-button-label =
    .label = Avanzadas…
openpgp-keygen-desc = <a data-l10n-name="openpgp-keygen-desc-link">NOTA: La generación de clave puede tomar varios minutos para completarse.</a> No salga de la aplicación mientras la generación de clave esté en proceso. Navegar activamente o realizar operaciones de uso intensivo de disco mientras se genere la clave reaprovisionará el 'grupo de aleatoriedad' y acelerará el proceso. Aparecerá una alerta cuando se complete la generación de clave.
openpgp-key-expiry-label =
    .label = Expiración
openpgp-key-id-label =
    .label = ID de clave
openpgp-cannot-change-expiry = Esta es una clave con una estructura compleja, no se admite cambiar su fecha de vencimiento.
openpgp-key-man-title =
    .title = Administrador de claves OpenPGP
openpgp-key-man-generate =
    .label = Nuevo par de claves
    .accesskey = v
openpgp-key-man-gen-revoke =
    .label = Certificado de revocación
    .accesskey = r
openpgp-key-man-ctx-gen-revoke-label =
    .label = Generar y guardar certificado de revocación
openpgp-key-man-file-menu =
    .label = Archivo
    .accesskey = A
openpgp-key-man-edit-menu =
    .label = Editar
    .accesskey = E
openpgp-key-man-view-menu =
    .label = Ver
    .accesskey = V
openpgp-key-man-generate-menu =
    .label = Generar
    .accesskey = G
openpgp-key-man-keyserver-menu =
    .label = Servidor de clave
    .accesskey = K
openpgp-key-man-import-public-from-file =
    .label = Importar clave(s) pública(s) desde archivo
    .accesskey = I
openpgp-key-man-import-secret-from-file =
    .label = Importar clave(s) secreta(s) desde archivo
openpgp-key-man-import-sig-from-file =
    .label = Importar revocación(es) desde archivo
openpgp-key-man-import-from-clipbrd =
    .label = Importar clave(s) desde el portapapeles
    .accesskey = I
openpgp-key-man-import-from-url =
    .label = Importar clave(s) desde URL
    .accesskey = U
openpgp-key-man-export-to-file =
    .label = Exportar clave(s) pública(s) a archivo
    .accesskey = E
openpgp-key-man-send-keys =
    .label = Enviar clave(s) pública(s) por correo electrónico
    .accesskey = s
openpgp-key-man-backup-secret-keys =
    .label = Respaldar clave(s) secreta(s) en un archivo
    .accesskey = B
openpgp-key-man-discover-cmd =
    .label = Descubrir claves en línea
    .accesskey = D
openpgp-key-man-discover-prompt = Para descubrir claves OpenPGP en línea, en servidores de claves o utilizando el protocolo WKD, ingrese una dirección de correo electrónico o una ID de clave.
openpgp-key-man-discover-progress = Buscando…
openpgp-key-copy-key =
    .label = Copiar clave pública
    .accesskey = C
openpgp-key-export-key =
    .label = Exportar clave pública a archivo
    .accesskey = E
openpgp-key-backup-key =
    .label = Respaldar clave secreta en un archivo
    .accesskey = B
openpgp-key-send-key =
    .label = Enviar clave pública por correo electrónico
    .accesskey = b
openpgp-key-man-copy-to-clipbrd =
    .label = Copiar clave(s) pública(s) al portapapeles
    .accesskey = C
openpgp-key-man-ctx-expor-to-file-label =
    .label = Exportar claves a archivo
openpgp-key-man-ctx-copy-to-clipbrd-label =
    .label = Copiar claves públicas al portapapeles
openpgp-key-man-close =
    .label = Cerrar
openpgp-key-man-reload =
    .label = Recargar caché de clave
    .accesskey = R
openpgp-key-man-change-expiry =
    .label = Cambiar fecha de expiración
    .accesskey = e
openpgp-key-man-del-key =
    .label = Borrar clave(s)
    .accesskey = B
openpgp-delete-key =
    .label = Borrar clave
    .accesskey = o
openpgp-key-man-revoke-key =
    .label = Revocar clave
    .accesskey = R
openpgp-key-man-key-props =
    .label = Propiedades de clave
    .accesskey = v
openpgp-key-man-key-more =
    .label = Más
    .accesskey = M
openpgp-key-man-view-photo =
    .label = ID fotográfico
    .accesskey = f
openpgp-key-man-ctx-view-photo-label =
    .label = Ver ID fotográfico
openpgp-key-man-show-invalid-keys =
    .label = Mostrar claves inválidas
    .accesskey = d
openpgp-key-man-show-others-keys =
    .label = Mostrar claves de otras personas
    .accesskey = o
openpgp-key-man-user-id-label =
    .label = Nombre
openpgp-key-man-fingerprint-label =
    .label = Huella digital
openpgp-key-man-select-all =
    .label = Seleccionar todas las claves
    .accesskey = a
openpgp-key-man-empty-tree-tooltip =
    .label = Ingresar términos de búsqueda en el cuadro de arriba
openpgp-key-man-nothing-found-tooltip =
    .label = Ninguna clave coincide con los términos de búsqueda
openpgp-key-man-please-wait-tooltip =
    .label = Espere mientras las claves se cargan…
openpgp-key-man-filter-label =
    .placeholder = Buscar claves
openpgp-key-man-select-all-key =
    .key = A
openpgp-key-man-key-details-key =
    .key = I
openpgp-key-details-title =
    .title = Propiedades de clave
openpgp-key-details-signatures-tab =
    .label = Certificationes
openpgp-key-details-structure-tab =
    .label = Estructura
openpgp-key-details-uid-certified-col =
    .label = ID de usuario / Certificado por
openpgp-key-details-user-id2-label = Presunto propietario de clave
openpgp-key-details-id-label =
    .label = ID
openpgp-key-details-key-type-label = Tipo
openpgp-key-details-key-part-label =
    .label = Parte de la clave
openpgp-key-details-algorithm-label =
    .label = Algoritmo
openpgp-key-details-size-label =
    .label = Tamaño
openpgp-key-details-created-label =
    .label = Creada
openpgp-key-details-created-header = Creada
openpgp-key-details-expiry-label =
    .label = Expiración
openpgp-key-details-expiry-header = Expiración
openpgp-key-details-usage-label =
    .label = Uso
openpgp-key-details-fingerprint-label = Huella digital
openpgp-key-details-sel-action =
    .label = Seleccionar acción…
    .accesskey = S
openpgp-key-details-also-known-label = Identidades alternativas presuntas del propietario de la clave:
openpgp-card-details-close-window-label =
    .buttonlabelaccept = Cerrar
openpgp-acceptance-label =
    .label = Aceptación
openpgp-acceptance-rejected-label =
    .label = No, rechazar esta clave.
openpgp-acceptance-undecided-label =
    .label = Todavía no, quizás más tarde.
openpgp-acceptance-unverified-label =
    .label = Sí, pero no he verificado que sea la clave correcta.
openpgp-acceptance-verified-label =
    .label = Sí, he verificado en persona que esta clave tiene la huella digital correcta.
key-accept-personal =
    Para esta clave, tiene tanto la parte pública como la secreta. Puede utilizarla como clave personal.
    Si otra persona le dio esta clave, no la use como clave personal.
key-personal-warning = ¿Creó esta clave usted mismo y la propiedad de la clave que se muestra se refiere a usted mismo?
openpgp-personal-no-label =
    .label = No, no usar como mi clave personal.
openpgp-personal-yes-label =
    .label = Sí, tratar esta clave como una clave personal.
openpgp-copy-cmd-label =
    .label = Copiar

## e2e encryption settings

#   $count (Number) - the number of configured keys associated with the current identity
#   $identity (String) - the email address of the currently selected identity
openpgp-description =
    { $count ->
        [0] Thunderbird no tiene una clave personal OpenPGP para <b>{ $identity }</b>
        [one] Thunderbird encontró { $count } clave personal OpenPGP asociada con <b>{ $identity }</b>
       *[other] Thunderbird encontró { $count } claves personales OpenPGP asociadas con <b>{ $identity }</b>
    }
#   $count (Number) - the number of configured keys associated with the current identity
#   $key (String) - the currently selected OpenPGP key
openpgp-selection-status =
    { $count ->
        [0] Elija una clave válida para habilitar el protocolo OpenPGP
        [one] Su configuración actual usa la ID de clave <b> { $key } </b>
       *[other] Sus configuraciones actuales usan la ID de clave <b> { $key } </b>
    }
#   $key (String) - the currently selected OpenPGP key
openpgp-selection-status-error = Su configuración actual utiliza la clave <b>{ $key }</b> que ya caducó.
openpgp-add-key-button =
    .label = Agregar clave…
    .accesskey = A
e2e-learn-more = Conocer más
openpgp-keygen-success = ¡Clave OpenPGP creada exitosamente!
openpgp-keygen-import-success = ¡Clave OpenPGP importada exitosamente!
openpgp-keygen-external-success = ¡ID de clave GnuPG externa guardada!

## OpenPGP Key selection area

openpgp-radio-none =
    .label = Ninguna
openpgp-radio-none-desc = No use OpenPGP para esta identidad.
#   $key (String) - the expiration date of the OpenPGP key
openpgp-radio-key-expires = Expira el: { $date }
openpgp-key-expires-image =
    .tooltiptext = La clave expira en menos de 6 meses
#   $key (String) - the expiration date of the OpenPGP key
openpgp-radio-key-expired = Expiró el: { $date }
openpgp-key-expired-image =
    .tooltiptext = Clave expirada
openpgp-key-expand-section =
    .tooltiptext = Más información
openpgp-key-revoke-title = Revocar clave
openpgp-key-edit-title = Cambiar clave OpenPGP
openpgp-key-edit-date-title = Extender fecha de expiración
openpgp-manager-description = Usar OpenPGP Key Manager para ver y administrar las claves públicas de sus corresponsales y todas las demás claves que no se enumeran anteriormente.
openpgp-manager-button =
    .label = Administrador de claves OpenPGP
    .accesskey = G
openpgp-key-remove-external =
    .label = Eliminar ID de clave externa
    .accesskey = E
key-external-label = C!ave GnuPG externa
# Strings in keyDetailsDlg.xhtml
key-type-public = clave pública
key-type-primary = clave primaria
key-type-subkey = subclave
key-type-pair = par de claves (clave secreta y clave pública)
key-expiry-never = nunca
key-usage-encrypt = Cifrar
key-usage-sign = Firma
key-usage-certify = Certificar
key-usage-authentication = Autenticación
key-does-not-expire = La clave no expira
key-expired-date = La clave expiró el { $keyExpiry }
key-expired-simple = La clave ya expiró
key-revoked-simple = La clave fue revocada
key-do-you-accept = ¿Acepta está clave para verificar firmas digitales y para cortar mensajes?
key-accept-warning = Evite aceptar una clave falsa. Utilice un canal de comunicación que no sea el correo electrónico para verificar la huella digital de la clave de su interlocutor.
# Strings enigmailMsgComposeOverlay.js
cannot-use-own-key-because = No se puede enviar el mensaje porque hay un problema con su clave personal. { $problem }
cannot-encrypt-because-missing = No se puede enviar este mensaje cifardo de punta a punta porque hay problemas con las claves de los siguientes destinatarios: { $problem }
window-locked = La ventana de redacción está bloqueada; enviar cancelado
# Strings in mimeDecrypt.jsm
mime-decrypt-encrypted-part-attachment-label = Parte del mensaje cifrado
mime-decrypt-encrypted-part-concealed-data = Esta es una parte de mensaje cifrado. Tiene que abrirla en una ventana separada haciendo clic en el archivo adjunto.
# Strings in keyserver.jsm
keyserver-error-aborted = Abortado
keyserver-error-unknown = Ocurrió un error desconocido
keyserver-error-server-error = El servidor de claves informó de un error.
keyserver-error-import-error = No se pudo importar la clave descargada.
keyserver-error-unavailable = El servidor de claves no está disponible.
keyserver-error-security-error = El servidor de claves no admite el acceso cifrado.
keyserver-error-certificate-error = El certificado del servidor de claves no es válido.
keyserver-error-unsupported = El servidor de claves no es compatible.
# Strings in mimeWkdHandler.jsm
wkd-message-body-req =
    Su proveedor de correo electrónico procesó su solicitud para cargar su clave pública en el directorio de claves web de OpenPGP.
    Confirme para completar la publicación de su clave pública.
wkd-message-body-process =
    Este es un correo electrónico relacionado con el procesamiento automático para cargar su clave pública en el directorio de claves web de OpenPGP.
    No es necesario que realice ninguna acción manual en este momento.
# Strings in persistentCrypto.jsm
converter-decrypt-body-failed =
    No se pudo descifrar el mensaje con el asunto
    { $subject }.
    ¿Quiere volver a intentarlo con una frase de contraseña diferente o quiere saltarte el mensaje?
# Strings in gpg.jsm
unknown-signing-alg = Algoritmo de firma desconocido (ID): { $id })
unknown-hash-alg = Hash criptográfico desconocido (ID: { $id })
# Strings in keyUsability.jsm
expiry-key-expires-soon =
    Su clave { $desc } caducará en menos de { $days } días.
    Le recomendamos que cree un nuevo par de claves y que configure las cuentas correspondientes para usarla.
expiry-keys-expire-soon =
    Sus siguientes claves caducarán en menos de { $days } días:{ $desc }.
    Le recomendamos que cree nuevas claves y que configure las cuentas correspondientes para usarlas.
expiry-key-missing-owner-trust =
    Su clave secreta { $desc } perdió confianza.
    Le recomendamos que cambie "confía en las certificaciones" a "ultimate" en la propiedades de la clave.
expiry-keys-missing-owner-trust =
    Las siguientes claves secretas no tienen confianza.
    { $desc }.
    Le recomendamos que establezca "Confía en las certificaciones" en "ultimate" en las propiedades de la clave.
expiry-open-key-manager = Abrir administrador de claves OpenPGP
expiry-open-key-properties = Abrir propiedades de la clave
# Strings filters.jsm
filter-folder-required = Debe seleccionar una carpeta de destino.
filter-decrypt-move-warn-experimental =
    Advertencia: la acción de filtrado "Descifrar permanentemente" puede provocar la destrucción de mensajes.
    Le recomendamos encarecidamente que primero pruebe el filtro "Crear copia descifrada", pruebe el resultado con cuidado y comience a usar este filtro solo una vez que esté satisfecho con el resultado.
filter-term-pgpencrypted-label = OpenPGP cifrado
filter-key-required = Debe seleccionar una clave de destinatario.
filter-key-not-found = No se pudo encontrar una clave de cifrado para '{ $desc }'.
filter-warn-key-not-secret =
    Advertencia: la acción de filtro "Cifrar en clave" reemplaza a los destinatarios.
    Si no tiene la clave secreta para '{ $desc }', ya no podrá leer los correos electrónicos.
# Strings filtersWrapper.jsm
filter-decrypt-move-label = Descifrar permanentemente (OpenPGP)
filter-decrypt-copy-label = Crear copia descifrada (OpenPGP)
filter-encrypt-label = Cifrar a clave (OpenPGP)
# Strings in enigmailKeyImportInfo.js
import-info-title =
    .title = ¡Claves importadas correctamente!
import-info-bits = Bits
import-info-created = Creado
import-info-fpr = Huella digital
import-info-details = Ver Detalles y administrar la aceptación de claves
import-info-no-keys = No se importaron las claves.
# Strings in enigmailKeyManager.js
import-from-clip = ¿Quiere importar alguna(s) clave(s) del portapapeles?
import-from-url = Descargue la clave pública de esta URL:
copy-to-clipbrd-failed = No se pudieron copiar las claves seleccionadas al portapapeles.
copy-to-clipbrd-ok = Clave(s) copiada(s) al portapapeles
delete-secret-key =
    ADVERTENCIA: ¡Está a punto de eliminar una clave secreta!
    
    Si elimina su clave secreta, ya no podrá descifrar ningún mensaje cifrado para esa clave, ni podrá revocarla.
    
    ¿Realmente quiere eliminar AMBOS, la clave secreta y la clave pública?
    '{ $userId }'?
delete-mix =
    ADVERTENCIA: ¡Está a punto de eliminar una clave secreta!
    Si elimina su clave secreta, ya no podrá descifrar ningún mensaje cifrado para esa clave, ni podrá revocarla.
    ¿Realmente quiere eliminar AMBOS, la clave secreta y la clave pública?
delete-pub-key =
    ¿Quiere eliminar la clave pública?
    '{ $userId }'?
delete-selected-pub-key = ¿Quiere eliminar las claves públicas?
refresh-all-question = No seleccionó ninguna tecla. ¿Le gustaría actualizar TODAS las claves?
key-man-button-export-sec-key = Exportar las &claves secretas
key-man-button-export-pub-key = Exportar solo las &claves públicas
key-man-button-refresh-all = &Actualizar todas las claves
key-man-loading-keys = Cargando claves, espere ...
ascii-armor-file = Archivos blindados ASCII (* .asc)
no-key-selected = Debe seleccionar al menos una tecla para realizar la operación seleccionada
export-to-file = Exportar clave pública a un archivo
export-keypair-to-file = Exportar clave pública y secreta al archivo
export-secret-key = ¿Quiere incluir la clave secreta en el archivo de claves OpenPGP guardado?
save-keys-ok = Las claves se guardaron correctamente
save-keys-failed = Falló el guardado de claves
default-pub-key-filename = Claves-públicas-exportadas
default-pub-sec-key-filename = Respaldo-de-claves-secretas
refresh-key-warn = Advertencia: dependiendo de la cantidad de claves y la velocidad de conexión, actualizar todas las claves puede ser un proceso bastante largo.
preview-failed = No se puede leer el archivo de la clave pública.
general-error = Error: { $reason }
dlg-button-delete = &Eliminar

## Account settings export output

openpgp-export-public-success = <b> ¡Clave pública exportada correctamente! </b>
openpgp-export-public-fail = <b>¡No se puede exportar la clave pública seleccionada!</b>
openpgp-export-secret-success = <b>¡Clave secreta exitosamente exportada!</b>
openpgp-export-secret-fail = <b>¡No se puede exportar la clave pública seleccionada!</b>
# Strings in keyObj.jsm
key-ring-pub-key-revoked = La clave { $userId } (ID de clave { $keyId }) está revocada.
key-ring-pub-key-expired = La clave { $userId } (ID de clave { $keyId }) ya caducó.
key-ring-key-disabled = La clave { $userId } (ID clave { $keyId }) está deshabilitada; no puede usarse.
key-ring-key-invalid = La clave { $userId } (ID de clave { $keyId }) no es válida. Considere verificarla correctamente.
key-ring-key-not-trusted = La clave { $userId } (ID de clave { $keyId }) no es suficientemente confiable. Establezca el nivel de confianza de su clave para "ultimate" y úselo para firmar.
key-ring-no-secret-key = No parece tener la clave secreta para { $userId } (ID de clave { $keyId }) en su llavero; no puede utilizar la clave para firmar.
key-ring-pub-key-not-for-signing = La clave { $userId } (ID de clave { $keyId }) no puede usarse para firmar.
key-ring-pub-key-not-for-encryption = La clave { $userId } (ID clave { $keyId }) no puede usarse para el cifrado.
key-ring-sign-sub-keys-revoked = Todas las subclaves de firma de la clave { $userId } (ID clave { $keyId }) están revocadas.
key-ring-sign-sub-keys-expired = Todas las subclaves de firma de la clave { $userId } (ID clave { $keyId }) caducaron.
key-ring-sign-sub-keys-unusable = Todas las subclaves de firma de la clave { $userId } (ID clave { $keyId }) se revocaron o caducaron. No se pueden usar.
key-ring-enc-sub-keys-revoked = Todas las subclaves de cifrado de la clave { $userId } (ID clave { $keyId }) están revocadas.
key-ring-enc-sub-keys-expired = Todas las subclaves de cifrado de la clave { $userId } (ID clave { $keyId }) caducaron.
key-ring-enc-sub-keys-unusable = Todas las subclaves de cifrado de la clave { $userId } (ID clave { $keyId }) están revocadas o caducadas. No se pueden usar.
# Strings in gnupg-keylist.jsm
keyring-photo = Foto
user-att-photo = Atributo de usuario (imagen JPEG)
# Strings in key.jsm
already-revoked = Esta clave ya fue revocada.
#   $identity (String) - the id and associated user identity of the key being revoked
revoke-key-question =
    Está a punto de revocar la clave '{ $identity }'.
    Ya no podrá firmar con esta clave y, una vez distribuida, otras personas ya no podrán cifrar con esa clave. Aún puede usar la clave para descifrar mensajes antiguos.
    ¿Quiere proceder?
#   $keyId (String) - the id of the key being revoked
revoke-key-not-present =
    No tiene ninguna clave (0x{ $keyId }) que coincida con este certificado de revocación.
    Si perdió su clave, ¡tiene que importarla (por ejemplo, desde un servidor de teclado) antes de importar el certificado de revocación!
#   $keyId (String) - the id of the key being revoked
revoke-key-already-revoked = La clave 0x { $keyId } ya fue revocada.
key-man-button-revoke-key = &Revocar clave
openpgp-key-revoke-success = Clave revocada correctamente.
after-revoke-info =
    La clave fue revocada.
    Comparta esta clave pública de nuevo, enviándola por correo electrónico o subiéndola a los servidores de claves para que otros sepan que revocó su clave.
    Tan pronto como el software usado por otras personas se entere de la revocación, dejará de usar su antigua clave.
    Si está usando una nueva clave para la misma dirección de correo electrónico, y adjunta la nueva clave pública a los correos que envía, la información sobre su antigua clave revocada se va a incluir automáticamente.
# Strings in keyRing.jsm & decryption.jsm
key-man-button-import = &Importar
delete-key-title = Borrar clave OpenPGP
delete-external-key-title = Eliminar la clave GnuPG externa
delete-external-key-description = ¿Quiere eliminar esta ID de clave GnuPG externa?
key-in-use-title = Clave OpenPGP actualmente en uso
delete-key-in-use-description = ¡No se puede proceder! La clave que seleccionó para eliminar está siendo usada por esta identidad. Seleccione una clave diferente o ningua, y vuelva a intentarlo.
revoke-key-in-use-description = ¡No se puede proceder! La clave que seleccionó para revocar está siendo usada por esta identidad. Seleccione una clave diferente o ningua, y vuelva a intentarlo.
# Strings used in errorHandling.jsm
key-error-key-spec-not-found = La dirección de correo '{ $keySpec }' no puede coincidir con una clave en su llavero.
key-error-key-id-not-found = La clave configurada '{ $keySpec }' no se encuentra en su llavero.
key-error-not-accepted-as-personal = No confirmó que la clave con ID '{ $keySpec }' sea su clave personal.
# Strings used in enigmailKeyManager.js & windows.jsm
need-online = La función que seleccionó no está disponible en el modo fuera de línea. Conéctese y vuelva a intentarlo.
# Strings used in keyRing.jsm & keyLookupHelper.jsm
no-key-found = No pudimos encontrar ninguna clave que coincida con los criterios de búsqueda especificados.
# Strings used in keyRing.jsm & GnuPGCryptoAPI.jsm
fail-key-extract = Error: falló el comando de extracción de claves
# Strings used in keyRing.jsm
fail-cancel = Error: la recepción de clave fue cancelada por el usuario
not-first-block = Error: el primer bloque OpenPGP no es un bloque de clave pública
import-key-confirm = ¿Importar clave(s) pública(s) incrustadas en el mensaje?
fail-key-import = Error: no se pudo importar la clave
file-write-failed = Fallo al escribir en el archivo { $output }
no-pgp-block = Error: no se encontró un bloque de datos OpenPGP blindado válido
confirm-permissive-import = La importación falló. La clave que está intentando importar puede estar dañada o utilizar atributos desconocidos. ¿Le gustaría intentar importar las partes correctas? Esto puede resultar en la importación de claves incompletas e inutilizables.
# Strings used in trust.jsm
key-valid-unknown = desconocido
key-valid-invalid = Inválido
key-valid-disabled = deshabilitado
key-valid-revoked = revocado
key-valid-expired = caducado
key-trust-untrusted = no confiable
key-trust-marginal = marginal
key-trust-full = confiable
key-trust-ultimate = último
key-trust-group = (grupo)
# Strings used in commonWorkflows.js
import-key-file = Importar archivo de clave de OpenPGP
import-rev-file = Importar archivo de revocación de OpenPGP
gnupg-file = Archivos GnuPG
import-keys-failed = Falló la importación de las claves
passphrase-prompt = Ingrese la frase de contraseña para desbloquear la siguiente clave: { $key }
file-to-big-to-import = Este archivo es demasiado grande. No importe un gran conjunto de claves a la vez.
# Strings used in enigmailKeygen.js
save-revoke-cert-as = Crear y guardar certificado de revocación
revoke-cert-ok = El certificado de revocación se creó correctamente. Puede usarlo para invalidar su clave pública, por ejemplo en caso de que perdiera su clave secreta.
revoke-cert-failed = El certificado de revocación no pudo ser creado.
gen-going = ¡Generación de claves ya está en proceso!
keygen-missing-user-name = No hay nombre especificado para la cuenta actual. Ingrese un valor el el campo "Your name" en la configuración de cuenta.
expiry-too-short = La clave debe ser válida por al menos un día.
expiry-too-long = No se puede crear una clave que caduque en más de 100 años.
key-confirm = ¿Generar clave pública y secreta para '{ $id }'?
key-man-button-generate-key = &Generar clave
key-abort = ¿Abortar generación de clave?
key-man-button-generate-key-abort = &Abortar generación de clave
key-man-button-generate-key-continue = &Continuar generación de clave
# Strings used in enigmailMessengerOverlay.js
failed-decrypt = Error: no se pudo descifrar
fix-broken-exchange-msg-failed = No se pudo reparar el mensaje.
attachment-no-match-from-signature = No se pudo hacer coincidir el archivo de firma '{ $attachment }' con un adjunto
attachment-no-match-to-signature = No se pudo hacer coincidir el archivo adjunto '{ $attachment }' con un archivo de firma
signature-verified-ok = La firma del archivo adjunto { $attachment } se verificó correctamente
signature-verify-failed = No se pudo verificar la firma del archivo adjunto { $attachment }
decrypt-ok-no-sig =
    Advertencia
    El descifrado se realizó correctamente, pero la firma no se pudo verificar correctamente
msg-ovl-button-cont-anyway = &Continuar de todas maneras
enig-content-note = *Los archivos adjuntos a este mensaje no se firmaros ni cifraron*
# Strings used in enigmailMsgComposeOverlay.js
msg-compose-button-send = Enviar men&saje
msg-compose-details-button-label = Detalles…
msg-compose-details-button-access-key = D
send-aborted = Operación de envío abortada.
key-not-trusted = No hay suficiente confianza para la clave '{ $key }'
key-not-found = Clave '{ $key }' no encontrada
key-revoked = Clave '{ $key }' revocada
key-expired = Clave '{ $key }' expirada
msg-compose-internal-error = Ocurrió un error interno.
keys-to-export = Seleccionar claves OpenPGP para insertar
msg-compose-partially-encrypted-inlinePGP =
    El mensaje al que está respondiendo contenía partes cifradas y no cifradas. Si el remitente no pudo descifrar algunas partes del mensaje, es posible que usted esté filtrando información confidencial que el remitente no pudo descifrar por su cuenta.
    Considere eliminar todo el texto citado de su respuesta a este remitente.
msg-compose-cannot-save-draft = Error al guardar el borrador
msg-compose-partially-encrypted-short = Tenga cuidado con la filtración de información confidencial: correo electrónico parcialmente cifrado.
quoted-printable-warn =
    Habilitó la codificación 'quoted-printable' para enviar mensajes. Esto puede resultar en un descifrado incorrecto y/o verificación de su mensaje.
    ¿Quiere desactivar ahora el envío de mensajes "quoted-printable"?
minimal-line-wrapping =
    Configuró la línea para cubrir { $width } caracteres. Para un cifrado y/o firma correctos, este valor debe ser al menos de 68.
    ¿Quiere cambiar la línea que envuelve a 68 caracteres ahora?
sending-hidden-rcpt = Los destinatarios CCO (copia oculta) no se pueden utilizar al enviar un mensaje cifrado. Para enviar este mensaje cifrado, elimine los destinatarios CCO o muévalos al campo CC.
sending-news =
    Se abortó la operación de envío cifrado.
    Este mensaje no se puede cifrar porque hay destinatarios de grupos de noticias. Vuelva a enviar el mensaje sin cifrar.
send-to-news-warning =
    Advertencia: está a punto de enviar un correo electrónico cifrado a un grupo de noticias.
    Esto se desaconseja porque solo tiene sentido si todos los miembros del grupo pueden descifrar el mensaje, es decir, el mensaje debe cifrarse con las claves de todos los participantes del grupo. Envíe este mensaje solo si sabe exactamente lo que está haciendo.
    ¿Continúa?
save-attachment-header = Guardar adjunto descifrado
no-temp-dir =
    No se pudo encontrar un directorio temporal en el que escribir
    Establezca la variable de entorno TEMP
possibly-pgp-mime = Posiblemente mensaje cifrado o firmado PGP / MIME; use la función 'Decrypt/Verify' para verificar
cannot-send-sig-because-no-own-key = No se puede firmar digitalmente este mensaje porque todavía no configuró elcifrado de punta a punta para <{ $key }>
cannot-send-enc-because-no-own-key = No se puede enviar este mensaje cifrado, porque todavía no configuró el cifrado de punta a punta  para <{ $key }>
# Strings used in decryption.jsm
do-import-multiple =
    ¿Importar las siguientes claves?
    { $key }
do-import-one = ¿Importar { $name } ({ $id })?
cant-import = Error al importar la clave pública
unverified-reply = La parte del mensaje con sangría (respuesta) fue probablemente modificada
key-in-message-body = Se encontró una clave en el cuerpo del mensaje. Haga clic en 'Importar clave' para importar la clave
sig-mismatch = Error: discrepancia en la firma
invalid-email = Error: direcciones de correo electrónico inválidas
attachment-pgp-key =
    El adjunto '{ $name }' que estáa abriendo parece ser un archivo de claves OpenPGP.
    Haga clic en 'Importar' para importar las claves que contiene o 'Ver' para ver los contenidos del archivo en una ventana del navegador
dlg-button-view = &Ver
# Strings used in enigmailMsgHdrViewOverlay.js
decrypted-msg-with-format-error = Mensaje descifrado (formato de correo electrónico PGP roto restaurado probablemente causado por un servidor Exchange antiguo, por lo que el resultado podría no ser perfecto para leer)
# Strings used in encryption.jsm
not-required = Error: no se requiere cifrado
# Strings used in windows.jsm
no-photo-available = No hay foto disponible
error-photo-path-not-readable = La ruta de la foto '{ $photo }' no es legible
debug-log-title = Registro de depuración de OpenPGP
# Strings used in dialog.jsm
repeat-prefix = Esta alerta se repetirá { $count }
repeat-suffix-singular = más tiempo.
repeat-suffix-plural = mas veces.
no-repeat = Esta alerta no se va a volver a mostrar.
dlg-keep-setting = Recordar mi respuesta y no volver a preguntarme
dlg-button-ok = &Aceptar
dlg-button-close = &Cerrar
dlg-button-cancel = &Cancelar
dlg-no-prompt = No mostrar este diálogo nuevamente
enig-prompt = Aviso de OpenPGP
enig-confirm = Confirmación de OpenPGP
enig-alert = Alerta de OpenPGP
enig-info = Información de OpenPGP
# Strings used in persistentCrypto.jsm
dlg-button-retry = &Reintentar
dlg-button-skip = &Saltar
# Strings used in enigmailCommon.js
enig-error = Error de OpenPGP
enig-alert-title =
    .title = Alerta de OpenPGP
