

#!/bin/sh
name=abverz.tex
echo \\documentclass{article} > $name
echo %%% uncomment this if you want descriptions in German language >> $name
echo % \\usepackage{german} >> $name
echo \\usepackage[T1]{fontenc} >> $name
echo "\\usepackage{formula,longtable,vmargin}" >> $name
echo \\setpapersize{A4} >> $name
echo \\setmargins{20mm}{9mm}{180mm}{240mm}{12pt}{11mm}{0pt}{11mm} >> $name
echo \\input $1 >> $name
echo \\setlongtables >> $name
echo \\begin{document} >> $name
echo \\begin{longtable}{llp{10cm}} >> $name
grep -h "^ *\\\\formula" $1 | sed -e "/^\\\\formula[^ ]*  *{*\([A-Za-z]*\)}* .*/s//\\\\\\1my/" >> $name
echo \\end{longtable} >> $name
echo \\end{document} >> $name


