// Copyright (c) 1999, 2000 David A. Bartold
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

/////// Start of User Definable Parameters and Their Defaults ///////////////

// TF_HEIGHT_FIELD
//
// Declares the height field object that's positioned with one corner at
// the origin

#ifndef (TF_HEIGHT_FIELD)
#declare TF_HEIGHT_FIELD = height_field { tga "TF_FILE" smooth }
#end

// TF_WATER_LEVEL
//
// The parameter is a float between [0.0, 0.9].  The smaller the number,
// the more land that is above water.

#ifndef (TF_WATER_LEVEL)
#declare TF_WATER_LEVEL = 0.33;
#end


// TF_Y_SCALE_FACTOR
//
// This parameter is a float between (0.0, 1.0].  Basically, it sets the
// height of the rendered terrain

#ifndef (TF_Y_SCALE_FACTOR)
#declare TF_Y_SCALE_FACTOR = 0.33;
#end

// TF_[XYZ]_SCALE
//
// This parameter is a float between (0.0, 1.0].  Basically, it sets the
// scale vector of the rendered terrain

#ifndef (TF_X_SCALE)
#declare TF_X_SCALE = 1000;
#end
#ifndef (TF_Z_SCALE)
#declare TF_Z_SCALE = 1000;
#end
#ifndef (TF_Y_SCALE)
#declare TF_Y_SCALE = (TF_X_SCALE+TF_Z_SCALE)/2*TF_Y_SCALE_FACTOR;
#end


// TF_SCALE
//
// This parameter is a vector used to set the size of the terrain.

#ifndef (TF_SCALE)
#declare TF_SCALE = <TF_X_SCALE, TF_Y_SCALE, TF_Z_SCALE>;
#end

// TF_REAL_LIGHTING
//
// Set true if you want a sun, moon, stars, sunrise, sunset, etc.  Otherwise,
// render with a single light to give a plastic model look.

#ifndef (TF_REAL_LIGHTING)
#declare TF_REAL_LIGHTING = true;
#end

// TF_HAVE_SUNBEAMS
//
// Set it to true if you want a sunbeam-like effect.  The parameter
// has an effect only if TF_REAL_LIGHTING is also set true.

#ifndef (TF_HAVE_SUNBEAMS)
#declare TF_HAVE_SUNBEAMS = false;
#end

// TF_FAST_SUNBEAMS
//
// Set it to render the sunbeams quickly, in exchange for smoothness.
// The sky will look slightly grainy if this is set.  This parameter
// only has an effect if sunbeams are turned on.

#ifndef (TF_FAST_SUNBEAMS)
#declare TF_FAST_SUNBEAMS = true;
#end

// TF_HAVE_WATER
//
// Self explanatory.

#ifndef (TF_HAVE_WATER)
#declare TF_HAVE_WATER = true;
#end

// TF_WATER_CLARITY
//
// Water clarity is expressed as a float from [0.0, 1.0].  It has no
// effect if water is disabled.
//
// e.x.  0.0  = Murky
//       0.95 = Clear freshwater

#ifndef (TF_WATER_CLARITY)
#declare TF_WATER_CLARITY = 0.95;
#end

// TF_TIME_OF_DAY
//
// Time of day is expressed as the number of hours given by a float
// in the range of [0.0, 24.0)
//
// e.x.  0.0  = (12:00am) Midnight
//       6.25 = ( 6:15am) Around sunrise
//      12.0  = (12:00pm) Noon

#ifndef (TF_TIME_OF_DAY)
#declare TF_TIME_OF_DAY = 12.0;
#end

// TF_HAVE_CLOUDS
//
// Self explanatory.

#ifndef (TF_HAVE_CLOUDS)
#declare TF_HAVE_CLOUDS = true;
#end

// TF_HAVE_FOG
//
// Turn on for a ground-level fog.

#ifndef (TF_HAVE_FOG)
#declare TF_HAVE_FOG = false;
#end

// TF_NORTH_DIR
//
// Set the direction for north.  Normally (when this parameter is 0.0),
// north is defined as the top of the height field image.  Direction
// is in degrees and positive numbers rotate the sun clockwise.

// e.x.  0.0: North = Up
//      90.0: North = Right

#ifndef (TF_NORTH_DIR)
#declare TF_NORTH_DIR = 0.0;
#end

// TF_CAMERA_LOCATION
//
// Set the camera's location.

#ifndef (TF_CAMERA_LOCATION)
#declare TF_CAMERA_LOCATION = <0,  (TF_X_SCALE+TF_Z_SCALE)/2*1.5, -1.4*TF_Z_SCALE>;
#end

// TF_CAMERA_LOOK_AT
//
// Set the location to which the camera points.

#ifndef (TF_CAMERA_LOOK_AT)
#declare TF_CAMERA_LOOK_AT = <0, 0, 0>;
#end

/////// End of User Definable Parameters ////////////////////////////////////
