/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-wdg-conn-param.h:
 * Widgets Connection Parameter - Abstract Class
 * Used by TIDialogRequestConn ("Request Connection" dialog)
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_WDG_CONN_PARAM_H__
#define __TI_WDG_CONN_PARAM_H__

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIWdgConnParam TIWdgConnParam;
typedef struct _TIWdgConnParamClass TIWdgConnParamClass;

#define TI_TYPE_WDG_CONN_PARAM \
  (ti_wdg_conn_param_get_type ())
#define TI_WDG_CONN_PARAM(object) \
  (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_WDG_CONN_PARAM, \
                               TIWdgConnParam))
#define TI_WDG_CONN_PARAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_WDG_CONN_PARAM, \
                            TIWdgConnParamClass))
#define TI_IS_WDG_CONN_PARAM(object) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_WDG_CONN_PARAM))
#define TI_IS_WDG_CONN_PARAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_WDG_CONN_PARAM))
#define TI_WDG_CONN_PARAM_GET_CLASS(object) \
  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_WDG_CONN_PARAM, \
                              TIWdgConnParamClass))

struct _TIWdgConnParam {
    GObject parent;
    GtkWidget *label;
    GtkWidget *value;
};

GType ti_wdg_conn_param_get_type (void);

 /**
  * Returns a GValue of the currently entered value.
  *
  * @return A new GValue. Must be unset and freed after use.
  */
GValue *ti_wdg_conn_param_get_value (TIWdgConnParam *conn_param);

/**
 * Returns parameter's name.
 *
 * @return Parameter's name.
 */
const gchar *ti_wdg_conn_param_get_name (TIWdgConnParam *conn_param);

#endif
