/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-page.h:
 * Abstract class for all TIPage* classes.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_PAGE_H__
#define __TI_PAGE_H__

#include <gtk/gtk.h>
#include <glib-object.h>

/*
 * Type macros.
 */

typedef struct _TIPage TIPage;
typedef struct _TIPageClass TIPageClass;
typedef struct _TIPagePrivate TIPagePrivate;

#define TI_TYPE_PAGE               ti_page_get_type()
#define TI_PAGE(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_PAGE, TIPage))
#define TI_PAGE_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PAGE, TIPageClass))
#define TI_IS_PAGE(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_PAGE))
#define TI_IS_PAGE_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PAGE))
#define TI_PAGE_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_PAGE, TIPageClass))

struct _TIPage {
    GObject parent;
    TIPagePrivate *priv;
};

GType ti_page_get_type (void);

/**
 * Detach from Notebook (if currently attached to one)
 *
 */
void ti_page_detach_from_notebook (TIPage *page);

/**
 * Attach to Notebook
 *
 * Attach that page to a notebook. If already attached to another notebook,
 * it will automatically detach itself from it first.
 */
void ti_page_attach_to_notebook (TIPage *page, GtkNotebook *notebook);

#endif
