/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-dlg-user-presence.c:
 * Dialog for the  SetPresence() method on
 * [...].Telepathy.Connection.Interface.SimplePresence interface.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "dlg-user-presence.h"
#include "util.h"
#include "config.h"

#include <glade/glade.h>

G_DEFINE_TYPE (TIDlgUserPresence, ti_dlg_user_presence, G_TYPE_OBJECT);

/**
 * Instance private data.
 */
struct _TIDlgUserPresencePrivate {
    gboolean disposed;

    GtkWindow *parent;

    GladeXML *glade_xml;

    GtkWidget *dialog;

    GtkWidget *comboentry_status;
    GtkWidget *entry_status_message;
};
typedef struct _TIDlgUserPresencePrivate TIDlgUserPresencePrivate;

#define TI_DLG_USER_PRESENCE_GET_PRIVATE(object) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((object), TI_TYPE_DLG_USER_PRESENCE, \
                                  TIDlgUserPresencePrivate))

static void
ti_dlg_user_presence_dispose (GObject *object)
{
  TIDlgUserPresence *self = TI_DLG_USER_PRESENCE (object);
  TIDlgUserPresencePrivate *priv = TI_DLG_USER_PRESENCE_GET_PRIVATE (self);

  if (priv->disposed)
    {
      return;
    }

  priv->disposed = TRUE;

  if (priv->glade_xml != NULL)
    {
      g_object_unref (priv->glade_xml);
      priv->glade_xml = NULL;
    }

  G_OBJECT_CLASS (ti_dlg_user_presence_parent_class)->dispose (object);
}

static void
ti_dlg_user_presence_class_init (TIDlgUserPresenceClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->dispose = ti_dlg_user_presence_dispose;
  g_type_class_add_private (klass, sizeof (TIDlgUserPresencePrivate));
}

static void
ti_dlg_user_presence_init (TIDlgUserPresence *self)
{
  TIDlgUserPresencePrivate *priv = TI_DLG_USER_PRESENCE_GET_PRIVATE (self);

  priv->disposed = FALSE;
}

TIDlgUserPresence *
ti_dlg_user_presence_new (GtkWindow *parent,
                        GtkTreeModel *tree_model,
                        guint column)
{
  TIDlgUserPresence *self = NULL;
  gchar *glade_file_path = NULL;
  TIDlgUserPresencePrivate *priv = NULL;

  self = g_object_new (TI_TYPE_DLG_USER_PRESENCE, NULL);
  priv = TI_DLG_USER_PRESENCE_GET_PRIVATE (self);

  priv->parent = parent;

  glade_file_path = ti_get_glade_path ("dlg-user-presence.xml");
  priv->glade_xml = glade_xml_new (glade_file_path, NULL, NULL);

  if (priv->glade_xml == NULL)
    {
      g_critical ("Error loading glade file \"%s\".", glade_file_path);
      g_object_unref (self);
      self = NULL;
      goto CLEAN_UP;
    }

  priv->dialog = glade_xml_get_widget (priv->glade_xml, "dialog_user_presence");
  g_assert (GTK_IS_DIALOG (priv->dialog));

  priv->comboentry_status = glade_xml_get_widget (priv->glade_xml,
      "comboentry_status");
  g_assert (GTK_IS_COMBO_BOX_ENTRY (priv->comboentry_status));

  priv->entry_status_message = glade_xml_get_widget (priv->glade_xml,
      "entry_status_message");
  g_assert (GTK_IS_ENTRY (priv->entry_status_message));

  gtk_window_set_transient_for (GTK_WINDOW (priv->dialog),
      GTK_WINDOW (priv->parent));
  gtk_window_set_position (GTK_WINDOW (priv->dialog),
      GTK_WIN_POS_CENTER_ON_PARENT);

  glade_xml_signal_connect_data (priv->glade_xml, "button_ok_clicked",
      G_CALLBACK(ti_ok_button_clicked), priv->dialog);
  glade_xml_signal_connect_data (priv->glade_xml, "button_cancel_clicked",
      G_CALLBACK(ti_cancel_button_clicked), priv->dialog);

  gtk_combo_box_set_model (GTK_COMBO_BOX (priv->comboentry_status),
      tree_model);
  gtk_combo_box_entry_set_text_column (
      GTK_COMBO_BOX_ENTRY (priv->comboentry_status), column);

CLEAN_UP:
  g_free (glade_file_path);

  return self;
}

gboolean
ti_dlg_user_presence_run (TIDlgUserPresence *self,
                            gchar **status, gchar **message)
{
  TIDlgUserPresencePrivate *priv = TI_DLG_USER_PRESENCE_GET_PRIVATE (self);
  gint result;

  g_return_val_if_fail (status != NULL, FALSE);
  g_return_val_if_fail (message != NULL, FALSE);
  g_return_val_if_fail (*status == NULL, FALSE);
  g_return_val_if_fail (*message == NULL, FALSE);

  gtk_window_set_title (GTK_WINDOW (priv->dialog), "Set Presence");

  gtk_widget_show_all (priv->dialog);
  result = gtk_dialog_run (GTK_DIALOG (priv->dialog));
  gtk_widget_hide_all (priv->dialog);

  *status = gtk_combo_box_get_active_text (
      GTK_COMBO_BOX (priv->comboentry_status));
  *message = g_strdup(gtk_entry_get_text (
    GTK_ENTRY(priv->entry_status_message)));

  if (*message == NULL)
    *message = g_strdup("");

  if (*status == NULL)
    {
      return FALSE;
    }
  else
    {
      return (result == GTK_RESPONSE_OK);
    }
}
