/* ====================================================================
 * Copyright (c) 2003-2006, The Subcommander Crew
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Mutex.h"

// apr
#include <apr_thread_mutex.h>


namespace sc
{

/**
 * Create mutex.
 * We use an unnested mutex. Although this is slower on Win32, recursive mutexes have not proven
 * to ease debugging. If a recursive mutex is required this may be a sign of a design problem.
 */
Mutex::Mutex()
{
  apr_thread_mutex_create( &_mutex, APR_THREAD_MUTEX_UNNESTED, _pool );
}

Mutex::~Mutex()
{
  apr_thread_mutex_destroy(_mutex);
}

void Mutex::lock()
{
  apr_thread_mutex_lock(_mutex);
}

void Mutex::unlock()
{
  apr_thread_mutex_unlock(_mutex);
}

} // namespace
