/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CommitItem.h"


namespace svn
{

CommitItem::CommitItem( svn_client_commit_item_t* item )
{
  _path = sc::String(item->path);
  _url  = sc::String(item->url);
  _kind = (NodeKind)item->kind;
  _flags = (Flag)item->state_flags;

  _copyfromUrl = sc::String(item->copyfrom_url);
  _copyfromRev = item->revision;

  if( item->wcprop_changes )
  {
    for( int i = 0; i < item->wcprop_changes->nelts; i++ )
    {
      svn_prop_t& prop = APR_ARRAY_IDX(item->wcprop_changes,i,svn_prop_t);
      _props.push_back( Property(&prop) );
    }
  }
}

const sc::String& CommitItem::getPath() const
{
  return _path;
}

const sc::String& CommitItem::getUrl() const
{
  return _url;
}

NodeKind CommitItem::getKind() const
{
  return _kind;
}

bool CommitItem::isFile() const
{
  return _kind == Node_File;
}

bool CommitItem::isDir() const
{
  return _kind == Node_Dir;
}

long CommitItem::getFlags() const
{
  return _flags;
}

const Properties& CommitItem::getProperties() const
{
  return _props;
}

const sc::String CommitItem::getCopyFromUrl() const
{
  return _copyfromUrl;
}

const Revnumber CommitItem::getCopyFromRev() const
{
  return _copyfromRev;
}



} // namespace

