/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CheckoutDialogCmd.h"
#include "subcommander/CheckoutDialog.h"
#include "subcommander/ExternProviderImpl.h"
#include "subcommander/BaseModel.h"
#include "subcommander/Project.h"
#include "subcommander/PostCmdResult.h"
#include "subcommander/commands/CheckoutParam.h"


CheckoutDialogCmd::CheckoutDialogCmd( QWidget* parent, ID tid, BaseModel* model )
: _parent(parent), _tid(tid), _model(model)
{
}

void CheckoutDialogCmd::run( const QString& src, const QString& dst, Project* prj )
{
  ExternProviderImpl externProvider(_model);
  
  CheckoutDialog *dlg = new CheckoutDialog(
    &externProvider, _model->isCmdRecursive(), true, _parent );

  dlg->setRepositoryUrl(src);
  dlg->enableRepositoryUrl(false);

  dlg->setWorkingCopyPath(dst);

  int result = dlg->exec();

  if( result != QDialog::Accepted )
  {
    return;
  }

  if( dlg->isAddToProject() )
  {
    sc::String path( dlg->getWorkingCopyPath().utf8() );
    sc::String name( dlg->getWorkingCopyPath().section( '/', -1 ).utf8() );
    
    Project::Item item = prj->createWorkingCopyItem();
    item.setName( name );
    item.setSource( path );
    prj->setItem(item);

    _model->saveProject(prj);
  }

  CheckoutParam* param = new CheckoutParam( 
    sc::String(dlg->getRepositoryUrl().utf8()),
    sc::String(dlg->getWorkingCopyPath().utf8()),
    dlg->getPegRevision(), dlg->getRevision(),
    dlg->isRecursive() );

  PostCmdResult* pcres = new PostCmdResult(_tid);
  
  _model->checkout( param, pcres );

  delete dlg;
}
