/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "EditConflictCmd.h"
#include "EditConflictParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "util/apr.h"
#include "svn/Client.h"
#include "svn/WcStatus.h"
#include "svn/WcEntry.h"
#include "svn/Error.h"


EditConflictCmd::EditConflictCmd( EditConflictParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

EditConflictCmd::~EditConflictCmd()
{
  delete _cb;
}

void EditConflictCmd::run()
{
  _prgscb->started( getId(), _param, getCancel() );

  sc::Error* err = _client->visualMerge( _param->getStatus() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
