/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CHECKOUTPARAM_H
#define _SC_CHECKOUTPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"


/**
 * Parameter class for CheckoutCmd.
 */
class CheckoutParam : public ScParam
{
public:
  /**
   * construct a CheckoutParam object. It takes ownership of \a rev.
   */
  CheckoutParam( const sc::String& url, const sc::String& path, const svn::Revision* peg,
     const svn::Revision* rev, bool recurse )
    : _url(url), _path(path), _peg(peg), _rev(rev), _recurse(recurse)
  {
  }

  ~CheckoutParam()
  {
    delete _peg;
    delete _rev;
  }

  const sc::String& getUrl() const
  {
    return _url;
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  const svn::Revision* getPegRevision() const
  {
    return _peg;
  }

  const svn::Revision* getRevision() const
  {
    return _rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  svn::Revnumber& getRevnumber()
  {
    return _revnum;
  }

  ScParamAccept(CheckoutParam);

private:
  // in
  sc::String           _url;
  sc::String           _path;
  const svn::Revision* _peg;
  const svn::Revision* _rev;
  bool                 _recurse;

  // out
  svn::Revnumber       _revnum;
};

#endif // _SC_CHECKOUTPARAM_H
