/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SCMODEL_H
#define _SC_SCMODEL_H

// sc
#include "settings/ProjectSettings.h"
#include "settings/CommitLogHistory.h"
#include "sublib/DebugSettings.h"
#include "util/String.h"
#include "util/Mutex.h"
class ConfigManager;
class FontSettings;
class LayoutSettings;
class CmdProgressCallback;
class ScCmd;
class ListCache;


namespace svn
{
  class Client;
}

// apr
struct apr_pool_t;



class ScModel
{
public:
  ScModel( ConfigManager* conf );
  ~ScModel();

  /**
   *  \name Project handling.
   */
  // @{
  Project* createProject();
  void addProject( Project* project );
  void removeProject( Project* project );
  const Projects& getProjects();
  void reorderProjects( Project* src, Project* dst );
  void saveProject( Project* project );
  // @}

  /**
   * \name Command handling.
   */
  // @{
  void run( ScCmd* cmd, bool async = true );
  void runAsync( ScCmd* cmd );
  void runSync( ScCmd* cmd );
  // @}

  /**
   * \name various svn info.
   */
  // @{
  bool isWorkingCopy( const sc::String& path );
  // @}

  /**
   *  \name Status options.
   */
  // @{
  bool getOptionStatusAll();
  bool getOptionStatusUpdates();
  bool getOptionStatusIgnored();
  bool getOptionStatusRecurse();

  void setOptionStatusAll( bool b );
  void setOptionStatusUpdates( bool b );
  void setOptionStatusIgnored( bool b );
  void setOptionStatusRecurse( bool b );
  // @}

  /**
   * \name Command options.
   */
  // @{
  bool getOptionCommandRecurse();
  bool getOptionCommandForce();

  void setOptionCommandRecurse( bool b );
  void setOptionCommandForce( bool b );
  // @}


  /**
   * Takes ownership of CmdProgressCallback.
   */
  void setProgressCallback( CmdProgressCallback* );

  /**
   * Get the full path to the merge program.
   */
  sc::String getMergeProc() const;

  /**
   * Settings
   */
  void saveSettings();
  FontSettings* getFontSettings();
  LayoutSettings* getLayoutSettings();
  CommitLogHistory* getCommitLogHistory();

  /**
   * caches..
   */
  ListCache* getListCache();

private:
  svn::Client* createSvnClient( unsigned long id ) const;

private:
  sc::Mutex            _sync;     ///< synchronize access to members
  apr_pool_t*          _pool;

  ConfigManager*       _conf;

  Projects             _projects;

  CmdProgressCallback* _progress;

  ListCache*           _listCache;

  /**
   * global configuration information
   */
  bool _statusAll;               ///< show all files in working copy view
};

#endif // _SC_SCMODEL_H
