/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGRAPHCANVASVIEW_H
#define _SC_LOGGRAPHCANVASVIEW_H

// sc
#include "ActionStorage.h"
class LogGraphCanvasItem;

// qt
#include <qcanvas.h>
class QPopupMenu;


class LogGraphCanvasView : public QCanvasView
{
  typedef QCanvasView super;
  Q_OBJECT;

public:
  LogGraphCanvasView( QWidget* parent = 0 );
  virtual ~LogGraphCanvasView();

  void mousePressEvent( QMouseEvent* e );
  void mouseMoveEvent( QMouseEvent* e );
  void contextMenuEvent( QContextMenuEvent* e );
  void keyPressEvent( QKeyEvent* e );
  void keyReleaseEvent( QKeyEvent* e );

  const LogGraphCanvasItem* getSelection1() const;
  const LogGraphCanvasItem* getSelection2() const;

  const QString& getRoot() const;
  void setRoot( QString& root );

public slots:
    void diffTrigger();

signals:
  void diffRequested();
  void selectionChanged(bool);

private:
  void addSelection( LogGraphCanvasItem* item );
  void clearSelection();

private:
  QPopupMenu*   _popup;
  ActionStorage _actions;
  bool          _shiftDown;
  QString       _root;

  LogGraphCanvasItem* _sel1;
  LogGraphCanvasItem* _sel2;
};

#endif // _SC_LOGGRAPHCANVASVIEW_H
