/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "LogEntryLvi.h"
#include "svn/LogEntry.h"



LogEntryLvi::LogEntryLvi( QListView* parent, const svn::LogEntryPtr entry )
: super(parent), _entry(entry)
{
}

LogEntryLvi::~LogEntryLvi()
{
}

QString LogEntryLvi::text( int column ) const
{
  switch( column )
  {
  case 0:
    {
      return QString().sprintf( "%10ld", (unsigned long)_entry->getRevnumber() );
    }
  case 1:
    {
      char time[APR_CTIME_LEN] = {};
      apr_ctime( time, _entry->getDate() );
      return time;
    }
  case 2:
    {
      return QString().sprintf( "%s ", (const char*)_entry->getAuthor() );
      //(const char*)_entry->getAuthor();
    }
  case 3:
    {
      // that is the empty column
      return "";
    }
  default:
    {
      return "invalid column";
    }
  }
}

QString LogEntryLvi::key( int column, bool ascending ) const
{
  return text( column );
}

int LogEntryLvi::compare( QListViewItem * i, int column, bool ascending ) const
{
  LogEntryLvi*           lvi = (LogEntryLvi*)i;
  const svn::LogEntryPtr e   = lvi->getLogEntry();

  switch( column )
  {
  case 0:
    {
      if( _entry->getRevnumber() < e->getRevnumber() )
      {
        return -1;
      }
      else if( _entry->getRevnumber() > e->getRevnumber() )
      {
        return 1;
      }
      else
      {
        return 0;
      }
    }
  case 1:
    {
      if( _entry->getDate() < e->getDate() )
      {
        return -1;
      }
      else if( _entry->getDate() > e->getDate() )
      {
        return 1;
      }
      else
      {
        return 0;
      }
    }
  }
  return super::compare(i,column,ascending);
}

const svn::LogEntryPtr LogEntryLvi::getLogEntry() const
{
  return _entry;
}
