/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BLAMELINELVI_H
#define _SC_BLAMELINELVI_H

// sc
namespace svn {
  class BlameLine;
}

// qt
#include <qlistview.h>


class BlameLineLvi : public QListViewItem
{
  typedef QListViewItem super;

public:
  BlameLineLvi( QListView* parent, const svn::BlameLine* line );
  virtual ~BlameLineLvi();

  QString text( int column ) const;
  QString key( int column, bool ascending ) const;
  int compare( QListViewItem * i, int col, bool ascending ) const;

private:
  const svn::BlameLine* _line;
};

#endif // _SC_BLAMELINELVI_H
