/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_24 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 4756, "epsg", 4756,
        "VN-2000");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=-192.873,-39.382,-11");
    add_proj4text (p, 1,
        "1.202,-0.00205,-0.0005,0.00335,0.0188 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"VN-2000\",DATUM[\"Vietnam_2000\",SPHEROID[\"WGS");
    add_srs_wkt (p, 1,
        " 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[-192.873,-39.382,-111.202,-0.00205,-0.0005,0.0");
    add_srs_wkt (p, 3,
        "0335,0.0188],AUTHORITY[\"EPSG\",\"6756\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4756\"]]");
    p = add_epsg_def (filter, first, last, 4757, "epsg", 4757,
        "SVY21");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SVY21\",DATUM[\"SVY21\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 1,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"6757\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4757\"");
    add_srs_wkt (p, 5,
        "]]");
    p = add_epsg_def (filter, first, last, 4758, "epsg", 4758,
        "JAD2001");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JAD2001\",DATUM[\"Jamaica_2001\",SPHEROID[\"WGS");
    add_srs_wkt (p, 1,
        " 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6758\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4758\"]]");
    p = add_epsg_def (filter, first, last, 4759, "epsg", 4759,
        "NAD83(NSRS2007)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 1,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4759\"]]");
    p = add_epsg_def (filter, first, last, 4760, "epsg", 4760,
        "WGS 66");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 66\",DATUM[\"World_Geodetic_System_1966\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"NWL 9D\",6378145,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "025\"]],AUTHORITY[\"EPSG\",\"6760\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"4760\"]]");
    p = add_epsg_def (filter, first, last, 4761, "epsg", 4761,
        "HTRS96");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"HTRS96\",DATUM[\"Croatian_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_System\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6761\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4761");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def (filter, first, last, 4762, "epsg", 4762,
        "BDA2000");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"BDA2000\",DATUM[\"Bermuda_2000\",SPHEROID[\"WGS");
    add_srs_wkt (p, 1,
        " 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6762\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4762\"]]");
    p = add_epsg_def (filter, first, last, 4763, "epsg", 4763,
        "Pitcairn 2006");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pitcairn 2006\",DATUM[\"Pitcairn_2006\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"676");
    add_srs_wkt (p, 3,
        "3\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4763\"]]");
    p = add_epsg_def (filter, first, last, 4764, "epsg", 4764,
        "RSRGD2000");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RSRGD2000\",DATUM[\"Ross_Sea_Region_Geodetic_Da");
    add_srs_wkt (p, 1,
        "tum_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6764\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"476");
    add_srs_wkt (p, 6,
        "4\"]]");
    p = add_epsg_def (filter, first, last, 4765, "epsg", 4765,
        "Slovenia 1996");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Slovenia 1996\",DATUM[\"Slovenia_Geodetic_Datum");
    add_srs_wkt (p, 1,
        "_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6765\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4765\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4766, "epsg", 4766,
        "New Beijing / 3-degree Gauss-Kruger zone 30");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 30\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",90],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",30500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4766\"]]");
    p = add_epsg_def (filter, first, last, 4767, "epsg", 4767,
        "New Beijing / 3-degree Gauss-Kruger zone 31");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 31\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",93],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",31500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4767\"]]");
    p = add_epsg_def (filter, first, last, 4768, "epsg", 4768,
        "New Beijing / 3-degree Gauss-Kruger zone 32");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 32\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",96],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",32500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4768\"]]");
    p = add_epsg_def (filter, first, last, 4769, "epsg", 4769,
        "New Beijing / 3-degree Gauss-Kruger zone 33");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 33\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",99],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",33500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4769\"]]");
    p = add_epsg_def (filter, first, last, 4770, "epsg", 4770,
        "New Beijing / 3-degree Gauss-Kruger zone 34");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 34\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",102],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",34500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4770\"]]");
    p = add_epsg_def (filter, first, last, 4771, "epsg", 4771,
        "New Beijing / 3-degree Gauss-Kruger zone 35");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 35\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",105],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",35500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4771\"]]");
    p = add_epsg_def (filter, first, last, 4772, "epsg", 4772,
        "New Beijing / 3-degree Gauss-Kruger zone 36");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 36\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",108],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",36500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4772\"]]");
    p = add_epsg_def (filter, first, last, 4773, "epsg", 4773,
        "New Beijing / 3-degree Gauss-Kruger zone 37");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 37\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",111],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",37500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4773\"]]");
    p = add_epsg_def (filter, first, last, 4774, "epsg", 4774,
        "New Beijing / 3-degree Gauss-Kruger zone 38");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 38\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",114],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",38500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4774\"]]");
    p = add_epsg_def (filter, first, last, 4775, "epsg", 4775,
        "New Beijing / 3-degree Gauss-Kruger zone 39");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 39\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",117],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",39500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4775\"]]");
    p = add_epsg_def (filter, first, last, 4776, "epsg", 4776,
        "New Beijing / 3-degree Gauss-Kruger zone 40");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 40\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",120],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",40500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4776\"]]");
    p = add_epsg_def (filter, first, last, 4777, "epsg", 4777,
        "New Beijing / 3-degree Gauss-Kruger zone 41");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 41\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",123],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",41500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4777\"]]");
    p = add_epsg_def (filter, first, last, 4778, "epsg", 4778,
        "New Beijing / 3-degree Gauss-Kruger zone 42");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 42\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",126],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",42500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4778\"]]");
    p = add_epsg_def (filter, first, last, 4779, "epsg", 4779,
        "New Beijing / 3-degree Gauss-Kruger zone 43");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 43\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",129],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",43500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4779\"]]");
    p = add_epsg_def (filter, first, last, 4780, "epsg", 4780,
        "New Beijing / 3-degree Gauss-Kruger zone 44");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 44\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",132],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",44500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4780\"]]");
    p = add_epsg_def (filter, first, last, 4781, "epsg", 4781,
        "New Beijing / 3-degree Gauss-Kruger zone 45");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 45\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",135],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",45500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4781\"]]");
    p = add_epsg_def (filter, first, last, 4782, "epsg", 4782,
        "New Beijing / 3-degree Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 75E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",75],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4782\"]]");
    p = add_epsg_def (filter, first, last, 4783, "epsg", 4783,
        "New Beijing / 3-degree Gauss-Kruger CM 78E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 78E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",78],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4783\"]]");
    p = add_epsg_def (filter, first, last, 4784, "epsg", 4784,
        "New Beijing / 3-degree Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 81E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",81],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4784\"]]");
    p = add_epsg_def (filter, first, last, 4785, "epsg", 4785,
        "New Beijing / 3-degree Gauss-Kruger CM 84E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 84E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",84],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4785\"]]");
    p = add_epsg_def (filter, first, last, 4786, "epsg", 4786,
        "New Beijing / 3-degree Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 87E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",87],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4786\"]]");
    p = add_epsg_def (filter, first, last, 4787, "epsg", 4787,
        "New Beijing / 3-degree Gauss-Kruger CM 90E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 90E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",90],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4787\"]]");
    p = add_epsg_def (filter, first, last, 4788, "epsg", 4788,
        "New Beijing / 3-degree Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 93E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",93],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4788\"]]");
    p = add_epsg_def (filter, first, last, 4789, "epsg", 4789,
        "New Beijing / 3-degree Gauss-Kruger CM 96E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 96E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",96],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4789\"]]");
    p = add_epsg_def (filter, first, last, 4790, "epsg", 4790,
        "New Beijing / 3-degree Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 99E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",99],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4790\"]]");
    p = add_epsg_def (filter, first, last, 4791, "epsg", 4791,
        "New Beijing / 3-degree Gauss-Kruger CM 102E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 102E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",102],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4791\"]]");
    p = add_epsg_def (filter, first, last, 4792, "epsg", 4792,
        "New Beijing / 3-degree Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 105E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",105],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4792\"]]");
    p = add_epsg_def (filter, first, last, 4793, "epsg", 4793,
        "New Beijing / 3-degree Gauss-Kruger CM 108E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 108E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",108],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4793\"]]");
    p = add_epsg_def (filter, first, last, 4794, "epsg", 4794,
        "New Beijing / 3-degree Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 111E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",111],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4794\"]]");
    p = add_epsg_def (filter, first, last, 4795, "epsg", 4795,
        "New Beijing / 3-degree Gauss-Kruger CM 114E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 114E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",114],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4795\"]]");
    p = add_epsg_def (filter, first, last, 4796, "epsg", 4796,
        "New Beijing / 3-degree Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 117E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",117],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4796\"]]");
    p = add_epsg_def (filter, first, last, 4797, "epsg", 4797,
        "New Beijing / 3-degree Gauss-Kruger CM 120E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 120E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",120],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4797\"]]");
    p = add_epsg_def (filter, first, last, 4798, "epsg", 4798,
        "New Beijing / 3-degree Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 123E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",123],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4798\"]]");
    p = add_epsg_def (filter, first, last, 4799, "epsg", 4799,
        "New Beijing / 3-degree Gauss-Kruger CM 126E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 126E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",126],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4799\"]]");
    p = add_epsg_def (filter, first, last, 4800, "epsg", 4800,
        "New Beijing / 3-degree Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 129E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",129],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4800\"]]");
    p = add_epsg_def (filter, first, last, 4801, "epsg", 4801,
        "Bern 1898 (Bern)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=674.4,15.1,405.3,0,");
    add_proj4text (p, 1,
        "0,0,0 +pm=bern +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bern 1898 (Bern)\",DATUM[\"CH1903_Bern\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7004\"]],TOWGS84[674.4,15.1,405.3,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6801\"]],PRIMEM[\"Bern\",7.4395833333333");
    add_srs_wkt (p, 4,
        "33,AUTHORITY[\"EPSG\",\"8907\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4801\"]]");
    p = add_epsg_def (filter, first, last, 4802, "epsg", 4802,
        "Bogota 1975 (Bogota)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 ");
    add_proj4text (p, 1,
        "+pm=bogota +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bogota 1975 (Bogota)\",DATUM[\"Bogota_1975_Bogo");
    add_srs_wkt (p, 1,
        "ta\",SPHEROID[\"International 1924\",6378388,297,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7022\"]],TOWGS84[307,304,-318,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6802\"]],PRIMEM[\"Bogota\",-74.0809166");
    add_srs_wkt (p, 4,
        "6666667,AUTHORITY[\"EPSG\",\"8904\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4802\"]]");
    p = add_epsg_def (filter, first, last, 4803, "epsg", 4803,
        "Lisbon (Lisbon)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-304.046,-60.576,103.");
    add_proj4text (p, 1,
        "64,0,0,0,0 +pm=lisbon +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lisbon (Lisbon)\",DATUM[\"Lisbon_1937_Lisbon\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-304.046,-60.576,103.64,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6803\"]],PRIMEM[\"Lisbon\",-9.13");
    add_srs_wkt (p, 4,
        "1906111111112,AUTHORITY[\"EPSG\",\"8902\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4803\"]]");
    p = add_epsg_def (filter, first, last, 4804, "epsg", 4804,
        "Makassar (Jakarta)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.7");
    add_proj4text (p, 1,
        "6,0,0,0,0 +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Makassar (Jakarta)\",DATUM[\"Makassar_Jakarta\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7004\"]],TOWGS84[-587.8,519.75,145.76,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6804\"]],PRIMEM[\"Jakarta\",1");
    add_srs_wkt (p, 4,
        "06.8077194444444,AUTHORITY[\"EPSG\",\"8908\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4804\"]]");
    p = add_epsg_def (filter, first, last, 4805, "epsg", 4805,
        "MGI (Ferro)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=682,-203,480,0,0,0,");
    add_proj4text (p, 1,
        "0 +pm=ferro +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MGI (Ferro)\",DATUM[\"Militar_Geographische_Ins");
    add_srs_wkt (p, 1,
        "titut_Ferro\",SPHEROID[\"Bessel 1841\",6377397.155,299.1");
    add_srs_wkt (p, 2,
        "528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-203,48");
    add_srs_wkt (p, 3,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6805\"]],PRIMEM[\"Ferro\"");
    add_srs_wkt (p, 4,
        ",-17.66666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4805\"]]");
    p = add_epsg_def (filter, first, last, 4806, "epsg", 4806,
        "Monte Mario (Rome)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.9");
    add_proj4text (p, 1,
        "71,-2.917,0.714,-11.68 +pm=rome +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Monte Mario (Rome)\",DATUM[\"Monte_Mario_Rome\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-104.1,-49.1,-9.9,0.971,-2.917");
    add_srs_wkt (p, 3,
        ",0.714,-11.68],AUTHORITY[\"EPSG\",\"6806\"]],PRIMEM[\"Ro");
    add_srs_wkt (p, 4,
        "me\",12.45233333333333,AUTHORITY[\"EPSG\",\"8906\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4806\"]]");
    p = add_epsg_def (filter, first, last, 4807, "epsg", 4807,
        "NTF (Paris)");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,");
    add_proj4text (p, 1,
        "320,0,0,0,0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Fr");
    add_srs_wkt (p, 1,
        "ancaise_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2");
    add_srs_wkt (p, 2,
        ",293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-168,-60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"grad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "05\"]],AUTHORITY[\"EPSG\",\"4807\"]]");
    p = add_epsg_def (filter, first, last, 4808, "epsg", 4808,
        "Padang (Jakarta)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Padang (Jakarta)\",DATUM[\"Padang_1884_Jakarta\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6808\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Jakarta\",106.8077194444444,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8908\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4808\"]]");
    p = add_epsg_def (filter, first, last, 4809, "epsg", 4809,
        "Belge 1950 (Brussels)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +pm=brussels +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Belge 1950 (Brussels)\",DATUM[\"Reseau_National");
    add_srs_wkt (p, 1,
        "_Belge_1950_Brussels\",SPHEROID[\"International 1924\",6");
    add_srs_wkt (p, 2,
        "378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6809\"]],PRIMEM[\"Brussels\",4.367975,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8910\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4809\"]]");
    p = add_epsg_def (filter, first, last, 4810, "epsg", 4810,
        "Tananarive (Paris)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0");
    add_proj4text (p, 1,
        " +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tananarive (Paris)\",DATUM[\"Tananarive_1925_Pa");
    add_srs_wkt (p, 1,
        "ris\",SPHEROID[\"International 1924\",6378388,297,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7022\"]],TOWGS84[-189,-242,-91,0,0,0,0],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6810\"]],PRIMEM[\"Paris\",2.33722917");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.015707963");
    add_srs_wkt (p, 5,
        "26794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4810\"]]");
    p = add_epsg_def (filter, first, last, 4811, "epsg", 4811,
        "Voirol 1875 (Paris)");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,");
    add_proj4text (p, 1,
        "227,0,0,0,0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1875 (Paris)\",DATUM[\"Voirol_1875_Paris");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129");
    add_srs_wkt (p, 2,
        "36269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-73,-247,227");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6811\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 4,
        ",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",");
    add_srs_wkt (p, 5,
        "0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4811\"]]");
    p = add_epsg_def (filter, first, last, 4812, "epsg", 4812,
        "New Beijing / 3-degree Gauss-Kruger CM 132E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 132E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",132],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4812\"]]");
    p = add_epsg_def (filter, first, last, 4813, "epsg", 4813,
        "Batavia (Jakarta)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-377,681,-50,0,0,0,");
    add_proj4text (p, 1,
        "0 +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Batavia (Jakarta)\",DATUM[\"Batavia_Jakarta\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7004\"]],TOWGS84[-377,681,-50,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6813\"]],PRIMEM[\"Jakarta\",106.8077194");
    add_srs_wkt (p, 4,
        "444444,AUTHORITY[\"EPSG\",\"8908\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4813\"]]");
    p = add_epsg_def (filter, first, last, 4814, "epsg", 4814,
        "RT38 (Stockholm)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +pm=stockholm +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RT38 (Stockholm)\",DATUM[\"Stockholm_1938_Stock");
    add_srs_wkt (p, 1,
        "holm\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6814\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Stockholm\",18.05827777777778,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"8911\"]],UNIT[\"degree\",0.0174532925199433,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4814\"]]");
    p = add_epsg_def (filter, first, last, 4815, "epsg", 4815,
        "Greek (Athens)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +pm=athens +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Greek (Athens)\",DATUM[\"Greek_Athens\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6815\"]],PRIMEM[\"A");
    add_srs_wkt (p, 3,
        "thens\",23.7163375,AUTHORITY[\"EPSG\",\"8912\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"4815\"]]");
    p = add_epsg_def (filter, first, last, 4816, "epsg", 4816,
        "Carthage (Paris)");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-263,6,43");
    add_proj4text (p, 1,
        "1,0,0,0,0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Carthage (Paris)\",DATUM[\"Carthage_Paris\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936269,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-263,6,431,0,0,0,0");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6816\"]],PRIMEM[\"Paris\",2.33722");
    add_srs_wkt (p, 4,
        "917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.015707");
    add_srs_wkt (p, 5,
        "96326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4816\"]]");
    p = add_epsg_def (filter, first, last, 4817, "epsg", 4817,
        "NGO 1948 (Oslo)");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs");
    add_proj4text (p, 1,
        "84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NGO 1948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Bessel Modified\",6377492.018,299.1528128,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,");
    add_srs_wkt (p, 3,
        "-6.61,6.21],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\"");
    add_srs_wkt (p, 4,
        ",10.72291666666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4817\"]]");
    p = add_epsg_def (filter, first, last, 4818, "epsg", 4818,
        "S-JTSK (Ferro)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=589,76,480,0,0,0,0 ");
    add_proj4text (p, 1,
        "+pm=ferro +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"S-JTSK (Ferro)\",DATUM[\"System_Jednotne_Trigon");
    add_srs_wkt (p, 1,
        "ometricke_Site_Katastralni_Ferro\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 2,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[589,76,480,0,0,0,0],AUTHORITY[\"EPSG\",\"6818\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Ferro\",-17.66666666666667,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4818\"]]");
    p = add_epsg_def (filter, first, last, 4819, "epsg", 4819,
        "Nord Sahara 1959 (Paris)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-186,-93,310,0,0,0,");
    add_proj4text (p, 1,
        "0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nord Sahara 1959 (Paris)\",DATUM[\"Nord_Sahara_");
    add_srs_wkt (p, 1,
        "1959_Paris\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,");
    add_srs_wkt (p, 2,
        "293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-186,-93,3");
    add_srs_wkt (p, 3,
        "10,0,0,0,0],AUTHORITY[\"EPSG\",\"6819\"]],PRIMEM[\"Paris");
    add_srs_wkt (p, 4,
        "\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 5,
        ",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4819\"]]");
    p = add_epsg_def (filter, first, last, 4820, "epsg", 4820,
        "Segara (Jakarta)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 1,
        " +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Segara (Jakarta)\",DATUM[\"Gunung_Segara_Jakart");
    add_srs_wkt (p, 1,
        "a\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7004\"]],TOWGS84[-403,684,41,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6820\"]],PRIMEM[\"Jakarta\",106.807");
    add_srs_wkt (p, 4,
        "7194444444,AUTHORITY[\"EPSG\",\"8908\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4820\"]]");
    p = add_epsg_def (filter, first, last, 4821, "epsg", 4821,
        "Voirol 1879 (Paris)");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1879 (Paris)\",DATUM[\"Voirol_1879_Paris");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129");
    add_srs_wkt (p, 2,
        "36269,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6821\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8903\"]],UNIT[\"grad\",0.01570796326794897,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4821\"]]");
    p = add_epsg_def (filter, first, last, 4822, "epsg", 4822,
        "New Beijing / 3-degree Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 135E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",135],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4822\"]]");
    p = add_epsg_def (filter, first, last, 4823, "epsg", 4823,
        "Sao Tome");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sao Tome\",DATUM[\"Sao_Tome\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"1044\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"4823\"]]");
    p = add_epsg_def (filter, first, last, 4824, "epsg", 4824,
        "Principe");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Principe\",DATUM[\"Principe\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"1046\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"4824\"]]");
    p = add_epsg_def (filter, first, last, 4826, "epsg", 4826,
        "WGS 84 / Cape Verde National");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=15 +lat_2=16.66666666666667 +lat_0=15.8");
    add_proj4text (p, 1,
        "3333333333333 +lon_0=-24 +x_0=161587.83 +y_0=128511.202 ");
    add_proj4text (p, 2,
        "+datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Cape Verde National\",GEOGCS[\"WGS 84\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 7,
        "rallel_1\",15],PARAMETER[\"standard_parallel_2\",16.6666");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"latitude_of_origin\",15.83333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"central_meridian\",-24],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",161587.83],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "128511.202],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"M\",EAST],AXIS[\"P\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4826\"]]");
    p = add_epsg_def (filter, first, last, 4839, "epsg", 4839,
        "ETRS89 / LCC Germany (N-E)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.66666666666666 +lat_2=53.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=51 +lon_0=10.5 +x_0=0 +y_0=0 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / LCC Germany (N-E)\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 8,
        "_parallel_1\",48.66666666666666],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_2\",53.66666666666666],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 10,
        "igin\",51],PARAMETER[\"central_meridian\",10.5],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",0],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"4839\"]]");
    p = add_epsg_def (filter, first, last, 4855, "epsg", 4855,
        "ETRS89 / NTM zone 5 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=5.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 5 (deprecated)\",GEOGCS[\"ETR");
    add_srs_wkt (p, 1,
        "S89\",DATUM[\"European_Terrestrial_Reference_System_1989");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",5.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4855\"]]");
    p = add_epsg_def (filter, first, last, 4856, "epsg", 4856,
        "ETRS89 / NTM zone 6 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 6 (deprecated)\",GEOGCS[\"ETR");
    add_srs_wkt (p, 1,
        "S89\",DATUM[\"European_Terrestrial_Reference_System_1989");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",6.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4856\"]]");
    p = add_epsg_def (filter, first, last, 4857, "epsg", 4857,
        "ETRS89 / NTM zone 7 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=7.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 7 (deprecated)\",GEOGCS[\"ETR");
    add_srs_wkt (p, 1,
        "S89\",DATUM[\"European_Terrestrial_Reference_System_1989");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",7.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4857\"]]");
    p = add_epsg_def (filter, first, last, 4858, "epsg", 4858,
        "ETRS89 / NTM zone 8 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=8.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 8 (deprecated)\",GEOGCS[\"ETR");
    add_srs_wkt (p, 1,
        "S89\",DATUM[\"European_Terrestrial_Reference_System_1989");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",8.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4858\"]]");
    p = add_epsg_def (filter, first, last, 4859, "epsg", 4859,
        "ETRS89 / NTM zone 9 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 9 (deprecated)\",GEOGCS[\"ETR");
    add_srs_wkt (p, 1,
        "S89\",DATUM[\"European_Terrestrial_Reference_System_1989");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",9.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4859\"]]");
    p = add_epsg_def (filter, first, last, 4860, "epsg", 4860,
        "ETRS89 / NTM zone 10 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 10 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",10.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4860\"]]");
    p = add_epsg_def (filter, first, last, 4861, "epsg", 4861,
        "ETRS89 / NTM zone 11 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 11 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",11.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4861\"]]");
    p = add_epsg_def (filter, first, last, 4862, "epsg", 4862,
        "ETRS89 / NTM zone 12 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 12 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",12.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4862\"]]");
    p = add_epsg_def (filter, first, last, 4863, "epsg", 4863,
        "ETRS89 / NTM zone 13 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 13 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",13.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4863\"]]");
    p = add_epsg_def (filter, first, last, 4864, "epsg", 4864,
        "ETRS89 / NTM zone 14 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=14.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 14 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",14.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4864\"]]");
    p = add_epsg_def (filter, first, last, 4865, "epsg", 4865,
        "ETRS89 / NTM zone 15 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 15 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",15.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4865\"]]");
    p = add_epsg_def (filter, first, last, 4866, "epsg", 4866,
        "ETRS89 / NTM zone 16 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 16 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",16.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4866\"]]");
    p = add_epsg_def (filter, first, last, 4867, "epsg", 4867,
        "ETRS89 / NTM zone 17 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 17 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",17.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4867\"]]");
    p = add_epsg_def (filter, first, last, 4868, "epsg", 4868,
        "ETRS89 / NTM zone 18 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 18 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",18.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4868\"]]");
    p = add_epsg_def (filter, first, last, 4869, "epsg", 4869,
        "ETRS89 / NTM zone 19 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 19 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",19.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4869\"]]");
    p = add_epsg_def (filter, first, last, 4870, "epsg", 4870,
        "ETRS89 / NTM zone 20 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 20 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",20.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4870\"]]");
    p = add_epsg_def (filter, first, last, 4871, "epsg", 4871,
        "ETRS89 / NTM zone 21 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 21 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",21.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4871\"]]");
    p = add_epsg_def (filter, first, last, 4872, "epsg", 4872,
        "ETRS89 / NTM zone 22 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=22.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 22 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",22.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4872\"]]");
    p = add_epsg_def (filter, first, last, 4873, "epsg", 4873,
        "ETRS89 / NTM zone 23 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 23 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",23.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4873\"]]");
    p = add_epsg_def (filter, first, last, 4874, "epsg", 4874,
        "ETRS89 / NTM zone 24 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 24 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",24.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4874\"]]");
    p = add_epsg_def (filter, first, last, 4875, "epsg", 4875,
        "ETRS89 / NTM zone 25 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 25 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",25.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4875\"]]");
    p = add_epsg_def (filter, first, last, 4876, "epsg", 4876,
        "ETRS89 / NTM zone 26 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=26.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 26 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",26.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4876\"]]");
    p = add_epsg_def (filter, first, last, 4877, "epsg", 4877,
        "ETRS89 / NTM zone 27 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 27 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",27.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4877\"]]");
    p = add_epsg_def (filter, first, last, 4878, "epsg", 4878,
        "ETRS89 / NTM zone 28 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 28 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",28.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4878\"]]");
    p = add_epsg_def (filter, first, last, 4879, "epsg", 4879,
        "ETRS89 / NTM zone 29 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 29 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",29.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4879\"]]");
    p = add_epsg_def (filter, first, last, 4880, "epsg", 4880,
        "ETRS89 / NTM zone 30 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 30 (deprecated)\",GEOGCS[\"ET");
    add_srs_wkt (p, 1,
        "RS89\",DATUM[\"European_Terrestrial_Reference_System_198");
    add_srs_wkt (p, 2,
        "9\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",30.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4880\"]]");
    p = add_epsg_def (filter, first, last, 4901, "epsg", 4901,
        "ATF (Paris)");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376523 +b=6355862.933255573 +pm=2.3372");
    add_proj4text (p, 1,
        "08333333333 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ATF (Paris)\",DATUM[\"Ancienne_Triangulation_Fr");
    add_srs_wkt (p, 1,
        "ancaise_Paris\",SPHEROID[\"Plessis 1817\",6376523,308.64");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Paris RGS\",2.337208333333333,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8914\"]],UNIT[\"grad\",0.01570796326794897,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4901\"]]");
    p = add_epsg_def (filter, first, last, 4902, "epsg", 4902,
        "NDG (Paris)");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376523 +b=6355862.933255573 +pm=paris ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NDG (Paris)\",DATUM[\"Nord_de_Guerre_Paris\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Plessis 1817\",6376523,308.64,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7027\"]],AUTHORITY[\"EPSG\",\"6902\"]],PRIMEM[\"Paris");
    add_srs_wkt (p, 3,
        "\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 4,
        ",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"4902\"]]");
    p = add_epsg_def (filter, first, last, 4903, "epsg", 4903,
        "Madrid 1870 (Madrid)");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378298.3 +b=6356657.142669562 +pm=madr");
    add_proj4text (p, 1,
        "id +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Madrid 1870 (Madrid)\",DATUM[\"Madrid_1870_Madr");
    add_srs_wkt (p, 1,
        "id\",SPHEROID[\"Struve 1860\",6378298.3,294.73,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7028\"]],AUTHORITY[\"EPSG\",\"6903\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Madrid\",-3.687938888888889,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "5\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4903\"]]");
    p = add_epsg_def (filter, first, last, 4904, "epsg", 4904,
        "Lisbon 1890 (Lisbon)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=508.088,-191.042,56");
    add_proj4text (p, 1,
        "5.223,0,0,0,0 +pm=lisbon +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lisbon 1890 (Lisbon)\",DATUM[\"Lisbon_1890_Lisb");
    add_srs_wkt (p, 1,
        "on\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7004\"]],TOWGS84[508.088,-191.042,565");
    add_srs_wkt (p, 3,
        ".223,0,0,0,0],AUTHORITY[\"EPSG\",\"6904\"]],PRIMEM[\"Lis");
    add_srs_wkt (p, 4,
        "bon\",-9.131906111111112,AUTHORITY[\"EPSG\",\"8902\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4904\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

