
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef PSEWIDGET_H
#define PSEWIDGET_H

#include <QWidget>
#include <QSignalMapper>
#include <QDebug>
#include <QToolButton>
#include "molecule.h"
class PSEWidget : public QWidget
{
    Q_OBJECT
public:
    explicit PSEWidget(QWidget *parent = 0);
    int selection;
    QSignalMapper* esm;
signals:
void pseSelected(int index);
public slots:
void selectPSE(int index){selection=index; emit pseSelected(index);}
void incFontSize();
void decFontSize();
void colorchange(QColor bgcolor);
private:
int sz; 
Molecule mole;
QToolButton *elebutt[109];
QToolButton *lplus,*lminus;
};

#endif // PSEWIDGET_H
