
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef EACDLG_H
#define EACDLG_H
#include <QtGui>
#include "molecule.h"
#include "psewidget.h"
class EacGLW: public QGLWidget {
Q_OBJECT
  public:
  Molecule *mol;
  CEnvironment xd;
  Connection bonds;
  int proba;
  EacGLW( Molecule *externMole,QWidget * parent = 0);
  //EacGLW(const MyAtom *atom,Molecule *externMole);
  QFont myFont;
  //QStringList pse;
  QTimer *timer;
  signals:
      void colorchanged(QColor bgcolor);
 protected:
  void initializeGL();
  void resizeGL(int width, int height);
  void paintGL();
 public slots:
  void changeAtom(int OZ);
  void colorDLG();
  void wallA(int st);
  void ringA(int st);
  void spheA(int st);
  void soldA(int st);
  void nolaA(int st);
  void whitA(int st);
  void metalA(int st);
 private:
  GLint vp[4];
  void draw();
};
class multiStyle: public QDialog {
Q_OBJECT
  public:
  multiStyle(Molecule *externMole); 
  QCheckBox *walbx;
  QCheckBox *rinbx;
  QCheckBox *sphbx;
  QCheckBox *sldbx;
  QCheckBox *nlabx;
  QCheckBox *metalic;
  QComboBox *start;
  QComboBox *end;
  public slots:
  void checkWall();
  void checkSolid();
  void checkBall();
 private:
  Molecule *mol;
};
class EacDlg: public QDialog {
Q_OBJECT
  public:
  EacDlg(Molecule *externMole);
  //EacDlg(MyAtom *onlyThisAtom,Molecule *externMole);
  EacGLW *eacGLW;
  public slots:
  void colorDLG2();
  void colorchange(QColor bgcolor);
  void  updateLEs(int OZ);
  void checkWall();
  void checkSolid();
  void checkBall();
  void doMulti();
  void unicolor(bool b);
  void woADP(bool b);
  void probaChanged(int ix);
  void strengthChanged(double d);
  void lodChanged(int d);
  void kradChanged(double d);  
  void radChanged(double d);
  void exportSettings();
  void importSettings();
  protected slots:
  void accept () ;
  void reject () ;
 private:
  Molecule *mol;
  //MyAtom *otm;
  QDoubleSpinBox *bondStrength;
  QSpinBox *lodSpinBox;
  QComboBox *eacProba;
  PSEWidget *psew;
  QPushButton *colorbut, *colorbut2,*impbut,*expbut;
  QGridLayout *eacGLO;
  //QComboBox *eacCB;
  QDoubleSpinBox *eacRAD;
  QDoubleSpinBox *eacKRAD;
  QCheckBox *walbx;
  QCheckBox *rinbx;
  QCheckBox *sphbx;
  QCheckBox *sldbx;
  QCheckBox *nlabx;
  QCheckBox *metalic;

  QCheckBox *noadp;
};
#endif
