/* Score Reading Trainer
   Copyright (C) 2004,2005,2006,2007 by José Pablo Ezequiel Fernández Silva <pupeno@pupeno.com>

   This file is part of Score Reading Trainer.

   Score Reading Trainer is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

   Score Reading Trainer is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.*/


#ifndef _SCOREREADINGTRAINERVIEW_H_
#define _SCOREREADINGTRAINERVIEW_H_

#include <qwidget.h>

#include "Score.h"

template <class T> class QValueVector;
/**
 * This is the view of the ScoreReadingTrainer. This class is in charge of creating the Scores (out of the Score object), generate the random numbers, etc.
 *
 * @short Main view
 * @author Jos� Pablo Ezequiel "Pupeno" Fern�ndez <pupeno@pupeno.com>
 */
class ScoreReadingTrainerView : public QWidget{
	Q_OBJECT
	public:
		/**
		 * The diferent notes unified (A# = Bb) for the use in this class.
		 */
		enum Notes { C = 0, CSharp, D, DSharp, E, F, FSharp, G, GSharp, A, ASharp, B };

		/**
		 * Constructor, it creates the score.
		 *
		 * @param parent The widget that is the parent of this widget.
		 */
		ScoreReadingTrainerView(QWidget *parent);

		/**
		 * Destructor.
		 */
		virtual ~ScoreReadingTrainerView();

		/**
		 * Start the training. This fuctions start rolling the random notes.
		 */
		void start();

		/**
		 * Stop the training. Clean up the score and stop rolling the random notes.
		 */
		void stop();

		/**
		 * Set automatic mode.
		 *
		 * @param t If true, it is set to automatic mode, if false, it is set to manual mode.
		 */
		void setAutomatic(bool t = true);

		/**
		 * Gets the current clef
		 */
		Score::Clefs clef();

		/**
		 * Set clef
		 *
		 * @param pClef Clef to be used.
		 */
		void setClef(Score::Clefs pClef);

		/**
		 * Get the current key signature
		 */
		Score::KeySignatures keySignature();

		/**
		 * Set key signature
		 */
		void setKeySignature(Score::KeySignatures pKeySignature);

		/**
		 * Get the bottom limit
		 */
		int bottomLimit();

		/**
		 * Set the bottom limit
		 */
		void setBottomLimit(int pBottomLimit);

		/**
		 * Get the top limit
		 */
		int topLimit();

		/**
		 * Set the top limit
		 */
		void setTopLimit(int pTopLimit);

		/**
		 * Set the use accidentals
		 */
		void setAccidentals(bool pAccidentals);

	public slots:
		/**
		 * Generate a random note according to the limits.
		 * If remove is true, it'll remove a note before adding one.
		 */
		void generateRandomNote(bool remove = false);

	private:
		/**
		 * Update the list of available notes.
		 */
		void updateAvailableNotes();

		/**
		 * If true, the list of available notes need updating
		 */
		bool availableNotesNeedUpdating;

		/**
		 * Are we in automatic mode
		 */
		bool mAutomatic;

		/**
		 * Wiget that shows the score
		 */
		Score *score;

		/**
		 * list of available notes
		 */
		QValueVector<int> *availableNotes;

		/**
		 * Bottom limit
		 */
		int mBottomLimit;

		/**
		 * Top limit
		 */
		int mTopLimit;

		/**
		 * If true, don't use accidentals
		 */
		bool mAccidentals;
		
		/**
		 * Keep track of the current state, started or not.
		 */
		bool started;

	private slots:
		/**
		 * This functions checks if the note that was pressed is the current note in Score and if it so, deletes it and generates a new one
		 */
		void checkNote(int note);
};



#endif // _SCOREREADINGTRAINERVIEW_H_
