/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.3:
 *   smidump -f scli ENTITY-MIB
 *
 * Derived from ENTITY-MIB:
 *   The MIB module for representing multiple logical
 *   entities supported by a single SNMP agent.
 *   
 *   Copyright (C) The Internet Society (2005).  This
 *   version of this MIB module is part of RFC 4133; see
 *   the RFC itself for full legal notices.
 *
 * Revision 2005-08-10 00:00:
 *   Initial Version of Entity MIB (Version 3).
 *   This revision obsoletes RFC 2737.
 *   Additions:
 *     - cpu(12) enumeration added to PhysicalClass TC
 *     - DISPLAY-HINT clause to PhysicalIndex TC
 *     - PhysicalIndexOrZero TC
 *     - entPhysicalMfgDate object
 *     - entPhysicalUris object
 *   Changes:
 *     - entPhysicalContainedIn SYNTAX changed from
 *       INTEGER to PhysicalIndexOrZero
 *   
 *   This version published as RFC 4133.
 *
 * Revision 1999-12-07 00:00:
 *   Initial Version of Entity MIB (Version 2).
 *   This revision obsoletes RFC 2037.
 *   This version published as RFC 2737.
 *
 * Revision 1996-10-31 00:00:
 *   Initial version (version 1), published as
 *   RFC 2037.
 *
 * $Id: entity-mib.c 1788 2006-02-21 20:47:18Z schoenw $
 */

#include "entity-mib.h"

GNetSnmpEnum const entity_mib_enums_PhysicalClass[] = {
    { ENTITY_MIB_PHYSICALCLASS_OTHER,       "other" },
    { ENTITY_MIB_PHYSICALCLASS_UNKNOWN,     "unknown" },
    { ENTITY_MIB_PHYSICALCLASS_CHASSIS,     "chassis" },
    { ENTITY_MIB_PHYSICALCLASS_BACKPLANE,   "backplane" },
    { ENTITY_MIB_PHYSICALCLASS_CONTAINER,   "container" },
    { ENTITY_MIB_PHYSICALCLASS_POWERSUPPLY, "powerSupply" },
    { ENTITY_MIB_PHYSICALCLASS_FAN,         "fan" },
    { ENTITY_MIB_PHYSICALCLASS_SENSOR,      "sensor" },
    { ENTITY_MIB_PHYSICALCLASS_MODULE,      "module" },
    { ENTITY_MIB_PHYSICALCLASS_PORT,        "port" },
    { ENTITY_MIB_PHYSICALCLASS_STACK,       "stack" },
    { ENTITY_MIB_PHYSICALCLASS_CPU,         "cpu" },
    { 0, NULL }
};


static guint32 const entConfigChange[]
	= { ENTITY_MIB_ENTCONFIGCHANGE };

GNetSnmpIdentity const entity_mib_notifications[] = {
    { entConfigChange,
      G_N_ELEMENTS(entConfigChange),
      "entConfigChange" },
    { 0, 0, NULL }
};


static guint16 entPhysicalDescr_constraints[] = {0U, 255U, 0, 0};
static gint32 entPhysicalContainedIn_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 entPhysicalParentRelPos_constraints[] = {-1L, 2147483647L, 0, 0};
static guint16 entPhysicalName_constraints[] = {0U, 255U, 0, 0};
static guint16 entPhysicalHardwareRev_constraints[] = {0U, 255U, 0, 0};
static guint16 entPhysicalFirmwareRev_constraints[] = {0U, 255U, 0, 0};
static guint16 entPhysicalSoftwareRev_constraints[] = {0U, 255U, 0, 0};
static guint16 entPhysicalSerialNum_constraints[] = {0U, 32U, 0, 0};
static guint16 entPhysicalMfgName_constraints[] = {0U, 255U, 0, 0};
static guint16 entPhysicalModelName_constraints[] = {0U, 255U, 0, 0};
static guint16 entPhysicalAlias_constraints[] = {0U, 32U, 0, 0};
static guint16 entPhysicalAssetID_constraints[] = {0U, 32U, 0, 0};
static guint16 entPhysicalMfgDate_constraints[] = {8U, 8U, 11, 11, 0, 0};
static guint16 entLogicalDescr_constraints[] = {0U, 255U, 0, 0};
static guint16 entLogicalCommunity_constraints[] = {0U, 255U, 0, 0};
static guint16 entLogicalTAddress_constraints[] = {1U, 255U, 0, 0};
static guint16 entLogicalContextEngineID_constraints[] = {0U, 32U, 0, 0};
static guint16 entLogicalContextName_constraints[] = {0U, 255U, 0, 0};
static gint32 entLPPhysicalIndex_constraints[] = {1L, 2147483647L, 0, 0};
static gint32 entPhysicalChildIndex_constraints[] = {1L, 2147483647L, 0, 0};


static guint32 const entPhysicalEntry_oid[] = {1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1};

static GNetSnmpAttribute entPhysicalEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALDESCR, "entPhysicalDescr",
       entPhysicalDescr_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalDescr),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalDescrLength),
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      ENTITY_MIB_ENTPHYSICALVENDORTYPE, "entPhysicalVendorType",
       NULL,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalVendorType),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalVendorTypeLength),
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ENTITY_MIB_ENTPHYSICALCONTAINEDIN, "entPhysicalContainedIn",
       entPhysicalContainedIn_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalContainedIn),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ENTITY_MIB_ENTPHYSICALCLASS, "entPhysicalClass",
       NULL,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalClass),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ENTITY_MIB_ENTPHYSICALPARENTRELPOS, "entPhysicalParentRelPos",
       entPhysicalParentRelPos_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalParentRelPos),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALNAME, "entPhysicalName",
       entPhysicalName_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalName),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalNameLength),
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALHARDWAREREV, "entPhysicalHardwareRev",
       entPhysicalHardwareRev_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalHardwareRev),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalHardwareRevLength),
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALFIRMWAREREV, "entPhysicalFirmwareRev",
       entPhysicalFirmwareRev_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalFirmwareRev),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalFirmwareRevLength),
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALSOFTWAREREV, "entPhysicalSoftwareRev",
       entPhysicalSoftwareRev_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalSoftwareRev),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalSoftwareRevLength),
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALSERIALNUM, "entPhysicalSerialNum",
       entPhysicalSerialNum_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalSerialNum),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalSerialNumLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALMFGNAME, "entPhysicalMfgName",
       entPhysicalMfgName_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalMfgName),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalMfgNameLength),
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALMODELNAME, "entPhysicalModelName",
       entPhysicalModelName_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalModelName),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalModelNameLength),
      0 },
    { 14, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALALIAS, "entPhysicalAlias",
       entPhysicalAlias_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalAlias),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalAliasLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 15, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALASSETID, "entPhysicalAssetID",
       entPhysicalAssetID_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalAssetID),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalAssetIDLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 16, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ENTITY_MIB_ENTPHYSICALISFRU, "entPhysicalIsFRU",
       NULL,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalIsFRU),
      0,
      0 },
    { 17, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALMFGDATE, "entPhysicalMfgDate",
       entPhysicalMfgDate_constraints,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalMfgDate),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalMfgDateLength),
      0 },
    { 18, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTPHYSICALURIS, "entPhysicalUris",
       NULL,
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, entPhysicalUris),
      G_STRUCT_OFFSET(entity_mib_entPhysicalEntry_t, _entPhysicalUrisLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const entLogicalEntry_oid[] = {1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1};

static GNetSnmpAttribute entLogicalEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTLOGICALDESCR, "entLogicalDescr",
       entLogicalDescr_constraints,
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, entLogicalDescr),
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, _entLogicalDescrLength),
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      ENTITY_MIB_ENTLOGICALTYPE, "entLogicalType",
       NULL,
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, entLogicalType),
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, _entLogicalTypeLength),
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTLOGICALCOMMUNITY, "entLogicalCommunity",
       entLogicalCommunity_constraints,
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, entLogicalCommunity),
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, _entLogicalCommunityLength),
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTLOGICALTADDRESS, "entLogicalTAddress",
       entLogicalTAddress_constraints,
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, entLogicalTAddress),
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, _entLogicalTAddressLength),
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      ENTITY_MIB_ENTLOGICALTDOMAIN, "entLogicalTDomain",
       NULL,
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, entLogicalTDomain),
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, _entLogicalTDomainLength),
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTLOGICALCONTEXTENGINEID, "entLogicalContextEngineID",
       entLogicalContextEngineID_constraints,
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, entLogicalContextEngineID),
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, _entLogicalContextEngineIDLength),
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ENTITY_MIB_ENTLOGICALCONTEXTNAME, "entLogicalContextName",
       entLogicalContextName_constraints,
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, entLogicalContextName),
      G_STRUCT_OFFSET(entity_mib_entLogicalEntry_t, _entLogicalContextNameLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const entLPMappingEntry_oid[] = {1, 3, 6, 1, 2, 1, 47, 1, 3, 1, 1};

static GNetSnmpAttribute entLPMappingEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ENTITY_MIB_ENTLPPHYSICALINDEX, "entLPPhysicalIndex",
       entLPPhysicalIndex_constraints,
      -1,
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const entAliasMappingEntry_oid[] = {1, 3, 6, 1, 2, 1, 47, 1, 3, 2, 1};

static GNetSnmpAttribute entAliasMappingEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      ENTITY_MIB_ENTALIASMAPPINGIDENTIFIER, "entAliasMappingIdentifier",
       NULL,
      G_STRUCT_OFFSET(entity_mib_entAliasMappingEntry_t, entAliasMappingIdentifier),
      G_STRUCT_OFFSET(entity_mib_entAliasMappingEntry_t, _entAliasMappingIdentifierLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const entPhysicalContainsEntry_oid[] = {1, 3, 6, 1, 2, 1, 47, 1, 3, 3, 1};

static GNetSnmpAttribute entPhysicalContainsEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ENTITY_MIB_ENTPHYSICALCHILDINDEX, "entPhysicalChildIndex",
       entPhysicalChildIndex_constraints,
      -1,
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const entityGeneral_oid[] = {1, 3, 6, 1, 2, 1, 47, 1, 4};

static GNetSnmpAttribute entityGeneral_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_TIMETICKS,
      ENTITY_MIB_ENTLASTCHANGETIME, "entLastChangeTime",
       NULL,
      G_STRUCT_OFFSET(entity_mib_entityGeneral_t, entLastChangeTime),
      0,
      0 },
    { 0, 0, 0, NULL }
};


entity_mib_entPhysicalEntry_t *
entity_mib_new_entPhysicalEntry()
{
    entity_mib_entPhysicalEntry_t *entPhysicalEntry;

    entPhysicalEntry = (entity_mib_entPhysicalEntry_t *) g_malloc0(sizeof(entity_mib_entPhysicalEntry_t) + sizeof(gpointer));
    return entPhysicalEntry;
}

static inline int
unpack_entPhysicalEntry(GNetSnmpVarBind *vb, entity_mib_entPhysicalEntry_t *entPhysicalEntry)
{
    guint8 idx = 12;

    if (vb->oid_len < idx) return -1;
    entPhysicalEntry->entPhysicalIndex = vb->oid[idx++];
    if ((entPhysicalEntry->entPhysicalIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_entPhysicalEntry(guint32 *base, gint32 entPhysicalIndex)
{
    guint8 idx = 12;

    base[idx++] = entPhysicalIndex;
    return idx;
}

static inline entity_mib_entPhysicalEntry_t *
assign_entPhysicalEntry(GList *vbl)
{
    entity_mib_entPhysicalEntry_t *entPhysicalEntry;
    char *p;

    entPhysicalEntry = entity_mib_new_entPhysicalEntry();
    p = (char *) entPhysicalEntry + sizeof(entity_mib_entPhysicalEntry_t);
    * (GList **) p = vbl;

    if (unpack_entPhysicalEntry((GNetSnmpVarBind *) vbl->data, entPhysicalEntry) < 0) {
        g_warning("%s: invalid instance identifier", "entPhysicalEntry");
        g_free(entPhysicalEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, entPhysicalEntry_oid, G_N_ELEMENTS(entPhysicalEntry_oid),
                      entPhysicalEntry_attr, entPhysicalEntry);

    return entPhysicalEntry;
}

void
entity_mib_get_entPhysicalTable(GNetSnmp *s, entity_mib_entPhysicalEntry_t ***entPhysicalEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 0};

    *entPhysicalEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 12, 11, entPhysicalEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *entPhysicalEntry = (entity_mib_entPhysicalEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(entity_mib_entPhysicalEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*entPhysicalEntry)[i] = assign_entPhysicalEntry(row->data);
        }
    }
}

void
entity_mib_get_entPhysicalEntry(GNetSnmp *s, entity_mib_entPhysicalEntry_t **entPhysicalEntry, gint32 entPhysicalIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, entPhysicalEntry_oid, sizeof(entPhysicalEntry_oid));
    len = pack_entPhysicalEntry(base, entPhysicalIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "entPhysicalEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *entPhysicalEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 11, entPhysicalEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *entPhysicalEntry = assign_entPhysicalEntry(out);
    }
}

void
entity_mib_set_entPhysicalEntry(GNetSnmp *s, entity_mib_entPhysicalEntry_t *entPhysicalEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, entPhysicalEntry_oid, sizeof(entPhysicalEntry_oid));
    len = pack_entPhysicalEntry(base, entPhysicalEntry->entPhysicalIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "entPhysicalEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 11, entPhysicalEntry_attr, mask, entPhysicalEntry);

    out = gnet_snmp_sync_set(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
entity_mib_free_entPhysicalEntry(entity_mib_entPhysicalEntry_t *entPhysicalEntry)
{
    GList *vbl;
    char *p;

    if (entPhysicalEntry) {
        p = (char *) entPhysicalEntry + sizeof(entity_mib_entPhysicalEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(entPhysicalEntry);
    }
}

void
entity_mib_free_entPhysicalTable(entity_mib_entPhysicalEntry_t **entPhysicalEntry)
{
    int i;

    if (entPhysicalEntry) {
        for (i = 0; entPhysicalEntry[i]; i++) {
            entity_mib_free_entPhysicalEntry(entPhysicalEntry[i]);
        }
        g_free(entPhysicalEntry);
    }
}

entity_mib_entLogicalEntry_t *
entity_mib_new_entLogicalEntry()
{
    entity_mib_entLogicalEntry_t *entLogicalEntry;

    entLogicalEntry = (entity_mib_entLogicalEntry_t *) g_malloc0(sizeof(entity_mib_entLogicalEntry_t) + sizeof(gpointer));
    return entLogicalEntry;
}

static inline int
unpack_entLogicalEntry(GNetSnmpVarBind *vb, entity_mib_entLogicalEntry_t *entLogicalEntry)
{
    guint8 idx = 12;

    if (vb->oid_len < idx) return -1;
    entLogicalEntry->entLogicalIndex = vb->oid[idx++];
    if ((entLogicalEntry->entLogicalIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_entLogicalEntry(guint32 *base, gint32 entLogicalIndex)
{
    guint8 idx = 12;

    base[idx++] = entLogicalIndex;
    return idx;
}

static inline entity_mib_entLogicalEntry_t *
assign_entLogicalEntry(GList *vbl)
{
    entity_mib_entLogicalEntry_t *entLogicalEntry;
    char *p;

    entLogicalEntry = entity_mib_new_entLogicalEntry();
    p = (char *) entLogicalEntry + sizeof(entity_mib_entLogicalEntry_t);
    * (GList **) p = vbl;

    if (unpack_entLogicalEntry((GNetSnmpVarBind *) vbl->data, entLogicalEntry) < 0) {
        g_warning("%s: invalid instance identifier", "entLogicalEntry");
        g_free(entLogicalEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, entLogicalEntry_oid, G_N_ELEMENTS(entLogicalEntry_oid),
                      entLogicalEntry_attr, entLogicalEntry);

    return entLogicalEntry;
}

void
entity_mib_get_entLogicalTable(GNetSnmp *s, entity_mib_entLogicalEntry_t ***entLogicalEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 0};

    *entLogicalEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 12, 11, entLogicalEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *entLogicalEntry = (entity_mib_entLogicalEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(entity_mib_entLogicalEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*entLogicalEntry)[i] = assign_entLogicalEntry(row->data);
        }
    }
}

void
entity_mib_get_entLogicalEntry(GNetSnmp *s, entity_mib_entLogicalEntry_t **entLogicalEntry, gint32 entLogicalIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, entLogicalEntry_oid, sizeof(entLogicalEntry_oid));
    len = pack_entLogicalEntry(base, entLogicalIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "entLogicalEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *entLogicalEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 11, entLogicalEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *entLogicalEntry = assign_entLogicalEntry(out);
    }
}

void
entity_mib_free_entLogicalEntry(entity_mib_entLogicalEntry_t *entLogicalEntry)
{
    GList *vbl;
    char *p;

    if (entLogicalEntry) {
        p = (char *) entLogicalEntry + sizeof(entity_mib_entLogicalEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(entLogicalEntry);
    }
}

void
entity_mib_free_entLogicalTable(entity_mib_entLogicalEntry_t **entLogicalEntry)
{
    int i;

    if (entLogicalEntry) {
        for (i = 0; entLogicalEntry[i]; i++) {
            entity_mib_free_entLogicalEntry(entLogicalEntry[i]);
        }
        g_free(entLogicalEntry);
    }
}

entity_mib_entLPMappingEntry_t *
entity_mib_new_entLPMappingEntry()
{
    entity_mib_entLPMappingEntry_t *entLPMappingEntry;

    entLPMappingEntry = (entity_mib_entLPMappingEntry_t *) g_malloc0(sizeof(entity_mib_entLPMappingEntry_t) + sizeof(gpointer));
    return entLPMappingEntry;
}

static inline int
unpack_entLPMappingEntry(GNetSnmpVarBind *vb, entity_mib_entLPMappingEntry_t *entLPMappingEntry)
{
    guint8 idx = 12;

    if (vb->oid_len < idx) return -1;
    entLPMappingEntry->entLogicalIndex = vb->oid[idx++];
    if ((entLPMappingEntry->entLogicalIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    entLPMappingEntry->entLPPhysicalIndex = vb->oid[idx++];
    if ((entLPMappingEntry->entLPPhysicalIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_entLPMappingEntry(guint32 *base, gint32 entLogicalIndex, gint32 entLPPhysicalIndex)
{
    guint8 idx = 12;

    base[idx++] = entLogicalIndex;
    base[idx++] = entLPPhysicalIndex;
    return idx;
}

static inline entity_mib_entLPMappingEntry_t *
assign_entLPMappingEntry(GList *vbl)
{
    entity_mib_entLPMappingEntry_t *entLPMappingEntry;
    char *p;

    entLPMappingEntry = entity_mib_new_entLPMappingEntry();
    p = (char *) entLPMappingEntry + sizeof(entity_mib_entLPMappingEntry_t);
    * (GList **) p = vbl;

    if (unpack_entLPMappingEntry((GNetSnmpVarBind *) vbl->data, entLPMappingEntry) < 0) {
        g_warning("%s: invalid instance identifier", "entLPMappingEntry");
        g_free(entLPMappingEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, entLPMappingEntry_oid, G_N_ELEMENTS(entLPMappingEntry_oid),
                      entLPMappingEntry_attr, entLPMappingEntry);

    return entLPMappingEntry;
}

void
entity_mib_get_entLPMappingTable(GNetSnmp *s, entity_mib_entLPMappingEntry_t ***entLPMappingEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 47, 1, 3, 1, 1, 0};

    *entLPMappingEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 12, 11, entLPMappingEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *entLPMappingEntry = (entity_mib_entLPMappingEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(entity_mib_entLPMappingEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*entLPMappingEntry)[i] = assign_entLPMappingEntry(row->data);
        }
    }
}

void
entity_mib_get_entLPMappingEntry(GNetSnmp *s, entity_mib_entLPMappingEntry_t **entLPMappingEntry, gint32 entLogicalIndex, gint32 entLPPhysicalIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, entLPMappingEntry_oid, sizeof(entLPMappingEntry_oid));
    len = pack_entLPMappingEntry(base, entLogicalIndex, entLPPhysicalIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "entLPMappingEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *entLPMappingEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 11, entLPMappingEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *entLPMappingEntry = assign_entLPMappingEntry(out);
    }
}

void
entity_mib_free_entLPMappingEntry(entity_mib_entLPMappingEntry_t *entLPMappingEntry)
{
    GList *vbl;
    char *p;

    if (entLPMappingEntry) {
        p = (char *) entLPMappingEntry + sizeof(entity_mib_entLPMappingEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(entLPMappingEntry);
    }
}

void
entity_mib_free_entLPMappingTable(entity_mib_entLPMappingEntry_t **entLPMappingEntry)
{
    int i;

    if (entLPMappingEntry) {
        for (i = 0; entLPMappingEntry[i]; i++) {
            entity_mib_free_entLPMappingEntry(entLPMappingEntry[i]);
        }
        g_free(entLPMappingEntry);
    }
}

entity_mib_entAliasMappingEntry_t *
entity_mib_new_entAliasMappingEntry()
{
    entity_mib_entAliasMappingEntry_t *entAliasMappingEntry;

    entAliasMappingEntry = (entity_mib_entAliasMappingEntry_t *) g_malloc0(sizeof(entity_mib_entAliasMappingEntry_t) + sizeof(gpointer));
    return entAliasMappingEntry;
}

static inline int
unpack_entAliasMappingEntry(GNetSnmpVarBind *vb, entity_mib_entAliasMappingEntry_t *entAliasMappingEntry)
{
    guint8 idx = 12;

    if (vb->oid_len < idx) return -1;
    entAliasMappingEntry->entPhysicalIndex = vb->oid[idx++];
    if ((entAliasMappingEntry->entPhysicalIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    entAliasMappingEntry->entAliasLogicalIndexOrZero = vb->oid[idx++];
    if ((entAliasMappingEntry->entAliasLogicalIndexOrZero < 0)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_entAliasMappingEntry(guint32 *base, gint32 entPhysicalIndex, gint32 entAliasLogicalIndexOrZero)
{
    guint8 idx = 12;

    base[idx++] = entPhysicalIndex;
    base[idx++] = entAliasLogicalIndexOrZero;
    return idx;
}

static inline entity_mib_entAliasMappingEntry_t *
assign_entAliasMappingEntry(GList *vbl)
{
    entity_mib_entAliasMappingEntry_t *entAliasMappingEntry;
    char *p;

    entAliasMappingEntry = entity_mib_new_entAliasMappingEntry();
    p = (char *) entAliasMappingEntry + sizeof(entity_mib_entAliasMappingEntry_t);
    * (GList **) p = vbl;

    if (unpack_entAliasMappingEntry((GNetSnmpVarBind *) vbl->data, entAliasMappingEntry) < 0) {
        g_warning("%s: invalid instance identifier", "entAliasMappingEntry");
        g_free(entAliasMappingEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, entAliasMappingEntry_oid, G_N_ELEMENTS(entAliasMappingEntry_oid),
                      entAliasMappingEntry_attr, entAliasMappingEntry);

    return entAliasMappingEntry;
}

void
entity_mib_get_entAliasMappingTable(GNetSnmp *s, entity_mib_entAliasMappingEntry_t ***entAliasMappingEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 47, 1, 3, 2, 1, 0};

    *entAliasMappingEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 12, 11, entAliasMappingEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *entAliasMappingEntry = (entity_mib_entAliasMappingEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(entity_mib_entAliasMappingEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*entAliasMappingEntry)[i] = assign_entAliasMappingEntry(row->data);
        }
    }
}

void
entity_mib_get_entAliasMappingEntry(GNetSnmp *s, entity_mib_entAliasMappingEntry_t **entAliasMappingEntry, gint32 entPhysicalIndex, gint32 entAliasLogicalIndexOrZero, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, entAliasMappingEntry_oid, sizeof(entAliasMappingEntry_oid));
    len = pack_entAliasMappingEntry(base, entPhysicalIndex, entAliasLogicalIndexOrZero);
    if (len < 0) {
        g_warning("%s: invalid index values", "entAliasMappingEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *entAliasMappingEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 11, entAliasMappingEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *entAliasMappingEntry = assign_entAliasMappingEntry(out);
    }
}

void
entity_mib_free_entAliasMappingEntry(entity_mib_entAliasMappingEntry_t *entAliasMappingEntry)
{
    GList *vbl;
    char *p;

    if (entAliasMappingEntry) {
        p = (char *) entAliasMappingEntry + sizeof(entity_mib_entAliasMappingEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(entAliasMappingEntry);
    }
}

void
entity_mib_free_entAliasMappingTable(entity_mib_entAliasMappingEntry_t **entAliasMappingEntry)
{
    int i;

    if (entAliasMappingEntry) {
        for (i = 0; entAliasMappingEntry[i]; i++) {
            entity_mib_free_entAliasMappingEntry(entAliasMappingEntry[i]);
        }
        g_free(entAliasMappingEntry);
    }
}

entity_mib_entPhysicalContainsEntry_t *
entity_mib_new_entPhysicalContainsEntry()
{
    entity_mib_entPhysicalContainsEntry_t *entPhysicalContainsEntry;

    entPhysicalContainsEntry = (entity_mib_entPhysicalContainsEntry_t *) g_malloc0(sizeof(entity_mib_entPhysicalContainsEntry_t) + sizeof(gpointer));
    return entPhysicalContainsEntry;
}

static inline int
unpack_entPhysicalContainsEntry(GNetSnmpVarBind *vb, entity_mib_entPhysicalContainsEntry_t *entPhysicalContainsEntry)
{
    guint8 idx = 12;

    if (vb->oid_len < idx) return -1;
    entPhysicalContainsEntry->entPhysicalIndex = vb->oid[idx++];
    if ((entPhysicalContainsEntry->entPhysicalIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    entPhysicalContainsEntry->entPhysicalChildIndex = vb->oid[idx++];
    if ((entPhysicalContainsEntry->entPhysicalChildIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_entPhysicalContainsEntry(guint32 *base, gint32 entPhysicalIndex, gint32 entPhysicalChildIndex)
{
    guint8 idx = 12;

    base[idx++] = entPhysicalIndex;
    base[idx++] = entPhysicalChildIndex;
    return idx;
}

static inline entity_mib_entPhysicalContainsEntry_t *
assign_entPhysicalContainsEntry(GList *vbl)
{
    entity_mib_entPhysicalContainsEntry_t *entPhysicalContainsEntry;
    char *p;

    entPhysicalContainsEntry = entity_mib_new_entPhysicalContainsEntry();
    p = (char *) entPhysicalContainsEntry + sizeof(entity_mib_entPhysicalContainsEntry_t);
    * (GList **) p = vbl;

    if (unpack_entPhysicalContainsEntry((GNetSnmpVarBind *) vbl->data, entPhysicalContainsEntry) < 0) {
        g_warning("%s: invalid instance identifier", "entPhysicalContainsEntry");
        g_free(entPhysicalContainsEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, entPhysicalContainsEntry_oid, G_N_ELEMENTS(entPhysicalContainsEntry_oid),
                      entPhysicalContainsEntry_attr, entPhysicalContainsEntry);

    return entPhysicalContainsEntry;
}

void
entity_mib_get_entPhysicalContainsTable(GNetSnmp *s, entity_mib_entPhysicalContainsEntry_t ***entPhysicalContainsEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 47, 1, 3, 3, 1, 0};

    *entPhysicalContainsEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 12, 11, entPhysicalContainsEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *entPhysicalContainsEntry = (entity_mib_entPhysicalContainsEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(entity_mib_entPhysicalContainsEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*entPhysicalContainsEntry)[i] = assign_entPhysicalContainsEntry(row->data);
        }
    }
}

void
entity_mib_get_entPhysicalContainsEntry(GNetSnmp *s, entity_mib_entPhysicalContainsEntry_t **entPhysicalContainsEntry, gint32 entPhysicalIndex, gint32 entPhysicalChildIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, entPhysicalContainsEntry_oid, sizeof(entPhysicalContainsEntry_oid));
    len = pack_entPhysicalContainsEntry(base, entPhysicalIndex, entPhysicalChildIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "entPhysicalContainsEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *entPhysicalContainsEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 11, entPhysicalContainsEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *entPhysicalContainsEntry = assign_entPhysicalContainsEntry(out);
    }
}

void
entity_mib_free_entPhysicalContainsEntry(entity_mib_entPhysicalContainsEntry_t *entPhysicalContainsEntry)
{
    GList *vbl;
    char *p;

    if (entPhysicalContainsEntry) {
        p = (char *) entPhysicalContainsEntry + sizeof(entity_mib_entPhysicalContainsEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(entPhysicalContainsEntry);
    }
}

void
entity_mib_free_entPhysicalContainsTable(entity_mib_entPhysicalContainsEntry_t **entPhysicalContainsEntry)
{
    int i;

    if (entPhysicalContainsEntry) {
        for (i = 0; entPhysicalContainsEntry[i]; i++) {
            entity_mib_free_entPhysicalContainsEntry(entPhysicalContainsEntry[i]);
        }
        g_free(entPhysicalContainsEntry);
    }
}

entity_mib_entityGeneral_t *
entity_mib_new_entityGeneral()
{
    entity_mib_entityGeneral_t *entityGeneral;

    entityGeneral = (entity_mib_entityGeneral_t *) g_malloc0(sizeof(entity_mib_entityGeneral_t) + sizeof(gpointer));
    return entityGeneral;
}

static inline entity_mib_entityGeneral_t *
assign_entityGeneral(GList *vbl)
{
    entity_mib_entityGeneral_t *entityGeneral;
    char *p;

    entityGeneral = entity_mib_new_entityGeneral();
    p = (char *) entityGeneral + sizeof(entity_mib_entityGeneral_t);
    * (GList **) p = vbl;

    gnet_snmp_attr_assign(vbl, entityGeneral_oid, G_N_ELEMENTS(entityGeneral_oid),
                      entityGeneral_attr, entityGeneral);

    return entityGeneral;
}

void
entity_mib_get_entityGeneral(GNetSnmp *s, entity_mib_entityGeneral_t **entityGeneral, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 47, 1, 4, 0};

    *entityGeneral = NULL;

    gnet_snmp_attr_get(s, &in, base, 10, 9, entityGeneral_attr, mask);

    out = gnet_snmp_sync_getnext(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *entityGeneral = assign_entityGeneral(out);
    }
}

void
entity_mib_free_entityGeneral(entity_mib_entityGeneral_t *entityGeneral)
{
    GList *vbl;
    char *p;

    if (entityGeneral) {
        p = (char *) entityGeneral + sizeof(entity_mib_entityGeneral_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(entityGeneral);
    }
}


