require 'test-unit-ext'

class TestColor < Test::Unit::TestCase
  def test_color_escape_sequence
    assert_escape_sequence(["31"], color("red"))
    assert_escape_sequence(["32", "1"], color("green", :bold => true))
    assert_escape_sequence(["0"], color("reset"))
    assert_escape_sequence(["45"], color("magenta", :foreground => false))
  end

  def test_mix_color_escape_sequence
    assert_escape_sequence(["34", "1"],
                           mix_color([color("blue"),
                                      color("none", :bold => true)]))
    assert_escape_sequence(["34", "1", "4"],
                           mix_color([color("blue"),
                                      color("none", :bold => true)]) +
                           color("none", :underline => true))
    assert_escape_sequence(["34", "1", "4"],
                           color("blue") +
                           color("none", :bold => true) +
                           color("none", :underline => true))
  end

  private
  def color(name, options={})
    Test::Color.new(name, options)
  end

  def mix_color(colors)
    Test::MixColor.new(colors)
  end

  def assert_escape_sequence(expected, color)
    assert_equal(expected, color.sequence)
    assert_match(/\e\[(?:\d+;)*\d+m/, color.escape_sequence)
    assert_equal(expected, color.escape_sequence[2..-2].split(";"))
  end
end
