
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

void
decode_msg (char *msg);

void
decode_msg (char *msg)
{
    RArray *items;
    RXpArrayEntry *entry;
    unsigned int length;

    length = rxp_decode_msg_length (msg);
    printf ("total message length is %u bytes\n", length);
    
    items = rxp_decode_data (msg);
    
    RARRAY_FOREACH (items, entry) {
        if (entry->type == RXP_TYPE_RBUF) {
            printf ("received rbuf: '%s'\n", rbuf_str (entry->data.buf));
            rbuf_free (entry->data.buf);
        } else if (entry->type == RXP_TYPE_NULL_RBUF) {
            printf ("received NULL rbuf\n");
        } else {
            printf ("received rint32: %ld\n", (long int) entry->data.intval);
        }
    } RFOREACH_CLOSE;
    
    rarray_free (items);
}

int main (void)
{
    RXpEncoder *encoder;

   
    rinit ();
    
    encoder = rxp_encoder_new ();
    rxp_encode_rbuf (encoder, rbuf_new_with_str ("Hello there everyone!"));
    decode_msg (encoder->data);

    rxp_encode_reset (encoder);
    rxp_encode_rint32 (encoder, 1234567);
    rxp_encode_rint32 (encoder, 1);
    rxp_encode_rbuf (encoder, rbuf_new_with_str ("asdfa;sldkjfa;lsdkfja;lskdjfa;lskdjfa;lskdjfa;lskdjfa;slkdfja;sdlkfj"));
    rxp_encode_rint32 (encoder, -1234567);
    rxp_encode_rint32 (encoder, 1234567);
    rxp_encode_rbuf (encoder, rbuf_new_with_str ("string 1"));
    rxp_encode_rbuf (encoder, rbuf_new_with_str ("string 2"));
    rxp_encode_rbuf (encoder, NULL);
    rxp_encode_rint32 (encoder, 1234567);
    decode_msg (encoder->data);
    
    rxp_encode_reset (encoder);
    decode_msg (encoder->data);
   
    rxp_encoder_free (encoder);

    rcleanup ();

    return 0;
}



