
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

int
main (void)
{
    FILE *fp;
    RBuf *buf1;
    RBuf *buf2;
    unsigned int val1;
    unsigned int val2 = 0; /* initialized to silence compiler warning */
    int num_entries = 0;
    char buf[2048];

    fp = fopen ("sample-keys.txt", "r");
    if (!fp) {
        printf ("Unable to open file 'sample-keys.txt', exiting\n");
        exit (1);
    }

    rinit ();

    while (fgets (buf, sizeof (buf), fp)) {

        buf[strlen (buf) - 1] = '\0';

        buf1 = rbuf_new_with_str (buf);
        buf2 = rbuf_new_with_str (buf);
        val1 = rbuf_intern (buf1);
    
        /* Insure that interning, and regetting by that id returns the same string */
        buf1 = rbuf_intern_get_buf (val1);
        if (!rbuf_equal_rbuf (buf1, buf2)) {
            printf ("buf in val %d is not '%s', it is '%s'\n", val1,
                    rbuf_str (buf2), rbuf_str (buf1));
        }

        /* Insure that interning the same string again gets you the same id */
        val2 = rbuf_intern (buf2);
        if (val1 != val2) {
            printf ("the same string given twice did not return the same value!\n");
        }

        num_entries++;

        /* Check every once in a while to make sure that unrefing will clean
         * entry */
        if (! (num_entries % 3)) {
            rbuf_intern_unref (val1);
            rbuf_intern_unref (val1);
            buf1 = rbuf_intern_get_buf (val1);
            if (buf1) {
                printf ("unref'ing didn't clean out entry!\n");
            }
        }
    }

    printf ("inserted %d unique strings, using values up to %d\n", num_entries, val2);
    printf ("(values should be approximately 2/3 of unique strings)\n");
    
    rcleanup ();

    return (0);
}


