
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>



typedef struct _RNodeAttrib     RNodeAttrib;

struct _RNodeAttrib {
    RBHASH_HEADER;
    RBuf *attrib;
    RBuf *value;
};


/* Length */
unsigned int
rnode_attrib_length     (RNode *node, RBuf *attrib,
                         RBuf **err)
{
    RNodeAttrib *attrib_entry;

    attrib_entry = rbhash_lookup (node->attribs, attrib);
    if (!attrib_entry) {
        *err = rbuf_new_with_str ("RNode:attrib_length: Attribute is unset");
        return (0);
    }

    return (rbuf_len (attrib_entry->attrib));
}



/* Get methods */
RBuf *
rnode_attrib_get        (RNode *node, RBuf *attrib,
                         RBuf **err)
{
    RNodeAttrib *attrib_entry;

    attrib_entry = rbhash_lookup (node->attribs, attrib);
    if (!attrib_entry) {
        *err = rbuf_new_with_str ("RNode:attrib_get: Attribute is unset.");
        return (NULL);
    }

    return (attrib_entry->value);
}


RBuf *
rnode_attrib_get_chunk  (RNode *node, RBuf *attrib,
                         unsigned int offset, unsigned int count,
                         RBuf **err)
{
    RNodeAttrib *attrib_entry;
    unsigned int real_count;
    RBuf *chunk;
    char *str;

    attrib_entry = rbhash_lookup (node->attribs, attrib);
    if (!attrib_entry) {
        *err = rbuf_new_with_str ("RNode:attrib_get_chunk: Attribute is unset.");
        return (NULL);
    }

    if (offset > rbuf_len (attrib_entry->value)) {
        *err = rbuf_new_with_str ("RNode:attrib_get_chunk: Requested offset is beyond end of attribute.");
        return (NULL);
    }

    /* If the count is longer than than the length of the value, just return what is left */
    if (offset + count > rbuf_len (attrib_entry->value)) {
        real_count = rbuf_len (attrib_entry->value) - offset;
    } else {
        real_count = count;
    }

    str = rbuf_str (attrib_entry->value);
    chunk = rbuf_new_with_data (str + offset, real_count);
    
    return (chunk);
}



/* Set methods */
void
rnode_attrib_set        (RNode *node, RBuf *attrib, RBuf *value,
                         RBuf **err)
{
    RNodeAttrib *attrib_entry;

    attrib_entry = rbhash_lookup (node->attribs, attrib);
    if (!attrib_entry) {
        attrib_entry = rchunk_alloc (sizeof (RNodeAttrib));
        attrib_entry->value = NULL;
        if (rbuf_owned (attrib)) {
            attrib = rbuf_new_with_rbuf (attrib);
        }
        rbhash_entry_setkey (attrib_entry, attrib);
        rbuf_own (attrib);
    } 

    if (rbuf_owned (value)) {
        rbuf_set_to_rbuf (attrib_entry->value, value);
    } else {
        if (attrib_entry->value) {
            rbuf_release (attrib_entry->value);
            rbuf_free (attrib_entry->value);
        }
        attrib_entry->value = value;
        rbuf_own (attrib_entry->value);
    }

    rbhash_insert (node->attribs, attrib_entry, rbhash_entry_getkey (attrib_entry));
}


void
rnode_attrib_append     (RNode *node, RBuf *attrib, RBuf *data,
                         RBuf **err)
{

}


void
rnode_attrib_insert     (RNode *node, RBuf *attrib,
                         unsigned int offset, RBuf *data,
                         RBuf **err)
{

}


void
rnode_attrib_delete     (RNode *node, RBuf *attrib,
                         unsigned int offset, unsigned int count,
                         RBuf **err)
{

}




