
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

typedef struct
{
    RHASH_HEADER;
    /* node is the key */
    unsigned int node_id;
    int refcount;
} RNMapEntry;


RNMap *
rnmap_new (void)
{
    RNMap *map;

    map = rmem_alloc (sizeof (RNMap));
    map->id_to_node = rarray_new (sizeof (RNMapEntry *), 1024);
    map->available_ids = rarray_new (sizeof (int), 1024);
    map->node_to_id = rhash_new (NULL, NULL);
    map->current_id = 0;

    /* Set the first entry to the NULL node */
    rnmap_to_id (map, NULL);
    
    return (map);
}


RNode *
rnmap_to_node (RNMap *map, int node_id)
{
    RNMapEntry *entry;
    RNMapEntry **tmp_entry;

    tmp_entry = rarray_nth (map->id_to_node, node_id);
    entry = *tmp_entry;

    if (entry) {
        return (rhash_entry_getkey (entry));
    } else {
        return (NULL);
    }
}

int
rnmap_to_id (RNMap *map, RNode *node)
{
    RNMapEntry *entry;
    RNMapEntry **tmp_entry;
    int *idp;
    int id;

    /* First thing to do is to check to see if this entry doesn't already
     * exist */
    entry = rhash_lookup (map->node_to_id, node);
    if (entry) {
        /* We have an entry already, so we ref it, and return the value. */
        entry->refcount++;
        return (entry->node_id);
    }

    /* if we make it this far, there's no previous entry, so we set one up. */
    entry = rchunk_alloc (sizeof (RNMapEntry));
   
    entry->refcount = 1;
    rhash_insert (map->node_to_id, entry, node);
   
    /* See if there's a value we can recycle.  We do this because we want our
     * array to use up all of the lower, available slots */
    idp = rarray_pop (map->available_ids);
    if (idp) {
        /* We are recycling a previous entry, so insert into
         * the array using nth() */
        id = *idp;
        tmp_entry = rarray_nth (map->id_to_node, id);
    } else {
        /* We are using a new value, so we use append()
         * on the array so it can grow */
        id = map->current_id++;
        tmp_entry = rarray_append (map->id_to_node);
    }
    *tmp_entry = entry;
    entry->node_id = id;
    
    return (id);

}

void
rnmap_ref_id (RNMap *map, int node_id)
{

}

void
rnmap_ref_node (RNMap *map, RNode *node)
{

}

void
rnmap_unref_id (RNMap *map, int node_id)
{

}

void
rnmap_unref_node (RNMap *map, RNode *node)
{

}



