//file.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2012
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#include "libroar.h"

int roar_file_codecdetect(const char * buf, const int len) {
 int codec = -1;

 if ( len > 3 ) {
  if ( strncmp(buf, "OggS", 4) == 0 ) {
   codec = ROAR_CODEC_OGG_GENERAL;
   if ( len > 32 ) { // this is 5 bytes after the end of the header
    if ( strncmp(buf+28, "\177FLAC", 5) == 0 ) {
     codec = ROAR_CODEC_OGG_FLAC;
    } else if ( strncmp(buf+28, "Speex", 5) == 0 ) {
     codec = ROAR_CODEC_OGG_SPEEX;
    } else if ( len > 34 ) { // this is 7 bytes after the end of the header
     if ( strncmp(buf+28, "\001vorbis", 7) == 0 )
      codec = ROAR_CODEC_OGG_VORBIS;
    }
   }
  } else if ( strncmp(buf, "MThd", 4) == 0 ) {
   codec = ROAR_CODEC_MIDI_FILE;
  } else if ( strncmp(buf, "RIFF", 4) == 0 ) {
   if ( len > 15 ) {
    if ( strncmp(buf+8, "WAVEfmt ", 8) == 0 )
     codec = ROAR_CODEC_RIFF_WAVE;
   }
  } else if ( strncmp(buf, "Roar", 4) == 0 ) {
   if ( len > ROAR_SPEEX_MAGIC_LEN ) {
    if ( strncmp(buf, ROAR_SPEEX_MAGIC, ROAR_SPEEX_MAGIC_LEN) == 0 )
     codec = ROAR_CODEC_ROAR_SPEEX;
#if ROAR_SPEEX_MAGIC_LEN < ROAR_CELT_MAGIC_LEN
   }
   if ( len > ROAR_CELT_MAGIC_LEN ) {
#endif
    if ( strncmp(buf, ROAR_CELT_MAGIC_0, ROAR_CELT_MAGIC_LEN) == 0 ||
         strncmp(buf, ROAR_CELT_MAGIC_1, ROAR_CELT_MAGIC_LEN) == 0  )
     codec = ROAR_CODEC_ROAR_CELT;
   }
  } else if ( strncmp(buf, "fLaC", 4) == 0 ) {
   codec = ROAR_CODEC_FLAC;
  } else if ( strncmp(buf, ".snd", 4) == 0 ) {
   codec = ROAR_CODEC_AU;
  } else if ( len > 7 && strncmp(buf, "RAUM-CF0", 8) == 0 ) {
   codec = ROAR_CODEC_RAUM;
  }
 }

 return codec;
}

const char  * roar_cdromdevice     (void) {
 const char * k;

 if ( (k = getenv("CDDA_DEVICE")) != NULL )
  return k;

#ifdef ROAR_DEFAULT_CDROM
 return ROAR_DEFAULT_CDROM;
#endif

 roar_err_set(ROAR_ERROR_NODEV);
 return NULL;
}

//ll
