///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// test des formes grad_grad_s et mass_s
//
#include "rheolef.h"
using namespace std;
using namespace rheolef;
// --------------------------------------------------------------------------------
// definition de phi
// --------------------------------------------------------------------------------
point origin (0.5,0.5,0);
point normal (0,1,0);

Float levelset_function (const point& x) {
    return dot(normal, x-origin); // definition de la fonction level set//
}
// test
string i_test = "1";
Float u (const point& x) {
    if (i_test == "1") return 1;
    if (i_test == "x") return x[0];
    if (i_test == "y") return x[1];
    if (i_test == "z") return x[2];
    if (i_test == "x2") return sqr(x[0]);
    if (i_test == "y2") return sqr(x[1]);
    if (i_test == "z2") return sqr(x[2]);
    if (i_test == "xy") return x[0]*x[1];
    if (i_test == "xz") return x[0]*x[2];
    if (i_test == "yz") return x[1]*x[2];
    error_macro ("invalid test " << i_test);
}
void save_as_matlab (const form& a, string name = "a") {
    string filename = "matrix-" + name + ".m";
    ofstream out (filename.c_str());
    cerr << "! file " << filename << " created." << endl;
    out << setprecision(15) 
        << name << " = " << matlab << a.uu << ";" << endl
        << "vp = eig(" << name <<");" << endl
        << "printf (\"vp = %26.16g\\n\", vp);" << endl
        << "d = det(" << name << ")" << endl
        ;
    out.close();
}
void save_as_matlab (const field& u, string name = "u") {
    string filename = "vector-" + name + ".m";
    ofstream out (filename.c_str());
    cerr << "! file " << filename << " created." << endl;
    out << setprecision(15) 
        << name << " = " << matlab << u.u << ";" << endl
        ;
    out.close();
}
void 
usage () {
  cerr << "usage: grad_grad_tst " 
       << "mesh.geo " 
       << "-normal x y z" 
       << "-origin x y z" 
       << "-a val " 
       << "-m val " 
       << "-test poly " 
       << endl;
  exit (1);
}
int main (int argc, char**argv)
{
    Float a_valid = 0;
    Float m_valid = -1;
    string filename;
    for (int i = 1; i < argc; i++) {

        if (strcmp (argv[i], "-test") == 0)   {
	    if (i+1 == argc) usage();
	    i_test = argv[++i];
        } else if (strcmp (argv[i], "-a") == 0)   {
	    if (i+1 == argc || !is_float(argv[i+1])) usage();
	    a_valid = to_float (argv[++i]);
        } else if (strcmp (argv[i], "-m") == 0)   {
	    if (i+1 == argc || !is_float(argv[i+1])) usage();
	    m_valid = to_float (argv[++i]);
        } else if ((strcmp (argv[i], "-origin") == 0) || (strcmp (argv[i], "-normal") == 0))   {
            point x;
	    unsigned int io = i;
	    if (i+1 == argc || !is_float(argv[i+1])) {
	    	warning_macro ("invalid argument to `" << argv[i] << "'");
	    	usage();
	    }
	    x[0] = to_float (argv[++i]);
	    if (i+1 < argc && is_float(argv[i+1])) {
	        x[1] = to_float (argv[++i]);
	        if (i+1 < argc && is_float(argv[i+1])) {
	            x[2] = to_float (argv[++i]);
	        }	
	    }	
            if (strcmp (argv[io], "-origin") == 0)   {
	       origin = x;
	    } else {
	       normal = x;
	    }
	} else {
            // input on file
            filename = argv[i];
        }
    }
    if (filename == "") usage();
    geo mesh(filename);
    space Vh (mesh, "P1");
    field phi_h_lambda = interpolate(Vh, levelset_function);
    geo band = banded_level_set (phi_h_lambda);
    if (mesh.dimension() == 3) {
        cout << "$ DATA = CONTCURVE" << endl
             << "% equalscale" << endl
             << "%contstyle=2 # fill color painting" << endl
             << "%meshplot" << endl
             << "%contlabel=false # write labels when using line style contours" << endl;
    }
    phi_h_lambda.save("phi");
    space Bh (band, "P1");
    field phi_h = interpolate(Bh, levelset_function);
    form a = form (Bh, Bh, "grad_grad_s", phi_h);
    form m = form (Bh, Bh, "mass_s",      phi_h);
    save_as_matlab (a, "a");
    save_as_matlab (m, "m");
    save_as_matlab (phi_h, "phi");
    field uh = interpolate (Bh, u);
    Float a_tst = a(uh,uh);
    Float m_tst = m(uh,uh);
    cerr << setprecision(15);
    cerr << "m(uh,uh)=" << m_tst << endl;
    cerr << "a(uh,uh)=" << a_tst << endl;
    Float tol = 1e-7;
    bool status = (fabs(a_tst - a_valid) < tol) && (m_valid < 0 || fabs(m_tst - m_valid) < tol) ;
    if (! status) {
      if (                fabs(a_tst - a_valid) >= tol) cerr << "ERROR: a(uh,uh)=" << a_tst << " != " << a_valid << endl;
      if (m_valid >= 0 && fabs(m_tst - m_valid) >= tol) cerr << "ERROR: m(uh,uh)=" << m_tst << " != " << m_valid << endl;
    }
    return (status ? 0 : 1); 
}
