///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// compute:
//  -\int_\Omega dx = mes(\Omega)
//
// usage:
//  form_diag_mass_tst -I../data carre

#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

void usage()
{
      cerr << "form_diag_mass_tst: usage: form_diag_mass_tst"
	   << " approx"
	   << " {-Igeodir}*"
	   << " -|mesh[.geo]"
	   << " {domain}+"
	   << endl;
      cerr << "example:\n";
      cerr << "  form_diag_mass_tst P1 -I../geo carre\n";
      exit (1);
}
int main(int argc, char**argv)
{
warning_macro ("main(int argc, char**argv)...");
    
    if (argc <= 2) usage();
    //
    // load geometry
    //
    char* approx = argv[1];
    geo g;  
    int io = 2; 
    while (argv [io][0] == '-' && argv [io][1] == 'I') {
	append_dir_to_rheo_path (argv[io]+2);
	io++;
    }
    if (strcmp (argv[io], "-") == 0) {
	// input geo on standard input
        cerr << "! form_solve: geo on stdin\n";
	cin >> g;
      
    } else {
    
	// input geo on file
warning_macro(" input geo on file...");
  	g = geo(argv[io]);
warning_macro(" input geo on file done.");
    }
    //
    // build space & forms
    //
warning_macro(" build space...");
    space V(g, approx);
warning_macro(" build space done.");
    for (int i = io+1; i < argc; i++) {
		      
      // block a domain
      cerr << "! form_solve: block `" << argv[i] << "'\n";
      V.block (argv[i]);
    }
warning_macro(" blocking domains done.");
    //
    // compute area
    //
warning_macro("diag_assembly...");
    form_diag m(V,"mass");
warning_macro("diag_assembly done.");
    field one(V);
    one = 1;
    Float mes_omega = dot(one,m*one);

    // when double: print 1
    // when bigfloat: print 1.00000
    // so, cast in double, for non-regression test purpose.
    cout << "mes(omega) = " << double(mes_omega) << endl;
    return 0;
}
