% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zap_inf.R
\name{zap_inf}
\alias{zap_inf}
\title{Convert infiite or NaN values into regular NA}
\usage{
zap_inf(x, ...)
}
\arguments{
\item{x}{A vector or a data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
select-helpers.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}
}
\value{
\code{x}, where all \code{Inf}, \code{-Inf} and \code{NaN} are converted to \code{NA}.
}
\description{
Replaces all infinite (\code{Inf} and \code{-Inf}) or \code{NaN}
               values with regular \code{NA}.
}
\examples{
x <- c(1, 2, NA, 3, NaN, 4, NA, 5, Inf, -Inf, 6, 7)
zap_inf(x)

data(efc)
# produce some NA and NaN values
efc$e42dep[1] <- NaN
efc$e42dep[2] <- NA
efc$c12hour[1] <- NaN
efc$c12hour[2] <- NA
efc$e17age[2] <- NaN
efc$e17age[1] <- NA

# only zap NaN for c12hour
zap_inf(efc$c12hour)

# only zap NaN for c12hour and e17age, not for e42dep,
# but return complete data framee
zap_inf(efc, c12hour, e17age)

# zap NaN for complete data frame
zap_inf(efc)

}
