% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resamples.R
\name{xyplot.resamples}
\alias{xyplot.resamples}
\alias{densityplot.resamples}
\alias{bwplot.resamples}
\alias{splom.resamples}
\alias{parallelplot.resamples}
\alias{dotplot.resamples}
\alias{ggplot.resamples}
\title{Lattice Functions for Visualizing Resampling Results}
\usage{
\method{xyplot}{resamples}(x, data = NULL, what = "scatter",
  models = NULL, metric = x$metric[1], units = "min", ...)

\method{parallelplot}{resamples}(x, data = NULL, models = x$models,
  metric = x$metric[1], ...)

\method{splom}{resamples}(x, data = NULL, variables = "models",
  models = x$models, metric = NULL, panelRange = NULL, ...)

\method{densityplot}{resamples}(x, data = NULL, models = x$models,
  metric = x$metric, ...)

\method{bwplot}{resamples}(x, data = NULL, models = x$models,
  metric = x$metric, ...)

\method{dotplot}{resamples}(x, data = NULL, models = x$models,
  metric = x$metric, conf.level = 0.95, ...)

\method{ggplot}{resamples}(data = NULL, mapping = NULL,
  environment = NULL, models = data$models, metric = data$metric[1],
  conf.level = 0.95, ...)
}
\arguments{
\item{x}{an object generated by \code{resamples}}

\item{data}{Only used for the \code{ggplot} method; an object generated by
\code{resamples}}

\item{what}{for \code{xyplot}, the type of plot. Valid options are:
"scatter" (for a plot of the resampled results between two models),
"BlandAltman" (a Bland-Altman, aka MA plot between two models), "tTime" (for
the total time to run \code{train} versus the metric), "mTime" (for the time
to build the final model) or "pTime" (the time to predict samples - see the
\code{timingSamps} options in \code{\link{trainControl}},
\code{\link{rfeControl}}, or \code{\link{sbfControl}})}

\item{models}{a character string for which models to plot. Note:
\code{xyplot} requires one or two models whereas the other methods can plot
more than two.}

\item{metric}{a character string for which metrics to use as conditioning
variables in the plot. \code{splom} requires exactly one metric when
\code{variables = "models"} and at least two when \code{variables =
"metrics"}.}

\item{units}{either "sec", "min" or "hour"; which \code{what} is either
"tTime", "mTime" or "pTime", how should the timings be scaled?}

\item{\dots}{further arguments to pass to either
\code{\link[lattice:histogram]{histogram}},
\code{\link[lattice:histogram]{densityplot}},
\code{\link[lattice:xyplot]{xyplot}}, \code{\link[lattice:xyplot]{dotplot}}
or \code{\link[lattice:splom]{splom}}}

\item{variables}{either "models" or "metrics"; which variable should be
treated as the scatter plot variables?}

\item{panelRange}{a common range for the panels. If \code{NULL}, the panel
ranges are derived from the values across all the models}

\item{conf.level}{the confidence level for intervals about the mean
(obtained using \code{\link[stats]{t.test}})}

\item{mapping, environment}{Not used.}
}
\value{
a lattice object
}
\description{
Lattice and ggplot functions for visualizing resampling results across models
}
\details{
The ideas and methods here are based on Hothorn et al. (2005) and Eugster et
al. (2008).

\code{dotplot} and \code{ggplot} plots the average performance value (with two-sided
confidence limits) for each model and metric.

\code{densityplot} and \code{bwplot} display univariate visualizations of
the resampling distributions while \code{splom} shows the pair-wise
relationships.
}
\examples{

\dontrun{
#load(url("http://topepo.github.io/caret/exampleModels.RData"))

resamps <- resamples(list(CART = rpartFit,
                          CondInfTree = ctreeFit,
                          MARS = earthFit))

dotplot(resamps,
        scales =list(x = list(relation = "free")),
        between = list(x = 2))

bwplot(resamps,
       metric = "RMSE")

densityplot(resamps,
            auto.key = list(columns = 3),
            pch = "|")

xyplot(resamps,
       models = c("CART", "MARS"),
       metric = "RMSE")

splom(resamps, metric = "RMSE")
splom(resamps, variables = "metrics")

parallelplot(resamps, metric = "RMSE")


}

}
\references{
Hothorn et al. The design and analysis of benchmark experiments.
Journal of Computational and Graphical Statistics (2005) vol. 14 (3) pp.
675-699

Eugster et al. Exploratory and inferential analysis of benchmark
experiments. Ludwigs-Maximilians-Universitat Munchen, Department of
Statistics, Tech. Rep (2008) vol. 30
}
\seealso{
\code{\link{resamples}}, \code{\link[lattice:xyplot]{dotplot}},
\code{\link[lattice:bwplot]{bwplot}},
\code{\link[lattice:histogram]{densityplot}},
\code{\link[lattice:xyplot]{xyplot}}, \code{\link[lattice:splom]{splom}}
}
\author{
Max Kuhn
}
\keyword{hplot}
