#ifndef VISUAL_ARROW_H
#define VISUAL_ARROW_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.
#include "axial.h"

namespace visual {

class arrow : public axialSymmetry
{
public:
	arrow();
	arrow( const arrow& other);
	
	virtual void glRender( rView& view);
	virtual vector getScale();
	
	double get_headwidth();
	double get_shaftwidth();
	double get_headlength();
	int get_fixedwidth() const;
	
	void set_headwidth( const double& width);
	void set_headlength( const double& length);
	void set_shaftwidth( const double& width);
	void set_fixedwidth( const int& width);
	
private:
	int fixedwidth;
	double headwidth;
	double headlength;
	// shaftwidth is actually the radius data member from the parent class.
	
	// These variables are used to cache the drawn elements when
	// There is probably a better way to go about this
	double effective_headwidth;
	double effective_shaftwidth;
	double effective_headlength;
};

} // !namespace visual

#endif // !VISUAL_AXIAL_H
